// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains the scaling configuration of an Aurora Serverless v1 DB cluster.
 *
 * For more information, see [Using Amazon Aurora Serverless v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html) in the *Amazon Aurora User Guide*.
 */
public class ScalingConfiguration private constructor(builder: Builder) {
    /**
     * Indicates whether to allow or disallow automatic pause for an Aurora DB cluster in `serverless` DB engine mode. A DB cluster can be paused only when it's idle (it has no connections).
     *
     * If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it.
     */
    public val autoPause: kotlin.Boolean? = builder.autoPause
    /**
     * The maximum capacity for an Aurora DB cluster in `serverless` DB engine mode.
     *
     * For Aurora MySQL, valid capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, and `256`.
     *
     * For Aurora PostgreSQL, valid capacity values are `2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`.
     *
     * The maximum capacity must be greater than or equal to the minimum capacity.
     */
    public val maxCapacity: kotlin.Int? = builder.maxCapacity
    /**
     * The minimum capacity for an Aurora DB cluster in `serverless` DB engine mode.
     *
     * For Aurora MySQL, valid capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, and `256`.
     *
     * For Aurora PostgreSQL, valid capacity values are `2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`.
     *
     * The minimum capacity must be less than or equal to the maximum capacity.
     */
    public val minCapacity: kotlin.Int? = builder.minCapacity
    /**
     * The amount of time, in seconds, that Aurora Serverless v1 tries to find a scaling point to perform seamless scaling before enforcing the timeout action. The default is 300.
     *
     * Specify a value between 60 and 600 seconds.
     */
    public val secondsBeforeTimeout: kotlin.Int? = builder.secondsBeforeTimeout
    /**
     * The time, in seconds, before an Aurora DB cluster in `serverless` mode is paused.
     *
     * Specify a value between 300 and 86,400 seconds.
     */
    public val secondsUntilAutoPause: kotlin.Int? = builder.secondsUntilAutoPause
    /**
     * The action to take when the timeout is reached, either `ForceApplyCapacityChange` or `RollbackCapacityChange`.
     *
     * `ForceApplyCapacityChange` sets the capacity to the specified value as soon as possible.
     *
     * `RollbackCapacityChange`, the default, ignores the capacity change if a scaling point isn't found in the timeout period.
     *
     * If you specify `ForceApplyCapacityChange`, connections that prevent Aurora Serverless v1 from finding a scaling point might be dropped.
     *
     * For more information, see [ Autoscaling for Aurora Serverless v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling) in the *Amazon Aurora User Guide*.
     */
    public val timeoutAction: kotlin.String? = builder.timeoutAction

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.ScalingConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScalingConfiguration(")
        append("autoPause=$autoPause,")
        append("maxCapacity=$maxCapacity,")
        append("minCapacity=$minCapacity,")
        append("secondsBeforeTimeout=$secondsBeforeTimeout,")
        append("secondsUntilAutoPause=$secondsUntilAutoPause,")
        append("timeoutAction=$timeoutAction")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoPause?.hashCode() ?: 0
        result = 31 * result + (maxCapacity ?: 0)
        result = 31 * result + (minCapacity ?: 0)
        result = 31 * result + (secondsBeforeTimeout ?: 0)
        result = 31 * result + (secondsUntilAutoPause ?: 0)
        result = 31 * result + (timeoutAction?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScalingConfiguration

        if (autoPause != other.autoPause) return false
        if (maxCapacity != other.maxCapacity) return false
        if (minCapacity != other.minCapacity) return false
        if (secondsBeforeTimeout != other.secondsBeforeTimeout) return false
        if (secondsUntilAutoPause != other.secondsUntilAutoPause) return false
        if (timeoutAction != other.timeoutAction) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.ScalingConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether to allow or disallow automatic pause for an Aurora DB cluster in `serverless` DB engine mode. A DB cluster can be paused only when it's idle (it has no connections).
         *
         * If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it.
         */
        public var autoPause: kotlin.Boolean? = null
        /**
         * The maximum capacity for an Aurora DB cluster in `serverless` DB engine mode.
         *
         * For Aurora MySQL, valid capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, and `256`.
         *
         * For Aurora PostgreSQL, valid capacity values are `2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`.
         *
         * The maximum capacity must be greater than or equal to the minimum capacity.
         */
        public var maxCapacity: kotlin.Int? = null
        /**
         * The minimum capacity for an Aurora DB cluster in `serverless` DB engine mode.
         *
         * For Aurora MySQL, valid capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, and `256`.
         *
         * For Aurora PostgreSQL, valid capacity values are `2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`.
         *
         * The minimum capacity must be less than or equal to the maximum capacity.
         */
        public var minCapacity: kotlin.Int? = null
        /**
         * The amount of time, in seconds, that Aurora Serverless v1 tries to find a scaling point to perform seamless scaling before enforcing the timeout action. The default is 300.
         *
         * Specify a value between 60 and 600 seconds.
         */
        public var secondsBeforeTimeout: kotlin.Int? = null
        /**
         * The time, in seconds, before an Aurora DB cluster in `serverless` mode is paused.
         *
         * Specify a value between 300 and 86,400 seconds.
         */
        public var secondsUntilAutoPause: kotlin.Int? = null
        /**
         * The action to take when the timeout is reached, either `ForceApplyCapacityChange` or `RollbackCapacityChange`.
         *
         * `ForceApplyCapacityChange` sets the capacity to the specified value as soon as possible.
         *
         * `RollbackCapacityChange`, the default, ignores the capacity change if a scaling point isn't found in the timeout period.
         *
         * If you specify `ForceApplyCapacityChange`, connections that prevent Aurora Serverless v1 from finding a scaling point might be dropped.
         *
         * For more information, see [ Autoscaling for Aurora Serverless v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling) in the *Amazon Aurora User Guide*.
         */
        public var timeoutAction: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.ScalingConfiguration) : this() {
            this.autoPause = x.autoPause
            this.maxCapacity = x.maxCapacity
            this.minCapacity = x.minCapacity
            this.secondsBeforeTimeout = x.secondsBeforeTimeout
            this.secondsUntilAutoPause = x.secondsUntilAutoPause
            this.timeoutAction = x.timeoutAction
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.ScalingConfiguration = ScalingConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
