// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 *
 */
public class RestoreDbClusterToPointInTimeRequest private constructor(builder: Builder) {
    /**
     * The target backtrack window, in seconds. To disable backtracking, set this value to 0.
     *
     * Default: 0
     *
     * Constraints:
     * + If specified, this value must be set to a number from 0 to 259,200 (72 hours).
     *
     * Valid for: Aurora MySQL DB clusters only
     */
    public val backtrackWindow: kotlin.Long? = builder.backtrackWindow
    /**
     * Specifies whether to copy all tags from the restored DB cluster to snapshots of the restored DB cluster. The default is not to copy them.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val copyTagsToSnapshot: kotlin.Boolean? = builder.copyTagsToSnapshot
    /**
     * The name of the new DB cluster to be created.
     *
     * Constraints:
     * + Must contain from 1 to 63 letters, numbers, or hyphens
     * + First character must be a letter
     * + Can't end with a hyphen or contain two consecutive hyphens
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The compute and memory capacity of the each DB instance in the Multi-AZ DB cluster, for example db.m6gd.xlarge. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.
     *
     * For the full list of DB instance classes, and availability for your engine, see [DB instance class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the *Amazon RDS User Guide*.
     *
     * Valid for: Multi-AZ DB clusters only
     */
    public val dbClusterInstanceClass: kotlin.String? = builder.dbClusterInstanceClass
    /**
     * The name of the custom DB cluster parameter group to associate with this DB cluster.
     *
     * If the `DBClusterParameterGroupName` parameter is omitted, the default DB cluster parameter group for the specified engine is used.
     *
     * Constraints:
     * + If supplied, must match the name of an existing DB cluster parameter group.
     * + Must be 1 to 255 letters, numbers, or hyphens.
     * + First character must be a letter.
     * + Can't end with a hyphen or contain two consecutive hyphens.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val dbClusterParameterGroupName: kotlin.String? = builder.dbClusterParameterGroupName
    /**
     * The DB subnet group name to use for the new DB cluster.
     *
     * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
     *
     * Example: `mydbsubnetgroup`
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val dbSubnetGroupName: kotlin.String? = builder.dbSubnetGroupName
    /**
     * Specifies whether to enable deletion protection for the DB cluster. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The Active Directory directory ID to restore the DB cluster in. The domain must be created prior to this operation.
     *
     * For Amazon Aurora DB clusters, Amazon RDS can use Kerberos Authentication to authenticate users that connect to the DB cluster. For more information, see [Kerberos Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html) in the *Amazon Aurora User Guide*.
     *
     * Valid for: Aurora DB clusters only
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * The name of the IAM role to be used when making API calls to the Directory Service.
     *
     * Valid for: Aurora DB clusters only
     */
    public val domainIamRoleName: kotlin.String? = builder.domainIamRoleName
    /**
     * The list of logs that the restored DB cluster is to export to CloudWatch Logs. The values in the list depend on the DB engine being used.
     *
     * **RDS for MySQL**
     *
     * Possible values are `error`, `general`, and `slowquery`.
     *
     * **RDS for PostgreSQL**
     *
     * Possible values are `postgresql` and `upgrade`.
     *
     * **Aurora MySQL**
     *
     * Possible values are `audit`, `error`, `general`, and `slowquery`.
     *
     * **Aurora PostgreSQL**
     *
     * Possible value is `postgresql`.
     *
     * For more information about exporting CloudWatch Logs for Amazon RDS, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon RDS User Guide*.
     *
     * For more information about exporting CloudWatch Logs for Amazon Aurora, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon Aurora User Guide*.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val enableCloudwatchLogsExports: List<String>? = builder.enableCloudwatchLogsExports
    /**
     * Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.
     *
     * For more information, see [ IAM Database Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html) in the *Amazon Aurora User Guide*.
     *
     * Valid for: Aurora DB clusters only
     */
    public val enableIamDatabaseAuthentication: kotlin.Boolean? = builder.enableIamDatabaseAuthentication
    /**
     * The life cycle type for this DB cluster.
     *
     * By default, this value is set to `open-source-rds-extended-support`, which enrolls your DB cluster into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to `open-source-rds-extended-support-disabled`. In this case, RDS automatically upgrades your restored DB cluster to a higher engine version, if the major engine version is past its end of standard support date.
     *
     * You can use this setting to enroll your DB cluster into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your DB cluster past the end of standard support for that engine version. For more information, see the following sections:
     * + Amazon Aurora (PostgreSQL only) - [Using Amazon RDS Extended Support](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html) in the *Amazon Aurora User Guide*
     * + Amazon RDS - [Using Amazon RDS Extended Support](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html) in the *Amazon RDS User Guide*
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *
     * Valid Values: `open-source-rds-extended-support | open-source-rds-extended-support-disabled`
     *
     * Default: `open-source-rds-extended-support`
     */
    public val engineLifecycleSupport: kotlin.String? = builder.engineLifecycleSupport
    /**
     * The engine mode of the new cluster. Specify `provisioned` or `serverless`, depending on the type of the cluster you are creating. You can create an Aurora Serverless v1 clone from a provisioned cluster, or a provisioned clone from an Aurora Serverless v1 cluster. To create a clone that is an Aurora Serverless v1 cluster, the original cluster must be an Aurora Serverless v1 cluster or an encrypted provisioned cluster.
     *
     * Valid for: Aurora DB clusters only
     */
    public val engineMode: kotlin.String? = builder.engineMode
    /**
     * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.
     *
     * For information about valid IOPS values, see [Amazon RDS Provisioned IOPS storage](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS) in the *Amazon RDS User Guide*.
     *
     * Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB instance.
     *
     * Valid for: Multi-AZ DB clusters only
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * The Amazon Web Services KMS key identifier to use when restoring an encrypted DB cluster from an encrypted DB cluster.
     *
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     *
     * You can restore to a new DB cluster and encrypt the new DB cluster with a KMS key that is different from the KMS key used to encrypt the source DB cluster. The new DB cluster is encrypted with the KMS key identified by the `KmsKeyId` parameter.
     *
     * If you don't specify a value for the `KmsKeyId` parameter, then the following occurs:
     * + If the DB cluster is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to encrypt the source DB cluster.
     * + If the DB cluster isn't encrypted, then the restored DB cluster isn't encrypted.
     *
     * If `DBClusterIdentifier` refers to a DB cluster that isn't encrypted, then the restore request is rejected.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The network type of the DB cluster.
     *
     * Valid Values:
     * + `IPV4`
     * + `DUAL`
     *
     * The network type is determined by the `DBSubnetGroup` specified for the DB cluster. A `DBSubnetGroup` can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (`DUAL`).
     *
     * For more information, see [ Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon Aurora User Guide.*
     *
     * Valid for: Aurora DB clusters only
     */
    public val networkType: kotlin.String? = builder.networkType
    /**
     * The name of the option group for the new DB cluster.
     *
     * DB clusters are associated with a default option group that can't be modified.
     */
    public val optionGroupName: kotlin.String? = builder.optionGroupName
    /**
     * The port number on which the new DB cluster accepts connections.
     *
     * Constraints: A value from `1150-65535`.
     *
     * Default: The default port for the engine.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val port: kotlin.Int? = builder.port
    /**
     * Specifies whether the DB cluster is publicly accessible.
     *
     * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB cluster doesn't permit it.
     *
     * When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.
     *
     * Default: The default behavior varies depending on whether `DBSubnetGroupName` is specified.
     *
     * If `DBSubnetGroupName` isn't specified, and `PubliclyAccessible` isn't specified, the following applies:
     * + If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.
     * + If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.
     *
     * If `DBSubnetGroupName` is specified, and `PubliclyAccessible` isn't specified, the following applies:
     * + If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.
     * + If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.
     *
     * Valid for: Multi-AZ DB clusters only
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * Reserved for future use.
     */
    public val rdsCustomClusterConfiguration: aws.sdk.kotlin.services.rds.model.RdsCustomClusterConfiguration? = builder.rdsCustomClusterConfiguration
    /**
     * The date and time to restore the DB cluster to.
     *
     * Valid Values: Value must be a time in Universal Coordinated Time (UTC) format
     *
     * Constraints:
     * + Must be before the latest restorable time for the DB instance
     * + Must be specified if `UseLatestRestorableTime` parameter isn't provided
     * + Can't be specified if the `UseLatestRestorableTime` parameter is enabled
     * + Can't be specified if the `RestoreType` parameter is `copy-on-write`
     *
     * Example: `2015-03-07T23:45:00Z`
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val restoreToTime: aws.smithy.kotlin.runtime.time.Instant? = builder.restoreToTime
    /**
     * The type of restore to be performed. You can specify one of the following values:
     * + `full-copy` - The new DB cluster is restored as a full copy of the source DB cluster.
     * + `copy-on-write` - The new DB cluster is restored as a clone of the source DB cluster.
     *
     * If you don't specify a `RestoreType` value, then the new DB cluster is restored as a full copy of the source DB cluster.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val restoreType: kotlin.String? = builder.restoreType
    /**
     * For DB clusters in `serverless` DB engine mode, the scaling properties of the DB cluster.
     *
     * Valid for: Aurora DB clusters only
     */
    public val scalingConfiguration: aws.sdk.kotlin.services.rds.model.ScalingConfiguration? = builder.scalingConfiguration
    /**
     * Contains the scaling configuration of an Aurora Serverless v2 DB cluster.
     *
     * For more information, see [Using Amazon Aurora Serverless v2](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html) in the *Amazon Aurora User Guide*.
     */
    public val serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration? = builder.serverlessV2ScalingConfiguration
    /**
     * The identifier of the source DB cluster from which to restore.
     *
     * Constraints:
     * + Must match the identifier of an existing DBCluster.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val sourceDbClusterIdentifier: kotlin.String? = builder.sourceDbClusterIdentifier
    /**
     * The resource ID of the source DB cluster from which to restore.
     */
    public val sourceDbClusterResourceId: kotlin.String? = builder.sourceDbClusterResourceId
    /**
     * Specifies the storage type to be associated with the DB cluster.
     *
     * When specified for a Multi-AZ DB cluster, a value for the `Iops` parameter is required.
     *
     * Valid Values: `aurora`, `aurora-iopt1` (Aurora DB clusters); `io1` (Multi-AZ DB clusters)
     *
     * Default: `aurora` (Aurora DB clusters); `io1` (Multi-AZ DB clusters)
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * A list of tags.
     *
     * For more information, see [Tagging Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html) in the *Amazon Aurora User Guide*.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Specifies whether to restore the DB cluster to the latest restorable backup time. By default, the DB cluster isn't restored to the latest restorable backup time.
     *
     * Constraints: Can't be specified if `RestoreToTime` parameter is provided.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val useLatestRestorableTime: kotlin.Boolean? = builder.useLatestRestorableTime
    /**
     * A list of VPC security groups that the new DB cluster belongs to.
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.RestoreDbClusterToPointInTimeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreDbClusterToPointInTimeRequest(")
        append("backtrackWindow=$backtrackWindow,")
        append("copyTagsToSnapshot=$copyTagsToSnapshot,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterInstanceClass=$dbClusterInstanceClass,")
        append("dbClusterParameterGroupName=$dbClusterParameterGroupName,")
        append("dbSubnetGroupName=$dbSubnetGroupName,")
        append("deletionProtection=$deletionProtection,")
        append("domain=$domain,")
        append("domainIamRoleName=$domainIamRoleName,")
        append("enableCloudwatchLogsExports=$enableCloudwatchLogsExports,")
        append("enableIamDatabaseAuthentication=$enableIamDatabaseAuthentication,")
        append("engineLifecycleSupport=$engineLifecycleSupport,")
        append("engineMode=$engineMode,")
        append("iops=$iops,")
        append("kmsKeyId=$kmsKeyId,")
        append("networkType=$networkType,")
        append("optionGroupName=$optionGroupName,")
        append("port=$port,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("rdsCustomClusterConfiguration=$rdsCustomClusterConfiguration,")
        append("restoreToTime=$restoreToTime,")
        append("restoreType=$restoreType,")
        append("scalingConfiguration=$scalingConfiguration,")
        append("serverlessV2ScalingConfiguration=$serverlessV2ScalingConfiguration,")
        append("sourceDbClusterIdentifier=$sourceDbClusterIdentifier,")
        append("sourceDbClusterResourceId=$sourceDbClusterResourceId,")
        append("storageType=$storageType,")
        append("tags=$tags,")
        append("useLatestRestorableTime=$useLatestRestorableTime,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = backtrackWindow?.hashCode() ?: 0
        result = 31 * result + (copyTagsToSnapshot?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbClusterParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (domainIamRoleName?.hashCode() ?: 0)
        result = 31 * result + (enableCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (enableIamDatabaseAuthentication?.hashCode() ?: 0)
        result = 31 * result + (engineLifecycleSupport?.hashCode() ?: 0)
        result = 31 * result + (engineMode?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (networkType?.hashCode() ?: 0)
        result = 31 * result + (optionGroupName?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (rdsCustomClusterConfiguration?.hashCode() ?: 0)
        result = 31 * result + (restoreToTime?.hashCode() ?: 0)
        result = 31 * result + (restoreType?.hashCode() ?: 0)
        result = 31 * result + (scalingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serverlessV2ScalingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (sourceDbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (sourceDbClusterResourceId?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (useLatestRestorableTime?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreDbClusterToPointInTimeRequest

        if (backtrackWindow != other.backtrackWindow) return false
        if (copyTagsToSnapshot != other.copyTagsToSnapshot) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterInstanceClass != other.dbClusterInstanceClass) return false
        if (dbClusterParameterGroupName != other.dbClusterParameterGroupName) return false
        if (dbSubnetGroupName != other.dbSubnetGroupName) return false
        if (deletionProtection != other.deletionProtection) return false
        if (domain != other.domain) return false
        if (domainIamRoleName != other.domainIamRoleName) return false
        if (enableCloudwatchLogsExports != other.enableCloudwatchLogsExports) return false
        if (enableIamDatabaseAuthentication != other.enableIamDatabaseAuthentication) return false
        if (engineLifecycleSupport != other.engineLifecycleSupport) return false
        if (engineMode != other.engineMode) return false
        if (iops != other.iops) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (networkType != other.networkType) return false
        if (optionGroupName != other.optionGroupName) return false
        if (port != other.port) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (rdsCustomClusterConfiguration != other.rdsCustomClusterConfiguration) return false
        if (restoreToTime != other.restoreToTime) return false
        if (restoreType != other.restoreType) return false
        if (scalingConfiguration != other.scalingConfiguration) return false
        if (serverlessV2ScalingConfiguration != other.serverlessV2ScalingConfiguration) return false
        if (sourceDbClusterIdentifier != other.sourceDbClusterIdentifier) return false
        if (sourceDbClusterResourceId != other.sourceDbClusterResourceId) return false
        if (storageType != other.storageType) return false
        if (tags != other.tags) return false
        if (useLatestRestorableTime != other.useLatestRestorableTime) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.RestoreDbClusterToPointInTimeRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The target backtrack window, in seconds. To disable backtracking, set this value to 0.
         *
         * Default: 0
         *
         * Constraints:
         * + If specified, this value must be set to a number from 0 to 259,200 (72 hours).
         *
         * Valid for: Aurora MySQL DB clusters only
         */
        public var backtrackWindow: kotlin.Long? = null
        /**
         * Specifies whether to copy all tags from the restored DB cluster to snapshots of the restored DB cluster. The default is not to copy them.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var copyTagsToSnapshot: kotlin.Boolean? = null
        /**
         * The name of the new DB cluster to be created.
         *
         * Constraints:
         * + Must contain from 1 to 63 letters, numbers, or hyphens
         * + First character must be a letter
         * + Can't end with a hyphen or contain two consecutive hyphens
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The compute and memory capacity of the each DB instance in the Multi-AZ DB cluster, for example db.m6gd.xlarge. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.
         *
         * For the full list of DB instance classes, and availability for your engine, see [DB instance class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the *Amazon RDS User Guide*.
         *
         * Valid for: Multi-AZ DB clusters only
         */
        public var dbClusterInstanceClass: kotlin.String? = null
        /**
         * The name of the custom DB cluster parameter group to associate with this DB cluster.
         *
         * If the `DBClusterParameterGroupName` parameter is omitted, the default DB cluster parameter group for the specified engine is used.
         *
         * Constraints:
         * + If supplied, must match the name of an existing DB cluster parameter group.
         * + Must be 1 to 255 letters, numbers, or hyphens.
         * + First character must be a letter.
         * + Can't end with a hyphen or contain two consecutive hyphens.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var dbClusterParameterGroupName: kotlin.String? = null
        /**
         * The DB subnet group name to use for the new DB cluster.
         *
         * Constraints: If supplied, must match the name of an existing DBSubnetGroup.
         *
         * Example: `mydbsubnetgroup`
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var dbSubnetGroupName: kotlin.String? = null
        /**
         * Specifies whether to enable deletion protection for the DB cluster. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * The Active Directory directory ID to restore the DB cluster in. The domain must be created prior to this operation.
         *
         * For Amazon Aurora DB clusters, Amazon RDS can use Kerberos Authentication to authenticate users that connect to the DB cluster. For more information, see [Kerberos Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html) in the *Amazon Aurora User Guide*.
         *
         * Valid for: Aurora DB clusters only
         */
        public var domain: kotlin.String? = null
        /**
         * The name of the IAM role to be used when making API calls to the Directory Service.
         *
         * Valid for: Aurora DB clusters only
         */
        public var domainIamRoleName: kotlin.String? = null
        /**
         * The list of logs that the restored DB cluster is to export to CloudWatch Logs. The values in the list depend on the DB engine being used.
         *
         * **RDS for MySQL**
         *
         * Possible values are `error`, `general`, and `slowquery`.
         *
         * **RDS for PostgreSQL**
         *
         * Possible values are `postgresql` and `upgrade`.
         *
         * **Aurora MySQL**
         *
         * Possible values are `audit`, `error`, `general`, and `slowquery`.
         *
         * **Aurora PostgreSQL**
         *
         * Possible value is `postgresql`.
         *
         * For more information about exporting CloudWatch Logs for Amazon RDS, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon RDS User Guide*.
         *
         * For more information about exporting CloudWatch Logs for Amazon Aurora, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon Aurora User Guide*.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var enableCloudwatchLogsExports: List<String>? = null
        /**
         * Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.
         *
         * For more information, see [ IAM Database Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html) in the *Amazon Aurora User Guide*.
         *
         * Valid for: Aurora DB clusters only
         */
        public var enableIamDatabaseAuthentication: kotlin.Boolean? = null
        /**
         * The life cycle type for this DB cluster.
         *
         * By default, this value is set to `open-source-rds-extended-support`, which enrolls your DB cluster into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to `open-source-rds-extended-support-disabled`. In this case, RDS automatically upgrades your restored DB cluster to a higher engine version, if the major engine version is past its end of standard support date.
         *
         * You can use this setting to enroll your DB cluster into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your DB cluster past the end of standard support for that engine version. For more information, see the following sections:
         * + Amazon Aurora (PostgreSQL only) - [Using Amazon RDS Extended Support](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html) in the *Amazon Aurora User Guide*
         * + Amazon RDS - [Using Amazon RDS Extended Support](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html) in the *Amazon RDS User Guide*
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *
         * Valid Values: `open-source-rds-extended-support | open-source-rds-extended-support-disabled`
         *
         * Default: `open-source-rds-extended-support`
         */
        public var engineLifecycleSupport: kotlin.String? = null
        /**
         * The engine mode of the new cluster. Specify `provisioned` or `serverless`, depending on the type of the cluster you are creating. You can create an Aurora Serverless v1 clone from a provisioned cluster, or a provisioned clone from an Aurora Serverless v1 cluster. To create a clone that is an Aurora Serverless v1 cluster, the original cluster must be an Aurora Serverless v1 cluster or an encrypted provisioned cluster.
         *
         * Valid for: Aurora DB clusters only
         */
        public var engineMode: kotlin.String? = null
        /**
         * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.
         *
         * For information about valid IOPS values, see [Amazon RDS Provisioned IOPS storage](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS) in the *Amazon RDS User Guide*.
         *
         * Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB instance.
         *
         * Valid for: Multi-AZ DB clusters only
         */
        public var iops: kotlin.Int? = null
        /**
         * The Amazon Web Services KMS key identifier to use when restoring an encrypted DB cluster from an encrypted DB cluster.
         *
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
         *
         * You can restore to a new DB cluster and encrypt the new DB cluster with a KMS key that is different from the KMS key used to encrypt the source DB cluster. The new DB cluster is encrypted with the KMS key identified by the `KmsKeyId` parameter.
         *
         * If you don't specify a value for the `KmsKeyId` parameter, then the following occurs:
         * + If the DB cluster is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to encrypt the source DB cluster.
         * + If the DB cluster isn't encrypted, then the restored DB cluster isn't encrypted.
         *
         * If `DBClusterIdentifier` refers to a DB cluster that isn't encrypted, then the restore request is rejected.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The network type of the DB cluster.
         *
         * Valid Values:
         * + `IPV4`
         * + `DUAL`
         *
         * The network type is determined by the `DBSubnetGroup` specified for the DB cluster. A `DBSubnetGroup` can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (`DUAL`).
         *
         * For more information, see [ Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon Aurora User Guide.*
         *
         * Valid for: Aurora DB clusters only
         */
        public var networkType: kotlin.String? = null
        /**
         * The name of the option group for the new DB cluster.
         *
         * DB clusters are associated with a default option group that can't be modified.
         */
        public var optionGroupName: kotlin.String? = null
        /**
         * The port number on which the new DB cluster accepts connections.
         *
         * Constraints: A value from `1150-65535`.
         *
         * Default: The default port for the engine.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var port: kotlin.Int? = null
        /**
         * Specifies whether the DB cluster is publicly accessible.
         *
         * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB cluster doesn't permit it.
         *
         * When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.
         *
         * Default: The default behavior varies depending on whether `DBSubnetGroupName` is specified.
         *
         * If `DBSubnetGroupName` isn't specified, and `PubliclyAccessible` isn't specified, the following applies:
         * + If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.
         * + If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.
         *
         * If `DBSubnetGroupName` is specified, and `PubliclyAccessible` isn't specified, the following applies:
         * + If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.
         * + If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.
         *
         * Valid for: Multi-AZ DB clusters only
         */
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * Reserved for future use.
         */
        public var rdsCustomClusterConfiguration: aws.sdk.kotlin.services.rds.model.RdsCustomClusterConfiguration? = null
        /**
         * The date and time to restore the DB cluster to.
         *
         * Valid Values: Value must be a time in Universal Coordinated Time (UTC) format
         *
         * Constraints:
         * + Must be before the latest restorable time for the DB instance
         * + Must be specified if `UseLatestRestorableTime` parameter isn't provided
         * + Can't be specified if the `UseLatestRestorableTime` parameter is enabled
         * + Can't be specified if the `RestoreType` parameter is `copy-on-write`
         *
         * Example: `2015-03-07T23:45:00Z`
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var restoreToTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of restore to be performed. You can specify one of the following values:
         * + `full-copy` - The new DB cluster is restored as a full copy of the source DB cluster.
         * + `copy-on-write` - The new DB cluster is restored as a clone of the source DB cluster.
         *
         * If you don't specify a `RestoreType` value, then the new DB cluster is restored as a full copy of the source DB cluster.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var restoreType: kotlin.String? = null
        /**
         * For DB clusters in `serverless` DB engine mode, the scaling properties of the DB cluster.
         *
         * Valid for: Aurora DB clusters only
         */
        public var scalingConfiguration: aws.sdk.kotlin.services.rds.model.ScalingConfiguration? = null
        /**
         * Contains the scaling configuration of an Aurora Serverless v2 DB cluster.
         *
         * For more information, see [Using Amazon Aurora Serverless v2](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html) in the *Amazon Aurora User Guide*.
         */
        public var serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration? = null
        /**
         * The identifier of the source DB cluster from which to restore.
         *
         * Constraints:
         * + Must match the identifier of an existing DBCluster.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var sourceDbClusterIdentifier: kotlin.String? = null
        /**
         * The resource ID of the source DB cluster from which to restore.
         */
        public var sourceDbClusterResourceId: kotlin.String? = null
        /**
         * Specifies the storage type to be associated with the DB cluster.
         *
         * When specified for a Multi-AZ DB cluster, a value for the `Iops` parameter is required.
         *
         * Valid Values: `aurora`, `aurora-iopt1` (Aurora DB clusters); `io1` (Multi-AZ DB clusters)
         *
         * Default: `aurora` (Aurora DB clusters); `io1` (Multi-AZ DB clusters)
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var storageType: kotlin.String? = null
        /**
         * A list of tags.
         *
         * For more information, see [Tagging Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html) in the *Amazon Aurora User Guide*.
         */
        public var tags: List<Tag>? = null
        /**
         * Specifies whether to restore the DB cluster to the latest restorable backup time. By default, the DB cluster isn't restored to the latest restorable backup time.
         *
         * Constraints: Can't be specified if `RestoreToTime` parameter is provided.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var useLatestRestorableTime: kotlin.Boolean? = null
        /**
         * A list of VPC security groups that the new DB cluster belongs to.
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var vpcSecurityGroupIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.RestoreDbClusterToPointInTimeRequest) : this() {
            this.backtrackWindow = x.backtrackWindow
            this.copyTagsToSnapshot = x.copyTagsToSnapshot
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterInstanceClass = x.dbClusterInstanceClass
            this.dbClusterParameterGroupName = x.dbClusterParameterGroupName
            this.dbSubnetGroupName = x.dbSubnetGroupName
            this.deletionProtection = x.deletionProtection
            this.domain = x.domain
            this.domainIamRoleName = x.domainIamRoleName
            this.enableCloudwatchLogsExports = x.enableCloudwatchLogsExports
            this.enableIamDatabaseAuthentication = x.enableIamDatabaseAuthentication
            this.engineLifecycleSupport = x.engineLifecycleSupport
            this.engineMode = x.engineMode
            this.iops = x.iops
            this.kmsKeyId = x.kmsKeyId
            this.networkType = x.networkType
            this.optionGroupName = x.optionGroupName
            this.port = x.port
            this.publiclyAccessible = x.publiclyAccessible
            this.rdsCustomClusterConfiguration = x.rdsCustomClusterConfiguration
            this.restoreToTime = x.restoreToTime
            this.restoreType = x.restoreType
            this.scalingConfiguration = x.scalingConfiguration
            this.serverlessV2ScalingConfiguration = x.serverlessV2ScalingConfiguration
            this.sourceDbClusterIdentifier = x.sourceDbClusterIdentifier
            this.sourceDbClusterResourceId = x.sourceDbClusterResourceId
            this.storageType = x.storageType
            this.tags = x.tags
            this.useLatestRestorableTime = x.useLatestRestorableTime
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.RestoreDbClusterToPointInTimeRequest = RestoreDbClusterToPointInTimeRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.RdsCustomClusterConfiguration] inside the given [block]
         */
        public fun rdsCustomClusterConfiguration(block: aws.sdk.kotlin.services.rds.model.RdsCustomClusterConfiguration.Builder.() -> kotlin.Unit) {
            this.rdsCustomClusterConfiguration = aws.sdk.kotlin.services.rds.model.RdsCustomClusterConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.ScalingConfiguration] inside the given [block]
         */
        public fun scalingConfiguration(block: aws.sdk.kotlin.services.rds.model.ScalingConfiguration.Builder.() -> kotlin.Unit) {
            this.scalingConfiguration = aws.sdk.kotlin.services.rds.model.ScalingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration] inside the given [block]
         */
        public fun serverlessV2ScalingConfiguration(block: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration.Builder.() -> kotlin.Unit) {
            this.serverlessV2ScalingConfiguration = aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
