// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 *
 */
public class PromoteReadReplicaRequest private constructor(builder: Builder) {
    /**
     * The number of days for which automated backups are retained. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.
     *
     * Default: 1
     *
     * Constraints:
     * + Must be a value from 0 to 35.
     * + Can't be set to 0 if the DB instance is a source to read replicas.
     */
    public val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * The DB instance identifier. This value is stored as a lowercase string.
     *
     * Constraints:
     * + Must match the identifier of an existing read replica DB instance.
     *
     * Example: `mydbinstance`
     */
    public val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * The daily time range during which automated backups are created if automated backups are enabled, using the `BackupRetentionPeriod` parameter.
     *
     * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. To see the time blocks available, see [ Adjusting the Preferred Maintenance Window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html) in the *Amazon RDS User Guide.*
     *
     * Constraints:
     * + Must be in the format `hh24:mi-hh24:mi`.
     * + Must be in Universal Coordinated Time (UTC).
     * + Must not conflict with the preferred maintenance window.
     * + Must be at least 30 minutes.
     */
    public val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.PromoteReadReplicaRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PromoteReadReplicaRequest(")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("preferredBackupWindow=$preferredBackupWindow")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupRetentionPeriod ?: 0
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PromoteReadReplicaRequest

        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.PromoteReadReplicaRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of days for which automated backups are retained. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.
         *
         * Default: 1
         *
         * Constraints:
         * + Must be a value from 0 to 35.
         * + Can't be set to 0 if the DB instance is a source to read replicas.
         */
        public var backupRetentionPeriod: kotlin.Int? = null
        /**
         * The DB instance identifier. This value is stored as a lowercase string.
         *
         * Constraints:
         * + Must match the identifier of an existing read replica DB instance.
         *
         * Example: `mydbinstance`
         */
        public var dbInstanceIdentifier: kotlin.String? = null
        /**
         * The daily time range during which automated backups are created if automated backups are enabled, using the `BackupRetentionPeriod` parameter.
         *
         * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. To see the time blocks available, see [ Adjusting the Preferred Maintenance Window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html) in the *Amazon RDS User Guide.*
         *
         * Constraints:
         * + Must be in the format `hh24:mi-hh24:mi`.
         * + Must be in Universal Coordinated Time (UTC).
         * + Must not conflict with the preferred maintenance window.
         * + Must be at least 30 minutes.
         */
        public var preferredBackupWindow: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.PromoteReadReplicaRequest) : this() {
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.preferredBackupWindow = x.preferredBackupWindow
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.PromoteReadReplicaRequest = PromoteReadReplicaRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
