// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ModifyTenantDatabaseRequest private constructor(builder: Builder) {
    /**
     * The identifier of the DB instance that contains the tenant database that you are modifying. This parameter isn't case-sensitive.
     *
     * Constraints:
     * + Must match the identifier of an existing DB instance.
     */
    public val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * The new password for the master user of the specified tenant database in your DB instance.
     *
     * Amazon RDS operations never return the password, so this action provides a way to regain access to a tenant database user if the password is lost. This includes restoring privileges that might have been accidentally revoked.
     *
     * Constraints:
     * + Can include any printable ASCII character except `/`, `"` (double quote), `@`, `&` (ampersand), and `'` (single quote).
     *
     * Length constraints:
     * + Must contain between 8 and 30 characters.
     */
    public val masterUserPassword: kotlin.String? = builder.masterUserPassword
    /**
     * The new name of the tenant database when renaming a tenant database. This parameter isn’t case-sensitive.
     *
     * Constraints:
     * + Can't be the string null or any other reserved word.
     * + Can't be longer than 8 characters.
     */
    public val newTenantDbName: kotlin.String? = builder.newTenantDbName
    /**
     * The user-supplied name of the tenant database that you want to modify. This parameter isn’t case-sensitive.
     *
     * Constraints:
     * + Must match the identifier of an existing tenant database.
     */
    public val tenantDbName: kotlin.String? = builder.tenantDbName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.ModifyTenantDatabaseRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyTenantDatabaseRequest(")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("masterUserPassword=*** Sensitive Data Redacted ***,")
        append("newTenantDbName=$newTenantDbName,")
        append("tenantDbName=$tenantDbName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbInstanceIdentifier?.hashCode() ?: 0
        result = 31 * result + (masterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (newTenantDbName?.hashCode() ?: 0)
        result = 31 * result + (tenantDbName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyTenantDatabaseRequest

        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (masterUserPassword != other.masterUserPassword) return false
        if (newTenantDbName != other.newTenantDbName) return false
        if (tenantDbName != other.tenantDbName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.ModifyTenantDatabaseRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the DB instance that contains the tenant database that you are modifying. This parameter isn't case-sensitive.
         *
         * Constraints:
         * + Must match the identifier of an existing DB instance.
         */
        public var dbInstanceIdentifier: kotlin.String? = null
        /**
         * The new password for the master user of the specified tenant database in your DB instance.
         *
         * Amazon RDS operations never return the password, so this action provides a way to regain access to a tenant database user if the password is lost. This includes restoring privileges that might have been accidentally revoked.
         *
         * Constraints:
         * + Can include any printable ASCII character except `/`, `"` (double quote), `@`, `&` (ampersand), and `'` (single quote).
         *
         * Length constraints:
         * + Must contain between 8 and 30 characters.
         */
        public var masterUserPassword: kotlin.String? = null
        /**
         * The new name of the tenant database when renaming a tenant database. This parameter isn’t case-sensitive.
         *
         * Constraints:
         * + Can't be the string null or any other reserved word.
         * + Can't be longer than 8 characters.
         */
        public var newTenantDbName: kotlin.String? = null
        /**
         * The user-supplied name of the tenant database that you want to modify. This parameter isn’t case-sensitive.
         *
         * Constraints:
         * + Must match the identifier of an existing tenant database.
         */
        public var tenantDbName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.ModifyTenantDatabaseRequest) : this() {
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.masterUserPassword = x.masterUserPassword
            this.newTenantDbName = x.newTenantDbName
            this.tenantDbName = x.tenantDbName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.ModifyTenantDatabaseRequest = ModifyTenantDatabaseRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
