// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ModifyDbShardGroupResponse private constructor(builder: Builder) {
    /**
     * Specifies whether to create standby DB shard groups for the DB shard group. Valid values are the following:
     * + 0 - Creates a DB shard group without a standby DB shard group. This is the default value.
     * + 1 - Creates a DB shard group with a standby DB shard group in a different Availability Zone (AZ).
     * + 2 - Creates a DB shard group with two standby DB shard groups in two different AZs.
     */
    public val computeRedundancy: kotlin.Int? = builder.computeRedundancy
    /**
     * The name of the primary DB cluster for the DB shard group.
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The Amazon Resource Name (ARN) for the DB shard group.
     */
    public val dbShardGroupArn: kotlin.String? = builder.dbShardGroupArn
    /**
     * The name of the DB shard group.
     */
    public val dbShardGroupIdentifier: kotlin.String? = builder.dbShardGroupIdentifier
    /**
     * The Amazon Web Services Region-unique, immutable identifier for the DB shard group.
     */
    public val dbShardGroupResourceId: kotlin.String? = builder.dbShardGroupResourceId
    /**
     * The connection endpoint for the DB shard group.
     */
    public val endpoint: kotlin.String? = builder.endpoint
    /**
     * The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
     */
    public val maxAcu: kotlin.Double? = builder.maxAcu
    /**
     * The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
     */
    public val minAcu: kotlin.Double? = builder.minAcu
    /**
     * Indicates whether the DB shard group is publicly accessible.
     *
     * When the DB shard group is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB shard group's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB shard group's VPC. Access to the DB shard group is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB shard group doesn't permit it.
     *
     * When the DB shard group isn't publicly accessible, it is an internal DB shard group with a DNS name that resolves to a private IP address.
     *
     * For more information, see CreateDBShardGroup.
     *
     * This setting is only for Aurora Limitless Database.
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * The status of the DB shard group.
     */
    public val status: kotlin.String? = builder.status
    /**
     * A list of tags.
     *
     * For more information, see [Tagging Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html) in the *Amazon Aurora User Guide*.
     */
    public val tagList: List<Tag>? = builder.tagList

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.ModifyDbShardGroupResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyDbShardGroupResponse(")
        append("computeRedundancy=$computeRedundancy,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbShardGroupArn=$dbShardGroupArn,")
        append("dbShardGroupIdentifier=$dbShardGroupIdentifier,")
        append("dbShardGroupResourceId=$dbShardGroupResourceId,")
        append("endpoint=$endpoint,")
        append("maxAcu=$maxAcu,")
        append("minAcu=$minAcu,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("status=$status,")
        append("tagList=$tagList")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = computeRedundancy ?: 0
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbShardGroupArn?.hashCode() ?: 0)
        result = 31 * result + (dbShardGroupIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbShardGroupResourceId?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (maxAcu?.hashCode() ?: 0)
        result = 31 * result + (minAcu?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tagList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyDbShardGroupResponse

        if (computeRedundancy != other.computeRedundancy) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbShardGroupArn != other.dbShardGroupArn) return false
        if (dbShardGroupIdentifier != other.dbShardGroupIdentifier) return false
        if (dbShardGroupResourceId != other.dbShardGroupResourceId) return false
        if (endpoint != other.endpoint) return false
        if (!(maxAcu?.equals(other.maxAcu) ?: (other.maxAcu == null))) return false
        if (!(minAcu?.equals(other.minAcu) ?: (other.minAcu == null))) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (status != other.status) return false
        if (tagList != other.tagList) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.ModifyDbShardGroupResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether to create standby DB shard groups for the DB shard group. Valid values are the following:
         * + 0 - Creates a DB shard group without a standby DB shard group. This is the default value.
         * + 1 - Creates a DB shard group with a standby DB shard group in a different Availability Zone (AZ).
         * + 2 - Creates a DB shard group with two standby DB shard groups in two different AZs.
         */
        public var computeRedundancy: kotlin.Int? = null
        /**
         * The name of the primary DB cluster for the DB shard group.
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the DB shard group.
         */
        public var dbShardGroupArn: kotlin.String? = null
        /**
         * The name of the DB shard group.
         */
        public var dbShardGroupIdentifier: kotlin.String? = null
        /**
         * The Amazon Web Services Region-unique, immutable identifier for the DB shard group.
         */
        public var dbShardGroupResourceId: kotlin.String? = null
        /**
         * The connection endpoint for the DB shard group.
         */
        public var endpoint: kotlin.String? = null
        /**
         * The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
         */
        public var maxAcu: kotlin.Double? = null
        /**
         * The minimum capacity of the DB shard group in Aurora capacity units (ACUs).
         */
        public var minAcu: kotlin.Double? = null
        /**
         * Indicates whether the DB shard group is publicly accessible.
         *
         * When the DB shard group is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB shard group's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB shard group's VPC. Access to the DB shard group is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB shard group doesn't permit it.
         *
         * When the DB shard group isn't publicly accessible, it is an internal DB shard group with a DNS name that resolves to a private IP address.
         *
         * For more information, see CreateDBShardGroup.
         *
         * This setting is only for Aurora Limitless Database.
         */
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * The status of the DB shard group.
         */
        public var status: kotlin.String? = null
        /**
         * A list of tags.
         *
         * For more information, see [Tagging Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html) in the *Amazon Aurora User Guide*.
         */
        public var tagList: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.ModifyDbShardGroupResponse) : this() {
            this.computeRedundancy = x.computeRedundancy
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbShardGroupArn = x.dbShardGroupArn
            this.dbShardGroupIdentifier = x.dbShardGroupIdentifier
            this.dbShardGroupResourceId = x.dbShardGroupResourceId
            this.endpoint = x.endpoint
            this.maxAcu = x.maxAcu
            this.minAcu = x.minAcu
            this.publiclyAccessible = x.publiclyAccessible
            this.status = x.status
            this.tagList = x.tagList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.ModifyDbShardGroupResponse = ModifyDbShardGroupResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
