// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 *
 */
public class ModifyDbParameterGroupRequest private constructor(builder: Builder) {
    /**
     * The name of the DB parameter group.
     *
     * Constraints:
     * + If supplied, must match the name of an existing `DBParameterGroup`.
     */
    public val dbParameterGroupName: kotlin.String? = builder.dbParameterGroupName
    /**
     * An array of parameter names, values, and the application methods for the parameter update. At least one parameter name, value, and application method must be supplied; later arguments are optional. A maximum of 20 parameters can be modified in a single request.
     *
     * Valid Values (for the application method): `immediate | pending-reboot`
     *
     * You can use the `immediate` value with dynamic parameters only. You can use the `pending-reboot` value for both dynamic and static parameters.
     *
     * When the application method is `immediate`, changes to dynamic parameters are applied immediately to the DB instances associated with the parameter group.
     *
     * When the application method is `pending-reboot`, changes to dynamic and static parameters are applied after a reboot without failover to the DB instances associated with the parameter group.
     *
     * You can't use `pending-reboot` with dynamic parameters on RDS for SQL Server DB instances. Use `immediate`.
     *
     * For more information on modifying DB parameters, see [Working with DB parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html) in the *Amazon RDS User Guide*.
     */
    public val parameters: List<Parameter>? = builder.parameters

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.ModifyDbParameterGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyDbParameterGroupRequest(")
        append("dbParameterGroupName=$dbParameterGroupName,")
        append("parameters=$parameters")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbParameterGroupName?.hashCode() ?: 0
        result = 31 * result + (parameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyDbParameterGroupRequest

        if (dbParameterGroupName != other.dbParameterGroupName) return false
        if (parameters != other.parameters) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.ModifyDbParameterGroupRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the DB parameter group.
         *
         * Constraints:
         * + If supplied, must match the name of an existing `DBParameterGroup`.
         */
        public var dbParameterGroupName: kotlin.String? = null
        /**
         * An array of parameter names, values, and the application methods for the parameter update. At least one parameter name, value, and application method must be supplied; later arguments are optional. A maximum of 20 parameters can be modified in a single request.
         *
         * Valid Values (for the application method): `immediate | pending-reboot`
         *
         * You can use the `immediate` value with dynamic parameters only. You can use the `pending-reboot` value for both dynamic and static parameters.
         *
         * When the application method is `immediate`, changes to dynamic parameters are applied immediately to the DB instances associated with the parameter group.
         *
         * When the application method is `pending-reboot`, changes to dynamic and static parameters are applied after a reboot without failover to the DB instances associated with the parameter group.
         *
         * You can't use `pending-reboot` with dynamic parameters on RDS for SQL Server DB instances. Use `immediate`.
         *
         * For more information on modifying DB parameters, see [Working with DB parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html) in the *Amazon RDS User Guide*.
         */
        public var parameters: List<Parameter>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.ModifyDbParameterGroupRequest) : this() {
            this.dbParameterGroupName = x.dbParameterGroupName
            this.parameters = x.parameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.ModifyDbParameterGroupRequest = ModifyDbParameterGroupRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
