// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ModifyCurrentDbClusterCapacityRequest private constructor(builder: Builder) {
    /**
     * The DB cluster capacity.
     *
     * When you change the capacity of a paused Aurora Serverless v1 DB cluster, it automatically resumes.
     *
     * Constraints:
     * + For Aurora MySQL, valid capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, and `256`.
     * + For Aurora PostgreSQL, valid capacity values are `2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`.
     */
    public val capacity: kotlin.Int? = builder.capacity
    /**
     * The DB cluster identifier for the cluster being modified. This parameter isn't case-sensitive.
     *
     * Constraints:
     * + Must match the identifier of an existing DB cluster.
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The amount of time, in seconds, that Aurora Serverless v1 tries to find a scaling point to perform seamless scaling before enforcing the timeout action. The default is 300.
     *
     * Specify a value between 10 and 600 seconds.
     */
    public val secondsBeforeTimeout: kotlin.Int? = builder.secondsBeforeTimeout
    /**
     * The action to take when the timeout is reached, either `ForceApplyCapacityChange` or `RollbackCapacityChange`.
     *
     * `ForceApplyCapacityChange`, the default, sets the capacity to the specified value as soon as possible.
     *
     * `RollbackCapacityChange` ignores the capacity change if a scaling point isn't found in the timeout period.
     */
    public val timeoutAction: kotlin.String? = builder.timeoutAction

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.ModifyCurrentDbClusterCapacityRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyCurrentDbClusterCapacityRequest(")
        append("capacity=$capacity,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("secondsBeforeTimeout=$secondsBeforeTimeout,")
        append("timeoutAction=$timeoutAction")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacity ?: 0
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (secondsBeforeTimeout ?: 0)
        result = 31 * result + (timeoutAction?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyCurrentDbClusterCapacityRequest

        if (capacity != other.capacity) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (secondsBeforeTimeout != other.secondsBeforeTimeout) return false
        if (timeoutAction != other.timeoutAction) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.ModifyCurrentDbClusterCapacityRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The DB cluster capacity.
         *
         * When you change the capacity of a paused Aurora Serverless v1 DB cluster, it automatically resumes.
         *
         * Constraints:
         * + For Aurora MySQL, valid capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, and `256`.
         * + For Aurora PostgreSQL, valid capacity values are `2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`.
         */
        public var capacity: kotlin.Int? = null
        /**
         * The DB cluster identifier for the cluster being modified. This parameter isn't case-sensitive.
         *
         * Constraints:
         * + Must match the identifier of an existing DB cluster.
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The amount of time, in seconds, that Aurora Serverless v1 tries to find a scaling point to perform seamless scaling before enforcing the timeout action. The default is 300.
         *
         * Specify a value between 10 and 600 seconds.
         */
        public var secondsBeforeTimeout: kotlin.Int? = null
        /**
         * The action to take when the timeout is reached, either `ForceApplyCapacityChange` or `RollbackCapacityChange`.
         *
         * `ForceApplyCapacityChange`, the default, sets the capacity to the specified value as soon as possible.
         *
         * `RollbackCapacityChange` ignores the capacity change if a scaling point isn't found in the timeout period.
         */
        public var timeoutAction: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.ModifyCurrentDbClusterCapacityRequest) : this() {
            this.capacity = x.capacity
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.secondsBeforeTimeout = x.secondsBeforeTimeout
            this.timeoutAction = x.timeoutAction
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.ModifyCurrentDbClusterCapacityRequest = ModifyCurrentDbClusterCapacityRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
