// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A data type representing an Aurora global database.
 */
public class GlobalCluster private constructor(builder: Builder) {
    /**
     * The default database name within the new global database cluster.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * The deletion protection setting for the new global database cluster.
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The Aurora database engine used by the global database cluster.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The life cycle type for the global cluster.
     *
     * For more information, see CreateGlobalCluster.
     */
    public val engineLifecycleSupport: kotlin.String? = builder.engineLifecycleSupport
    /**
     * Indicates the database engine version.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * A data object containing all properties for the current state of an in-process or pending switchover or failover process for this global cluster (Aurora global database). This object is empty unless the `SwitchoverGlobalCluster` or `FailoverGlobalCluster` operation was called on this global cluster.
     */
    public val failoverState: aws.sdk.kotlin.services.rds.model.FailoverState? = builder.failoverState
    /**
     * The Amazon Resource Name (ARN) for the global database cluster.
     */
    public val globalClusterArn: kotlin.String? = builder.globalClusterArn
    /**
     * Contains a user-supplied global database cluster identifier. This identifier is the unique key that identifies a global database cluster.
     */
    public val globalClusterIdentifier: kotlin.String? = builder.globalClusterIdentifier
    /**
     * The list of primary and secondary clusters within the global database cluster.
     */
    public val globalClusterMembers: List<GlobalClusterMember>? = builder.globalClusterMembers
    /**
     * The Amazon Web Services Region-unique, immutable identifier for the global database cluster. This identifier is found in Amazon Web Services CloudTrail log entries whenever the Amazon Web Services KMS key for the DB cluster is accessed.
     */
    public val globalClusterResourceId: kotlin.String? = builder.globalClusterResourceId
    /**
     * Specifies the current state of this global database cluster.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The storage encryption setting for the global database cluster.
     */
    public val storageEncrypted: kotlin.Boolean? = builder.storageEncrypted
    /**
     * A list of tags.
     *
     * For more information, see [Tagging Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html) in the *Amazon Aurora User Guide*.
     */
    public val tagList: List<Tag>? = builder.tagList

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.GlobalCluster = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GlobalCluster(")
        append("databaseName=$databaseName,")
        append("deletionProtection=$deletionProtection,")
        append("engine=$engine,")
        append("engineLifecycleSupport=$engineLifecycleSupport,")
        append("engineVersion=$engineVersion,")
        append("failoverState=$failoverState,")
        append("globalClusterArn=$globalClusterArn,")
        append("globalClusterIdentifier=$globalClusterIdentifier,")
        append("globalClusterMembers=$globalClusterMembers,")
        append("globalClusterResourceId=$globalClusterResourceId,")
        append("status=$status,")
        append("storageEncrypted=$storageEncrypted,")
        append("tagList=$tagList")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = databaseName?.hashCode() ?: 0
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineLifecycleSupport?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (failoverState?.hashCode() ?: 0)
        result = 31 * result + (globalClusterArn?.hashCode() ?: 0)
        result = 31 * result + (globalClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (globalClusterMembers?.hashCode() ?: 0)
        result = 31 * result + (globalClusterResourceId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted?.hashCode() ?: 0)
        result = 31 * result + (tagList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GlobalCluster

        if (databaseName != other.databaseName) return false
        if (deletionProtection != other.deletionProtection) return false
        if (engine != other.engine) return false
        if (engineLifecycleSupport != other.engineLifecycleSupport) return false
        if (engineVersion != other.engineVersion) return false
        if (failoverState != other.failoverState) return false
        if (globalClusterArn != other.globalClusterArn) return false
        if (globalClusterIdentifier != other.globalClusterIdentifier) return false
        if (globalClusterMembers != other.globalClusterMembers) return false
        if (globalClusterResourceId != other.globalClusterResourceId) return false
        if (status != other.status) return false
        if (storageEncrypted != other.storageEncrypted) return false
        if (tagList != other.tagList) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.GlobalCluster = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The default database name within the new global database cluster.
         */
        public var databaseName: kotlin.String? = null
        /**
         * The deletion protection setting for the new global database cluster.
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * The Aurora database engine used by the global database cluster.
         */
        public var engine: kotlin.String? = null
        /**
         * The life cycle type for the global cluster.
         *
         * For more information, see CreateGlobalCluster.
         */
        public var engineLifecycleSupport: kotlin.String? = null
        /**
         * Indicates the database engine version.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * A data object containing all properties for the current state of an in-process or pending switchover or failover process for this global cluster (Aurora global database). This object is empty unless the `SwitchoverGlobalCluster` or `FailoverGlobalCluster` operation was called on this global cluster.
         */
        public var failoverState: aws.sdk.kotlin.services.rds.model.FailoverState? = null
        /**
         * The Amazon Resource Name (ARN) for the global database cluster.
         */
        public var globalClusterArn: kotlin.String? = null
        /**
         * Contains a user-supplied global database cluster identifier. This identifier is the unique key that identifies a global database cluster.
         */
        public var globalClusterIdentifier: kotlin.String? = null
        /**
         * The list of primary and secondary clusters within the global database cluster.
         */
        public var globalClusterMembers: List<GlobalClusterMember>? = null
        /**
         * The Amazon Web Services Region-unique, immutable identifier for the global database cluster. This identifier is found in Amazon Web Services CloudTrail log entries whenever the Amazon Web Services KMS key for the DB cluster is accessed.
         */
        public var globalClusterResourceId: kotlin.String? = null
        /**
         * Specifies the current state of this global database cluster.
         */
        public var status: kotlin.String? = null
        /**
         * The storage encryption setting for the global database cluster.
         */
        public var storageEncrypted: kotlin.Boolean? = null
        /**
         * A list of tags.
         *
         * For more information, see [Tagging Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html) in the *Amazon Aurora User Guide*.
         */
        public var tagList: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.GlobalCluster) : this() {
            this.databaseName = x.databaseName
            this.deletionProtection = x.deletionProtection
            this.engine = x.engine
            this.engineLifecycleSupport = x.engineLifecycleSupport
            this.engineVersion = x.engineVersion
            this.failoverState = x.failoverState
            this.globalClusterArn = x.globalClusterArn
            this.globalClusterIdentifier = x.globalClusterIdentifier
            this.globalClusterMembers = x.globalClusterMembers
            this.globalClusterResourceId = x.globalClusterResourceId
            this.status = x.status
            this.storageEncrypted = x.storageEncrypted
            this.tagList = x.tagList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.GlobalCluster = GlobalCluster(this)

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.FailoverState] inside the given [block]
         */
        public fun failoverState(block: aws.sdk.kotlin.services.rds.model.FailoverState.Builder.() -> kotlin.Unit) {
            this.failoverState = aws.sdk.kotlin.services.rds.model.FailoverState.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
