// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains the state of scheduled or in-process operations on a global cluster (Aurora global database). This data type is empty unless a switchover or failover operation is scheduled or is in progress on the Aurora global database.
 */
public class FailoverState private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being demoted, and which is associated with this state.
     */
    public val fromDbClusterArn: kotlin.String? = builder.fromDbClusterArn
    /**
     * Indicates whether the operation is a global switchover or a global failover. If data loss is allowed, then the operation is a global failover. Otherwise, it's a switchover.
     */
    public val isDataLossAllowed: kotlin.Boolean? = builder.isDataLossAllowed
    /**
     * The current status of the global cluster. Possible values are as follows:
     * + pending  The service received a request to switch over or fail over the global cluster. The global cluster's primary DB cluster and the specified secondary DB cluster are being verified before the operation starts.
     * + failing-over  Aurora is promoting the chosen secondary Aurora DB cluster to become the new primary DB cluster to fail over the global cluster.
     * + cancelling  The request to switch over or fail over the global cluster was cancelled and the primary Aurora DB cluster and the selected secondary Aurora DB cluster are returning to their previous states.
     * + switching-over  This status covers the range of Aurora internal operations that take place during the switchover process, such as demoting the primary Aurora DB cluster, promoting the secondary Aurora DB cluster, and synchronizing replicas.
     */
    public val status: aws.sdk.kotlin.services.rds.model.FailoverStatus? = builder.status
    /**
     * The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being promoted, and which is associated with this state.
     */
    public val toDbClusterArn: kotlin.String? = builder.toDbClusterArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.FailoverState = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FailoverState(")
        append("fromDbClusterArn=$fromDbClusterArn,")
        append("isDataLossAllowed=$isDataLossAllowed,")
        append("status=$status,")
        append("toDbClusterArn=$toDbClusterArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fromDbClusterArn?.hashCode() ?: 0
        result = 31 * result + (isDataLossAllowed?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (toDbClusterArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FailoverState

        if (fromDbClusterArn != other.fromDbClusterArn) return false
        if (isDataLossAllowed != other.isDataLossAllowed) return false
        if (status != other.status) return false
        if (toDbClusterArn != other.toDbClusterArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.FailoverState = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being demoted, and which is associated with this state.
         */
        public var fromDbClusterArn: kotlin.String? = null
        /**
         * Indicates whether the operation is a global switchover or a global failover. If data loss is allowed, then the operation is a global failover. Otherwise, it's a switchover.
         */
        public var isDataLossAllowed: kotlin.Boolean? = null
        /**
         * The current status of the global cluster. Possible values are as follows:
         * + pending  The service received a request to switch over or fail over the global cluster. The global cluster's primary DB cluster and the specified secondary DB cluster are being verified before the operation starts.
         * + failing-over  Aurora is promoting the chosen secondary Aurora DB cluster to become the new primary DB cluster to fail over the global cluster.
         * + cancelling  The request to switch over or fail over the global cluster was cancelled and the primary Aurora DB cluster and the selected secondary Aurora DB cluster are returning to their previous states.
         * + switching-over  This status covers the range of Aurora internal operations that take place during the switchover process, such as demoting the primary Aurora DB cluster, promoting the secondary Aurora DB cluster, and synchronizing replicas.
         */
        public var status: aws.sdk.kotlin.services.rds.model.FailoverStatus? = null
        /**
         * The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being promoted, and which is associated with this state.
         */
        public var toDbClusterArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.FailoverState) : this() {
            this.fromDbClusterArn = x.fromDbClusterArn
            this.isDataLossAllowed = x.isDataLossAllowed
            this.status = x.status
            this.toDbClusterArn = x.toDbClusterArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.FailoverState = FailoverState(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
