// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

public class FailoverGlobalClusterRequest private constructor(builder: Builder) {
    /**
     * Specifies whether to allow data loss for this global database cluster operation. Allowing data loss triggers a global failover operation.
     *
     * If you don't specify `AllowDataLoss`, the global database cluster operation defaults to a switchover.
     *
     * Constraints:
     * + Can't be specified together with the `Switchover` parameter.
     */
    public val allowDataLoss: kotlin.Boolean? = builder.allowDataLoss
    /**
     * The identifier of the global database cluster (Aurora global database) this operation should apply to. The identifier is the unique key assigned by the user when the Aurora global database is created. In other words, it's the name of the Aurora global database.
     *
     * Constraints:
     * + Must match the identifier of an existing global database cluster.
     */
    public val globalClusterIdentifier: kotlin.String? = builder.globalClusterIdentifier
    /**
     * Specifies whether to switch over this global database cluster.
     *
     * Constraints:
     * + Can't be specified together with the `AllowDataLoss` parameter.
     */
    public val switchover: kotlin.Boolean? = builder.switchover
    /**
     * The identifier of the secondary Aurora DB cluster that you want to promote to the primary for the global database cluster. Use the Amazon Resource Name (ARN) for the identifier so that Aurora can locate the cluster in its Amazon Web Services Region.
     */
    public val targetDbClusterIdentifier: kotlin.String? = builder.targetDbClusterIdentifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.FailoverGlobalClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FailoverGlobalClusterRequest(")
        append("allowDataLoss=$allowDataLoss,")
        append("globalClusterIdentifier=$globalClusterIdentifier,")
        append("switchover=$switchover,")
        append("targetDbClusterIdentifier=$targetDbClusterIdentifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowDataLoss?.hashCode() ?: 0
        result = 31 * result + (globalClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (switchover?.hashCode() ?: 0)
        result = 31 * result + (targetDbClusterIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FailoverGlobalClusterRequest

        if (allowDataLoss != other.allowDataLoss) return false
        if (globalClusterIdentifier != other.globalClusterIdentifier) return false
        if (switchover != other.switchover) return false
        if (targetDbClusterIdentifier != other.targetDbClusterIdentifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.FailoverGlobalClusterRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether to allow data loss for this global database cluster operation. Allowing data loss triggers a global failover operation.
         *
         * If you don't specify `AllowDataLoss`, the global database cluster operation defaults to a switchover.
         *
         * Constraints:
         * + Can't be specified together with the `Switchover` parameter.
         */
        public var allowDataLoss: kotlin.Boolean? = null
        /**
         * The identifier of the global database cluster (Aurora global database) this operation should apply to. The identifier is the unique key assigned by the user when the Aurora global database is created. In other words, it's the name of the Aurora global database.
         *
         * Constraints:
         * + Must match the identifier of an existing global database cluster.
         */
        public var globalClusterIdentifier: kotlin.String? = null
        /**
         * Specifies whether to switch over this global database cluster.
         *
         * Constraints:
         * + Can't be specified together with the `AllowDataLoss` parameter.
         */
        public var switchover: kotlin.Boolean? = null
        /**
         * The identifier of the secondary Aurora DB cluster that you want to promote to the primary for the global database cluster. Use the Amazon Resource Name (ARN) for the identifier so that Aurora can locate the cluster in its Amazon Web Services Region.
         */
        public var targetDbClusterIdentifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.FailoverGlobalClusterRequest) : this() {
            this.allowDataLoss = x.allowDataLoss
            this.globalClusterIdentifier = x.globalClusterIdentifier
            this.switchover = x.switchover
            this.targetDbClusterIdentifier = x.targetDbClusterIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.FailoverGlobalClusterRequest = FailoverGlobalClusterRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
