// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 *
 */
public class DescribeDbClustersRequest private constructor(builder: Builder) {
    /**
     * The user-supplied DB cluster identifier or the Amazon Resource Name (ARN) of the DB cluster. If this parameter is specified, information for only the specific DB cluster is returned. This parameter isn't case-sensitive.
     *
     * Constraints:
     * + If supplied, must match an existing DB cluster identifier.
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * A filter that specifies one or more DB clusters to describe.
     *
     * Supported Filters:
     * + `clone-group-id` - Accepts clone group identifiers. The results list only includes information about the DB clusters associated with these clone groups.
     * + `db-cluster-id` - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list only includes information about the DB clusters identified by these ARNs.
     * + `db-cluster-resource-id` - Accepts DB cluster resource identifiers. The results list will only include information about the DB clusters identified by these DB cluster resource identifiers.
     * + `domain` - Accepts Active Directory directory IDs. The results list only includes information about the DB clusters associated with these domains.
     * + `engine` - Accepts engine names. The results list only includes information about the DB clusters for these engines.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * Specifies whether the output includes information about clusters shared from other Amazon Web Services accounts.
     */
    public val includeShared: kotlin.Boolean? = builder.includeShared
    /**
     * An optional pagination token provided by a previous `DescribeDBClusters` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token called a marker is included in the response so you can retrieve the remaining results.
     *
     * Default: 100
     *
     * Constraints: Minimum 20, maximum 100
     */
    public val maxRecords: kotlin.Int? = builder.maxRecords

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DescribeDbClustersRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDbClustersRequest(")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("filters=$filters,")
        append("includeShared=$includeShared,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbClusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (includeShared?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDbClustersRequest

        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (filters != other.filters) return false
        if (includeShared != other.includeShared) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DescribeDbClustersRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The user-supplied DB cluster identifier or the Amazon Resource Name (ARN) of the DB cluster. If this parameter is specified, information for only the specific DB cluster is returned. This parameter isn't case-sensitive.
         *
         * Constraints:
         * + If supplied, must match an existing DB cluster identifier.
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * A filter that specifies one or more DB clusters to describe.
         *
         * Supported Filters:
         * + `clone-group-id` - Accepts clone group identifiers. The results list only includes information about the DB clusters associated with these clone groups.
         * + `db-cluster-id` - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list only includes information about the DB clusters identified by these ARNs.
         * + `db-cluster-resource-id` - Accepts DB cluster resource identifiers. The results list will only include information about the DB clusters identified by these DB cluster resource identifiers.
         * + `domain` - Accepts Active Directory directory IDs. The results list only includes information about the DB clusters associated with these domains.
         * + `engine` - Accepts engine names. The results list only includes information about the DB clusters for these engines.
         */
        public var filters: List<Filter>? = null
        /**
         * Specifies whether the output includes information about clusters shared from other Amazon Web Services accounts.
         */
        public var includeShared: kotlin.Boolean? = null
        /**
         * An optional pagination token provided by a previous `DescribeDBClusters` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token called a marker is included in the response so you can retrieve the remaining results.
         *
         * Default: 100
         *
         * Constraints: Minimum 20, maximum 100
         */
        public var maxRecords: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DescribeDbClustersRequest) : this() {
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.filters = x.filters
            this.includeShared = x.includeShared
            this.marker = x.marker
            this.maxRecords = x.maxRecords
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DescribeDbClustersRequest = DescribeDbClustersRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
