// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 *
 */
public class DeleteDbClusterRequest private constructor(builder: Builder) {
    /**
     * The DB cluster identifier for the DB cluster to be deleted. This parameter isn't case-sensitive.
     *
     * Constraints:
     * + Must match an existing DBClusterIdentifier.
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * Specifies whether to remove automated backups immediately after the DB cluster is deleted. This parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB cluster is deleted.
     */
    public val deleteAutomatedBackups: kotlin.Boolean? = builder.deleteAutomatedBackups
    /**
     * The DB cluster snapshot identifier of the new DB cluster snapshot created when `SkipFinalSnapshot` is disabled.
     *
     * If you specify this parameter and also skip the creation of a final DB cluster snapshot with the `SkipFinalShapshot` parameter, the request results in an error.
     *
     * Constraints:
     * + Must be 1 to 255 letters, numbers, or hyphens.
     * + First character must be a letter
     * + Can't end with a hyphen or contain two consecutive hyphens
     */
    public val finalDbSnapshotIdentifier: kotlin.String? = builder.finalDbSnapshotIdentifier
    /**
     * Specifies whether to skip the creation of a final DB cluster snapshot before RDS deletes the DB cluster. If you set this value to `true`, RDS doesn't create a final DB cluster snapshot. If you set this value to `false` or don't specify it, RDS creates a DB cluster snapshot before it deletes the DB cluster. By default, this parameter is disabled, so RDS creates a final DB cluster snapshot.
     *
     * If `SkipFinalSnapshot` is disabled, you must specify a value for the `FinalDBSnapshotIdentifier` parameter.
     */
    public val skipFinalSnapshot: kotlin.Boolean? = builder.skipFinalSnapshot

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DeleteDbClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteDbClusterRequest(")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("deleteAutomatedBackups=$deleteAutomatedBackups,")
        append("finalDbSnapshotIdentifier=$finalDbSnapshotIdentifier,")
        append("skipFinalSnapshot=$skipFinalSnapshot")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbClusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (deleteAutomatedBackups?.hashCode() ?: 0)
        result = 31 * result + (finalDbSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (skipFinalSnapshot?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteDbClusterRequest

        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (deleteAutomatedBackups != other.deleteAutomatedBackups) return false
        if (finalDbSnapshotIdentifier != other.finalDbSnapshotIdentifier) return false
        if (skipFinalSnapshot != other.skipFinalSnapshot) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DeleteDbClusterRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The DB cluster identifier for the DB cluster to be deleted. This parameter isn't case-sensitive.
         *
         * Constraints:
         * + Must match an existing DBClusterIdentifier.
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * Specifies whether to remove automated backups immediately after the DB cluster is deleted. This parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB cluster is deleted.
         */
        public var deleteAutomatedBackups: kotlin.Boolean? = null
        /**
         * The DB cluster snapshot identifier of the new DB cluster snapshot created when `SkipFinalSnapshot` is disabled.
         *
         * If you specify this parameter and also skip the creation of a final DB cluster snapshot with the `SkipFinalShapshot` parameter, the request results in an error.
         *
         * Constraints:
         * + Must be 1 to 255 letters, numbers, or hyphens.
         * + First character must be a letter
         * + Can't end with a hyphen or contain two consecutive hyphens
         */
        public var finalDbSnapshotIdentifier: kotlin.String? = null
        /**
         * Specifies whether to skip the creation of a final DB cluster snapshot before RDS deletes the DB cluster. If you set this value to `true`, RDS doesn't create a final DB cluster snapshot. If you set this value to `false` or don't specify it, RDS creates a DB cluster snapshot before it deletes the DB cluster. By default, this parameter is disabled, so RDS creates a final DB cluster snapshot.
         *
         * If `SkipFinalSnapshot` is disabled, you must specify a value for the `FinalDBSnapshotIdentifier` parameter.
         */
        public var skipFinalSnapshot: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DeleteDbClusterRequest) : this() {
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.deleteAutomatedBackups = x.deleteAutomatedBackups
            this.finalDbSnapshotIdentifier = x.finalDbSnapshotIdentifier
            this.skipFinalSnapshot = x.skipFinalSnapshot
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DeleteDbClusterRequest = DeleteDbClusterRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
