// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the details of an Amazon Aurora DB cluster or Multi-AZ DB cluster.
 *
 * For an Amazon Aurora DB cluster, this data type is used as a response element in the operations `CreateDBCluster`, `DeleteDBCluster`, `DescribeDBClusters`, `FailoverDBCluster`, `ModifyDBCluster`, `PromoteReadReplicaDBCluster`, `RestoreDBClusterFromS3`, `RestoreDBClusterFromSnapshot`, `RestoreDBClusterToPointInTime`, `StartDBCluster`, and `StopDBCluster`.
 *
 * For a Multi-AZ DB cluster, this data type is used as a response element in the operations `CreateDBCluster`, `DeleteDBCluster`, `DescribeDBClusters`, `FailoverDBCluster`, `ModifyDBCluster`, `RebootDBCluster`, `RestoreDBClusterFromSnapshot`, and `RestoreDBClusterToPointInTime`.
 *
 * For more information on Amazon Aurora DB clusters, see [ What is Amazon Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html) in the *Amazon Aurora User Guide.*
 *
 * For more information on Multi-AZ DB clusters, see [ Multi-AZ deployments with two readable standby DB instances](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide.*
 */
public class DbCluster private constructor(builder: Builder) {
    /**
     * The name of the Amazon Kinesis data stream used for the database activity stream.
     */
    public val activityStreamKinesisStreamName: kotlin.String? = builder.activityStreamKinesisStreamName
    /**
     * The Amazon Web Services KMS key identifier used for encrypting messages in the database activity stream.
     *
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     */
    public val activityStreamKmsKeyId: kotlin.String? = builder.activityStreamKmsKeyId
    /**
     * The mode of the database activity stream. Database events such as a change or access generate an activity stream event. The database session can handle these events either synchronously or asynchronously.
     */
    public val activityStreamMode: aws.sdk.kotlin.services.rds.model.ActivityStreamMode? = builder.activityStreamMode
    /**
     * The status of the database activity stream.
     */
    public val activityStreamStatus: aws.sdk.kotlin.services.rds.model.ActivityStreamStatus? = builder.activityStreamStatus
    /**
     * For all database engines except Amazon Aurora, `AllocatedStorage` specifies the allocated storage size in gibibytes (GiB). For Aurora, `AllocatedStorage` always returns 1, because Aurora DB cluster storage size isn't fixed, but instead automatically adjusts as needed.
     */
    public val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * A list of the Amazon Web Services Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.
     */
    public val associatedRoles: List<DbClusterRole>? = builder.associatedRoles
    /**
     * Indicates whether minor version patches are applied automatically.
     *
     * This setting is only for non-Aurora Multi-AZ DB clusters.
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * The time when a stopped DB cluster is restarted automatically.
     */
    public val automaticRestartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.automaticRestartTime
    /**
     * The list of Availability Zones (AZs) where instances in the DB cluster can be created.
     */
    public val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.
     */
    public val awsBackupRecoveryPointArn: kotlin.String? = builder.awsBackupRecoveryPointArn
    /**
     * The number of change records stored for Backtrack.
     */
    public val backtrackConsumedChangeRecords: kotlin.Long? = builder.backtrackConsumedChangeRecords
    /**
     * The target backtrack window, in seconds. If this value is set to `0`, backtracking is disabled for the DB cluster. Otherwise, backtracking is enabled.
     */
    public val backtrackWindow: kotlin.Long? = builder.backtrackWindow
    /**
     * The number of days for which automatic DB snapshots are retained.
     */
    public val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * The current capacity of an Aurora Serverless v1 DB cluster. The capacity is `0` (zero) when the cluster is paused.
     *
     * For more information about Aurora Serverless v1, see [Using Amazon Aurora Serverless v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html) in the *Amazon Aurora User Guide*.
     */
    public val capacity: kotlin.Int? = builder.capacity
    /**
     * The details of the DB instance’s server certificate.
     *
     * For more information, see [Using SSL/TLS to encrypt a connection to a DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html) in the *Amazon RDS User Guide* and [ Using SSL/TLS to encrypt a connection to a DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html) in the *Amazon Aurora User Guide*.
     */
    public val certificateDetails: aws.sdk.kotlin.services.rds.model.CertificateDetails? = builder.certificateDetails
    /**
     * If present, specifies the name of the character set that this cluster is associated with.
     */
    public val characterSetName: kotlin.String? = builder.characterSetName
    /**
     * The ID of the clone group with which the DB cluster is associated.
     */
    public val cloneGroupId: kotlin.String? = builder.cloneGroupId
    /**
     * The time when the DB cluster was created, in Universal Coordinated Time (UTC).
     */
    public val clusterCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.clusterCreateTime
    /**
     * The scalability mode of the Aurora DB cluster. When set to `limitless`, the cluster operates as an Aurora Limitless Database. When set to `standard` (the default), the cluster uses normal DB instance creation.
     */
    public val clusterScalabilityType: aws.sdk.kotlin.services.rds.model.ClusterScalabilityType? = builder.clusterScalabilityType
    /**
     * Indicates whether tags are copied from the DB cluster to snapshots of the DB cluster.
     */
    public val copyTagsToSnapshot: kotlin.Boolean? = builder.copyTagsToSnapshot
    /**
     * Indicates whether the DB cluster is a clone of a DB cluster owned by a different Amazon Web Services account.
     */
    public val crossAccountClone: kotlin.Boolean? = builder.crossAccountClone
    /**
     * The custom endpoints associated with the DB cluster.
     */
    public val customEndpoints: List<String>? = builder.customEndpoints
    /**
     * The name of the initial database that was specified for the DB cluster when it was created, if one was provided. This same name is returned for the life of the DB cluster.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * The Amazon Resource Name (ARN) for the DB cluster.
     */
    public val dbClusterArn: kotlin.String? = builder.dbClusterArn
    /**
     * The user-supplied identifier for the DB cluster. This identifier is the unique key that identifies a DB cluster.
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The name of the compute and memory capacity class of the DB instance.
     *
     * This setting is only for non-Aurora Multi-AZ DB clusters.
     */
    public val dbClusterInstanceClass: kotlin.String? = builder.dbClusterInstanceClass
    /**
     * The list of DB instances that make up the DB cluster.
     */
    public val dbClusterMembers: List<DbClusterMember>? = builder.dbClusterMembers
    /**
     * The list of option group memberships for this DB cluster.
     */
    public val dbClusterOptionGroupMemberships: List<DbClusterOptionGroupStatus>? = builder.dbClusterOptionGroupMemberships
    /**
     * The name of the DB cluster parameter group for the DB cluster.
     */
    public val dbClusterParameterGroup: kotlin.String? = builder.dbClusterParameterGroup
    /**
     * The Amazon Web Services Region-unique, immutable identifier for the DB cluster. This identifier is found in Amazon Web Services CloudTrail log entries whenever the KMS key for the DB cluster is accessed.
     */
    public val dbClusterResourceId: kotlin.String? = builder.dbClusterResourceId
    /**
     * Information about the subnet group associated with the DB cluster, including the name, description, and subnets in the subnet group.
     */
    public val dbSubnetGroup: kotlin.String? = builder.dbSubnetGroup
    /**
     * Reserved for future use.
     */
    public val dbSystemId: kotlin.String? = builder.dbSystemId
    /**
     * Indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled.
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The Active Directory Domain membership records associated with the DB cluster.
     */
    public val domainMemberships: List<DomainMembership>? = builder.domainMemberships
    /**
     * The earliest time to which a DB cluster can be backtracked.
     */
    public val earliestBacktrackTime: aws.smithy.kotlin.runtime.time.Instant? = builder.earliestBacktrackTime
    /**
     * The earliest time to which a database can be restored with point-in-time restore.
     */
    public val earliestRestorableTime: aws.smithy.kotlin.runtime.time.Instant? = builder.earliestRestorableTime
    /**
     * A list of log types that this DB cluster is configured to export to CloudWatch Logs.
     *
     * Log types vary by DB engine. For information about the log types for each DB engine, see [Amazon RDS Database Log Files](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html) in the *Amazon Aurora User Guide.*
     */
    public val enabledCloudwatchLogsExports: List<String>? = builder.enabledCloudwatchLogsExports
    /**
     * The connection endpoint for the primary instance of the DB cluster.
     */
    public val endpoint: kotlin.String? = builder.endpoint
    /**
     * The database engine used for this DB cluster.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The life cycle type for the DB cluster.
     *
     * For more information, see CreateDBCluster.
     */
    public val engineLifecycleSupport: kotlin.String? = builder.engineLifecycleSupport
    /**
     * The DB engine mode of the DB cluster, either `provisioned` or `serverless`.
     *
     * For more information, see [ CreateDBCluster](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html).
     */
    public val engineMode: kotlin.String? = builder.engineMode
    /**
     * The version of the database engine.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * Indicates whether write forwarding is enabled for a secondary cluster in an Aurora global database. Because write forwarding takes time to enable, check the value of `GlobalWriteForwardingStatus` to confirm that the request has completed before using the write forwarding feature for this cluster.
     */
    public val globalWriteForwardingRequested: kotlin.Boolean? = builder.globalWriteForwardingRequested
    /**
     * The status of write forwarding for a secondary cluster in an Aurora global database.
     */
    public val globalWriteForwardingStatus: aws.sdk.kotlin.services.rds.model.WriteForwardingStatus? = builder.globalWriteForwardingStatus
    /**
     * The ID that Amazon Route 53 assigns when you create a hosted zone.
     */
    public val hostedZoneId: kotlin.String? = builder.hostedZoneId
    /**
     * Indicates whether the HTTP endpoint is enabled for an Aurora DB cluster.
     *
     * When enabled, the HTTP endpoint provides a connectionless web service API (RDS Data API) for running SQL queries on the DB cluster. You can also query your database from inside the RDS console with the RDS query editor.
     *
     * For more information, see [Using RDS Data API](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html) in the *Amazon Aurora User Guide*.
     */
    public val httpEndpointEnabled: kotlin.Boolean? = builder.httpEndpointEnabled
    /**
     * Indicates whether the mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.
     */
    public val iamDatabaseAuthenticationEnabled: kotlin.Boolean? = builder.iamDatabaseAuthenticationEnabled
    /**
     * The next time you can modify the DB cluster to use the `aurora-iopt1` storage type.
     *
     * This setting is only for Aurora DB clusters.
     */
    public val ioOptimizedNextAllowedModificationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.ioOptimizedNextAllowedModificationTime
    /**
     * The Provisioned IOPS (I/O operations per second) value.
     *
     * This setting is only for non-Aurora Multi-AZ DB clusters.
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * If `StorageEncrypted` is enabled, the Amazon Web Services KMS key identifier for the encrypted DB cluster.
     *
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The latest time to which a database can be restored with point-in-time restore.
     */
    public val latestRestorableTime: aws.smithy.kotlin.runtime.time.Instant? = builder.latestRestorableTime
    /**
     * The details for Aurora Limitless Database.
     */
    public val limitlessDatabase: aws.sdk.kotlin.services.rds.model.LimitlessDatabase? = builder.limitlessDatabase
    /**
     * Indicates whether an Aurora DB cluster has in-cluster write forwarding enabled, not enabled, requested, or is in the process of enabling it.
     */
    public val localWriteForwardingStatus: aws.sdk.kotlin.services.rds.model.LocalWriteForwardingStatus? = builder.localWriteForwardingStatus
    /**
     * The secret managed by RDS in Amazon Web Services Secrets Manager for the master user password.
     *
     * For more information, see [Password management with Amazon Web Services Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide* and [Password management with Amazon Web Services Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html) in the *Amazon Aurora User Guide.*
     */
    public val masterUserSecret: aws.sdk.kotlin.services.rds.model.MasterUserSecret? = builder.masterUserSecret
    /**
     * The master username for the DB cluster.
     */
    public val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster.
     *
     * This setting is only for non-Aurora Multi-AZ DB clusters.
     */
    public val monitoringInterval: kotlin.Int? = builder.monitoringInterval
    /**
     * The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.
     *
     * This setting is only for non-Aurora Multi-AZ DB clusters.
     */
    public val monitoringRoleArn: kotlin.String? = builder.monitoringRoleArn
    /**
     * Indicates whether the DB cluster has instances in multiple Availability Zones.
     */
    public val multiAz: kotlin.Boolean? = builder.multiAz
    /**
     * The network type of the DB instance.
     *
     * The network type is determined by the `DBSubnetGroup` specified for the DB cluster. A `DBSubnetGroup` can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (`DUAL`).
     *
     * For more information, see [ Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon Aurora User Guide.*
     *
     * This setting is only for Aurora DB clusters.
     *
     * Valid Values: `IPV4 | DUAL`
     */
    public val networkType: kotlin.String? = builder.networkType
    /**
     * Information about pending changes to the DB cluster. This information is returned only when there are pending changes. Specific changes are identified by subelements.
     */
    public val pendingModifiedValues: aws.sdk.kotlin.services.rds.model.ClusterPendingModifiedValues? = builder.pendingModifiedValues
    /**
     * The progress of the operation as a percentage.
     */
    public val percentProgress: kotlin.String? = builder.percentProgress
    /**
     * Indicates whether Performance Insights is enabled for the DB cluster.
     *
     * This setting is only for non-Aurora Multi-AZ DB clusters.
     */
    public val performanceInsightsEnabled: kotlin.Boolean? = builder.performanceInsightsEnabled
    /**
     * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
     *
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     *
     * This setting is only for non-Aurora Multi-AZ DB clusters.
     */
    public val performanceInsightsKmsKeyId: kotlin.String? = builder.performanceInsightsKmsKeyId
    /**
     * The number of days to retain Performance Insights data.
     *
     * This setting is only for non-Aurora Multi-AZ DB clusters.
     *
     * Valid Values:
     * + `7`
     * + *month* * 31, where *month* is a number of months from 1-23. Examples: `93` (3 months * 31), `341` (11 months * 31), `589` (19 months * 31)
     * + `731`
     *
     * Default: `7` days
     */
    public val performanceInsightsRetentionPeriod: kotlin.Int? = builder.performanceInsightsRetentionPeriod
    /**
     * The port that the database engine is listening on.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The daily time range during which automated backups are created if automated backups are enabled, as determined by the `BackupRetentionPeriod`.
     */
    public val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * Indicates whether the DB cluster is publicly accessible.
     *
     * When the DB cluster is publicly accessible and you connect from outside of the DB cluster's virtual private cloud (VPC), its Domain Name System (DNS) endpoint resolves to the public IP address. When you connect from within the same VPC as the DB cluster, the endpoint resolves to the private IP address. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.
     *
     * When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.
     *
     * For more information, see CreateDBCluster.
     *
     * This setting is only for non-Aurora Multi-AZ DB clusters.
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * Reserved for future use.
     */
    public val rdsCustomClusterConfiguration: aws.sdk.kotlin.services.rds.model.RdsCustomClusterConfiguration? = builder.rdsCustomClusterConfiguration
    /**
     * Contains one or more identifiers of the read replicas associated with this DB cluster.
     */
    public val readReplicaIdentifiers: List<String>? = builder.readReplicaIdentifiers
    /**
     * The reader endpoint for the DB cluster. The reader endpoint for a DB cluster load-balances connections across the Aurora Replicas that are available in a DB cluster. As clients request new connections to the reader endpoint, Aurora distributes the connection requests among the Aurora Replicas in the DB cluster. This functionality can help balance your read workload across multiple Aurora Replicas in your DB cluster.
     *
     * If a failover occurs, and the Aurora Replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Aurora Replicas in the cluster, you can then reconnect to the reader endpoint.
     */
    public val readerEndpoint: kotlin.String? = builder.readerEndpoint
    /**
     * The identifier of the source DB cluster if this DB cluster is a read replica.
     */
    public val replicationSourceIdentifier: kotlin.String? = builder.replicationSourceIdentifier
    /**
     * The scaling configuration for an Aurora DB cluster in `serverless` DB engine mode.
     *
     * For more information, see [Using Amazon Aurora Serverless v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html) in the *Amazon Aurora User Guide*.
     */
    public val scalingConfigurationInfo: aws.sdk.kotlin.services.rds.model.ScalingConfigurationInfo? = builder.scalingConfigurationInfo
    /**
     * The scaling configuration for an Aurora Serverless v2 DB cluster.
     *
     * For more information, see [Using Amazon Aurora Serverless v2](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html) in the *Amazon Aurora User Guide*.
     */
    public val serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfigurationInfo? = builder.serverlessV2ScalingConfiguration
    /**
     * The current state of this DB cluster.
     */
    public val status: kotlin.String? = builder.status
    /**
     * Reserved for future use.
     */
    public val statusInfos: List<DbClusterStatusInfo>? = builder.statusInfos
    /**
     * Indicates whether the DB cluster is encrypted.
     */
    public val storageEncrypted: kotlin.Boolean? = builder.storageEncrypted
    /**
     * The storage throughput for the DB cluster. The throughput is automatically set based on the IOPS that you provision, and is not configurable.
     *
     * This setting is only for non-Aurora Multi-AZ DB clusters.
     */
    public val storageThroughput: kotlin.Int? = builder.storageThroughput
    /**
     * The storage type associated with the DB cluster.
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * A list of tags.
     *
     * For more information, see [Tagging Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html) in the *Amazon Aurora User Guide*.
     */
    public val tagList: List<Tag>? = builder.tagList
    /**
     * The list of VPC security groups that the DB cluster belongs to.
     */
    public val vpcSecurityGroups: List<VpcSecurityGroupMembership>? = builder.vpcSecurityGroups

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DbCluster = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbCluster(")
        append("activityStreamKinesisStreamName=$activityStreamKinesisStreamName,")
        append("activityStreamKmsKeyId=$activityStreamKmsKeyId,")
        append("activityStreamMode=$activityStreamMode,")
        append("activityStreamStatus=$activityStreamStatus,")
        append("allocatedStorage=$allocatedStorage,")
        append("associatedRoles=$associatedRoles,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("automaticRestartTime=$automaticRestartTime,")
        append("availabilityZones=$availabilityZones,")
        append("awsBackupRecoveryPointArn=$awsBackupRecoveryPointArn,")
        append("backtrackConsumedChangeRecords=$backtrackConsumedChangeRecords,")
        append("backtrackWindow=$backtrackWindow,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("capacity=$capacity,")
        append("certificateDetails=$certificateDetails,")
        append("characterSetName=$characterSetName,")
        append("cloneGroupId=$cloneGroupId,")
        append("clusterCreateTime=$clusterCreateTime,")
        append("clusterScalabilityType=$clusterScalabilityType,")
        append("copyTagsToSnapshot=$copyTagsToSnapshot,")
        append("crossAccountClone=$crossAccountClone,")
        append("customEndpoints=$customEndpoints,")
        append("databaseName=$databaseName,")
        append("dbClusterArn=$dbClusterArn,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterInstanceClass=$dbClusterInstanceClass,")
        append("dbClusterMembers=$dbClusterMembers,")
        append("dbClusterOptionGroupMemberships=$dbClusterOptionGroupMemberships,")
        append("dbClusterParameterGroup=$dbClusterParameterGroup,")
        append("dbClusterResourceId=$dbClusterResourceId,")
        append("dbSubnetGroup=$dbSubnetGroup,")
        append("dbSystemId=$dbSystemId,")
        append("deletionProtection=$deletionProtection,")
        append("domainMemberships=$domainMemberships,")
        append("earliestBacktrackTime=$earliestBacktrackTime,")
        append("earliestRestorableTime=$earliestRestorableTime,")
        append("enabledCloudwatchLogsExports=$enabledCloudwatchLogsExports,")
        append("endpoint=$endpoint,")
        append("engine=$engine,")
        append("engineLifecycleSupport=$engineLifecycleSupport,")
        append("engineMode=$engineMode,")
        append("engineVersion=$engineVersion,")
        append("globalWriteForwardingRequested=$globalWriteForwardingRequested,")
        append("globalWriteForwardingStatus=$globalWriteForwardingStatus,")
        append("hostedZoneId=$hostedZoneId,")
        append("httpEndpointEnabled=$httpEndpointEnabled,")
        append("iamDatabaseAuthenticationEnabled=$iamDatabaseAuthenticationEnabled,")
        append("ioOptimizedNextAllowedModificationTime=$ioOptimizedNextAllowedModificationTime,")
        append("iops=$iops,")
        append("kmsKeyId=$kmsKeyId,")
        append("latestRestorableTime=$latestRestorableTime,")
        append("limitlessDatabase=$limitlessDatabase,")
        append("localWriteForwardingStatus=$localWriteForwardingStatus,")
        append("masterUserSecret=$masterUserSecret,")
        append("masterUsername=$masterUsername,")
        append("monitoringInterval=$monitoringInterval,")
        append("monitoringRoleArn=$monitoringRoleArn,")
        append("multiAz=$multiAz,")
        append("networkType=$networkType,")
        append("pendingModifiedValues=$pendingModifiedValues,")
        append("percentProgress=$percentProgress,")
        append("performanceInsightsEnabled=$performanceInsightsEnabled,")
        append("performanceInsightsKmsKeyId=$performanceInsightsKmsKeyId,")
        append("performanceInsightsRetentionPeriod=$performanceInsightsRetentionPeriod,")
        append("port=$port,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("rdsCustomClusterConfiguration=$rdsCustomClusterConfiguration,")
        append("readReplicaIdentifiers=$readReplicaIdentifiers,")
        append("readerEndpoint=$readerEndpoint,")
        append("replicationSourceIdentifier=$replicationSourceIdentifier,")
        append("scalingConfigurationInfo=$scalingConfigurationInfo,")
        append("serverlessV2ScalingConfiguration=$serverlessV2ScalingConfiguration,")
        append("status=$status,")
        append("statusInfos=$statusInfos,")
        append("storageEncrypted=$storageEncrypted,")
        append("storageThroughput=$storageThroughput,")
        append("storageType=$storageType,")
        append("tagList=$tagList,")
        append("vpcSecurityGroups=$vpcSecurityGroups")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activityStreamKinesisStreamName?.hashCode() ?: 0
        result = 31 * result + (activityStreamKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (activityStreamMode?.hashCode() ?: 0)
        result = 31 * result + (activityStreamStatus?.hashCode() ?: 0)
        result = 31 * result + (allocatedStorage ?: 0)
        result = 31 * result + (associatedRoles?.hashCode() ?: 0)
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (automaticRestartTime?.hashCode() ?: 0)
        result = 31 * result + (availabilityZones?.hashCode() ?: 0)
        result = 31 * result + (awsBackupRecoveryPointArn?.hashCode() ?: 0)
        result = 31 * result + (backtrackConsumedChangeRecords?.hashCode() ?: 0)
        result = 31 * result + (backtrackWindow?.hashCode() ?: 0)
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (capacity ?: 0)
        result = 31 * result + (certificateDetails?.hashCode() ?: 0)
        result = 31 * result + (characterSetName?.hashCode() ?: 0)
        result = 31 * result + (cloneGroupId?.hashCode() ?: 0)
        result = 31 * result + (clusterCreateTime?.hashCode() ?: 0)
        result = 31 * result + (clusterScalabilityType?.hashCode() ?: 0)
        result = 31 * result + (copyTagsToSnapshot?.hashCode() ?: 0)
        result = 31 * result + (crossAccountClone?.hashCode() ?: 0)
        result = 31 * result + (customEndpoints?.hashCode() ?: 0)
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (dbClusterArn?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbClusterMembers?.hashCode() ?: 0)
        result = 31 * result + (dbClusterOptionGroupMemberships?.hashCode() ?: 0)
        result = 31 * result + (dbClusterParameterGroup?.hashCode() ?: 0)
        result = 31 * result + (dbClusterResourceId?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroup?.hashCode() ?: 0)
        result = 31 * result + (dbSystemId?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (domainMemberships?.hashCode() ?: 0)
        result = 31 * result + (earliestBacktrackTime?.hashCode() ?: 0)
        result = 31 * result + (earliestRestorableTime?.hashCode() ?: 0)
        result = 31 * result + (enabledCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineLifecycleSupport?.hashCode() ?: 0)
        result = 31 * result + (engineMode?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (globalWriteForwardingRequested?.hashCode() ?: 0)
        result = 31 * result + (globalWriteForwardingStatus?.hashCode() ?: 0)
        result = 31 * result + (hostedZoneId?.hashCode() ?: 0)
        result = 31 * result + (httpEndpointEnabled?.hashCode() ?: 0)
        result = 31 * result + (iamDatabaseAuthenticationEnabled?.hashCode() ?: 0)
        result = 31 * result + (ioOptimizedNextAllowedModificationTime?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (latestRestorableTime?.hashCode() ?: 0)
        result = 31 * result + (limitlessDatabase?.hashCode() ?: 0)
        result = 31 * result + (localWriteForwardingStatus?.hashCode() ?: 0)
        result = 31 * result + (masterUserSecret?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (monitoringInterval ?: 0)
        result = 31 * result + (monitoringRoleArn?.hashCode() ?: 0)
        result = 31 * result + (multiAz?.hashCode() ?: 0)
        result = 31 * result + (networkType?.hashCode() ?: 0)
        result = 31 * result + (pendingModifiedValues?.hashCode() ?: 0)
        result = 31 * result + (percentProgress?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsEnabled?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsRetentionPeriod ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (rdsCustomClusterConfiguration?.hashCode() ?: 0)
        result = 31 * result + (readReplicaIdentifiers?.hashCode() ?: 0)
        result = 31 * result + (readerEndpoint?.hashCode() ?: 0)
        result = 31 * result + (replicationSourceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (scalingConfigurationInfo?.hashCode() ?: 0)
        result = 31 * result + (serverlessV2ScalingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusInfos?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted?.hashCode() ?: 0)
        result = 31 * result + (storageThroughput ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (tagList?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroups?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbCluster

        if (activityStreamKinesisStreamName != other.activityStreamKinesisStreamName) return false
        if (activityStreamKmsKeyId != other.activityStreamKmsKeyId) return false
        if (activityStreamMode != other.activityStreamMode) return false
        if (activityStreamStatus != other.activityStreamStatus) return false
        if (allocatedStorage != other.allocatedStorage) return false
        if (associatedRoles != other.associatedRoles) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (automaticRestartTime != other.automaticRestartTime) return false
        if (availabilityZones != other.availabilityZones) return false
        if (awsBackupRecoveryPointArn != other.awsBackupRecoveryPointArn) return false
        if (backtrackConsumedChangeRecords != other.backtrackConsumedChangeRecords) return false
        if (backtrackWindow != other.backtrackWindow) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (capacity != other.capacity) return false
        if (certificateDetails != other.certificateDetails) return false
        if (characterSetName != other.characterSetName) return false
        if (cloneGroupId != other.cloneGroupId) return false
        if (clusterCreateTime != other.clusterCreateTime) return false
        if (clusterScalabilityType != other.clusterScalabilityType) return false
        if (copyTagsToSnapshot != other.copyTagsToSnapshot) return false
        if (crossAccountClone != other.crossAccountClone) return false
        if (customEndpoints != other.customEndpoints) return false
        if (databaseName != other.databaseName) return false
        if (dbClusterArn != other.dbClusterArn) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterInstanceClass != other.dbClusterInstanceClass) return false
        if (dbClusterMembers != other.dbClusterMembers) return false
        if (dbClusterOptionGroupMemberships != other.dbClusterOptionGroupMemberships) return false
        if (dbClusterParameterGroup != other.dbClusterParameterGroup) return false
        if (dbClusterResourceId != other.dbClusterResourceId) return false
        if (dbSubnetGroup != other.dbSubnetGroup) return false
        if (dbSystemId != other.dbSystemId) return false
        if (deletionProtection != other.deletionProtection) return false
        if (domainMemberships != other.domainMemberships) return false
        if (earliestBacktrackTime != other.earliestBacktrackTime) return false
        if (earliestRestorableTime != other.earliestRestorableTime) return false
        if (enabledCloudwatchLogsExports != other.enabledCloudwatchLogsExports) return false
        if (endpoint != other.endpoint) return false
        if (engine != other.engine) return false
        if (engineLifecycleSupport != other.engineLifecycleSupport) return false
        if (engineMode != other.engineMode) return false
        if (engineVersion != other.engineVersion) return false
        if (globalWriteForwardingRequested != other.globalWriteForwardingRequested) return false
        if (globalWriteForwardingStatus != other.globalWriteForwardingStatus) return false
        if (hostedZoneId != other.hostedZoneId) return false
        if (httpEndpointEnabled != other.httpEndpointEnabled) return false
        if (iamDatabaseAuthenticationEnabled != other.iamDatabaseAuthenticationEnabled) return false
        if (ioOptimizedNextAllowedModificationTime != other.ioOptimizedNextAllowedModificationTime) return false
        if (iops != other.iops) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (latestRestorableTime != other.latestRestorableTime) return false
        if (limitlessDatabase != other.limitlessDatabase) return false
        if (localWriteForwardingStatus != other.localWriteForwardingStatus) return false
        if (masterUserSecret != other.masterUserSecret) return false
        if (masterUsername != other.masterUsername) return false
        if (monitoringInterval != other.monitoringInterval) return false
        if (monitoringRoleArn != other.monitoringRoleArn) return false
        if (multiAz != other.multiAz) return false
        if (networkType != other.networkType) return false
        if (pendingModifiedValues != other.pendingModifiedValues) return false
        if (percentProgress != other.percentProgress) return false
        if (performanceInsightsEnabled != other.performanceInsightsEnabled) return false
        if (performanceInsightsKmsKeyId != other.performanceInsightsKmsKeyId) return false
        if (performanceInsightsRetentionPeriod != other.performanceInsightsRetentionPeriod) return false
        if (port != other.port) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (rdsCustomClusterConfiguration != other.rdsCustomClusterConfiguration) return false
        if (readReplicaIdentifiers != other.readReplicaIdentifiers) return false
        if (readerEndpoint != other.readerEndpoint) return false
        if (replicationSourceIdentifier != other.replicationSourceIdentifier) return false
        if (scalingConfigurationInfo != other.scalingConfigurationInfo) return false
        if (serverlessV2ScalingConfiguration != other.serverlessV2ScalingConfiguration) return false
        if (status != other.status) return false
        if (statusInfos != other.statusInfos) return false
        if (storageEncrypted != other.storageEncrypted) return false
        if (storageThroughput != other.storageThroughput) return false
        if (storageType != other.storageType) return false
        if (tagList != other.tagList) return false
        if (vpcSecurityGroups != other.vpcSecurityGroups) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DbCluster = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the Amazon Kinesis data stream used for the database activity stream.
         */
        public var activityStreamKinesisStreamName: kotlin.String? = null
        /**
         * The Amazon Web Services KMS key identifier used for encrypting messages in the database activity stream.
         *
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         */
        public var activityStreamKmsKeyId: kotlin.String? = null
        /**
         * The mode of the database activity stream. Database events such as a change or access generate an activity stream event. The database session can handle these events either synchronously or asynchronously.
         */
        public var activityStreamMode: aws.sdk.kotlin.services.rds.model.ActivityStreamMode? = null
        /**
         * The status of the database activity stream.
         */
        public var activityStreamStatus: aws.sdk.kotlin.services.rds.model.ActivityStreamStatus? = null
        /**
         * For all database engines except Amazon Aurora, `AllocatedStorage` specifies the allocated storage size in gibibytes (GiB). For Aurora, `AllocatedStorage` always returns 1, because Aurora DB cluster storage size isn't fixed, but instead automatically adjusts as needed.
         */
        public var allocatedStorage: kotlin.Int? = null
        /**
         * A list of the Amazon Web Services Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.
         */
        public var associatedRoles: List<DbClusterRole>? = null
        /**
         * Indicates whether minor version patches are applied automatically.
         *
         * This setting is only for non-Aurora Multi-AZ DB clusters.
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * The time when a stopped DB cluster is restarted automatically.
         */
        public var automaticRestartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The list of Availability Zones (AZs) where instances in the DB cluster can be created.
         */
        public var availabilityZones: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.
         */
        public var awsBackupRecoveryPointArn: kotlin.String? = null
        /**
         * The number of change records stored for Backtrack.
         */
        public var backtrackConsumedChangeRecords: kotlin.Long? = null
        /**
         * The target backtrack window, in seconds. If this value is set to `0`, backtracking is disabled for the DB cluster. Otherwise, backtracking is enabled.
         */
        public var backtrackWindow: kotlin.Long? = null
        /**
         * The number of days for which automatic DB snapshots are retained.
         */
        public var backupRetentionPeriod: kotlin.Int? = null
        /**
         * The current capacity of an Aurora Serverless v1 DB cluster. The capacity is `0` (zero) when the cluster is paused.
         *
         * For more information about Aurora Serverless v1, see [Using Amazon Aurora Serverless v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html) in the *Amazon Aurora User Guide*.
         */
        public var capacity: kotlin.Int? = null
        /**
         * The details of the DB instance’s server certificate.
         *
         * For more information, see [Using SSL/TLS to encrypt a connection to a DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html) in the *Amazon RDS User Guide* and [ Using SSL/TLS to encrypt a connection to a DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html) in the *Amazon Aurora User Guide*.
         */
        public var certificateDetails: aws.sdk.kotlin.services.rds.model.CertificateDetails? = null
        /**
         * If present, specifies the name of the character set that this cluster is associated with.
         */
        public var characterSetName: kotlin.String? = null
        /**
         * The ID of the clone group with which the DB cluster is associated.
         */
        public var cloneGroupId: kotlin.String? = null
        /**
         * The time when the DB cluster was created, in Universal Coordinated Time (UTC).
         */
        public var clusterCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The scalability mode of the Aurora DB cluster. When set to `limitless`, the cluster operates as an Aurora Limitless Database. When set to `standard` (the default), the cluster uses normal DB instance creation.
         */
        public var clusterScalabilityType: aws.sdk.kotlin.services.rds.model.ClusterScalabilityType? = null
        /**
         * Indicates whether tags are copied from the DB cluster to snapshots of the DB cluster.
         */
        public var copyTagsToSnapshot: kotlin.Boolean? = null
        /**
         * Indicates whether the DB cluster is a clone of a DB cluster owned by a different Amazon Web Services account.
         */
        public var crossAccountClone: kotlin.Boolean? = null
        /**
         * The custom endpoints associated with the DB cluster.
         */
        public var customEndpoints: List<String>? = null
        /**
         * The name of the initial database that was specified for the DB cluster when it was created, if one was provided. This same name is returned for the life of the DB cluster.
         */
        public var databaseName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the DB cluster.
         */
        public var dbClusterArn: kotlin.String? = null
        /**
         * The user-supplied identifier for the DB cluster. This identifier is the unique key that identifies a DB cluster.
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The name of the compute and memory capacity class of the DB instance.
         *
         * This setting is only for non-Aurora Multi-AZ DB clusters.
         */
        public var dbClusterInstanceClass: kotlin.String? = null
        /**
         * The list of DB instances that make up the DB cluster.
         */
        public var dbClusterMembers: List<DbClusterMember>? = null
        /**
         * The list of option group memberships for this DB cluster.
         */
        public var dbClusterOptionGroupMemberships: List<DbClusterOptionGroupStatus>? = null
        /**
         * The name of the DB cluster parameter group for the DB cluster.
         */
        public var dbClusterParameterGroup: kotlin.String? = null
        /**
         * The Amazon Web Services Region-unique, immutable identifier for the DB cluster. This identifier is found in Amazon Web Services CloudTrail log entries whenever the KMS key for the DB cluster is accessed.
         */
        public var dbClusterResourceId: kotlin.String? = null
        /**
         * Information about the subnet group associated with the DB cluster, including the name, description, and subnets in the subnet group.
         */
        public var dbSubnetGroup: kotlin.String? = null
        /**
         * Reserved for future use.
         */
        public var dbSystemId: kotlin.String? = null
        /**
         * Indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled.
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * The Active Directory Domain membership records associated with the DB cluster.
         */
        public var domainMemberships: List<DomainMembership>? = null
        /**
         * The earliest time to which a DB cluster can be backtracked.
         */
        public var earliestBacktrackTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The earliest time to which a database can be restored with point-in-time restore.
         */
        public var earliestRestorableTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of log types that this DB cluster is configured to export to CloudWatch Logs.
         *
         * Log types vary by DB engine. For information about the log types for each DB engine, see [Amazon RDS Database Log Files](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html) in the *Amazon Aurora User Guide.*
         */
        public var enabledCloudwatchLogsExports: List<String>? = null
        /**
         * The connection endpoint for the primary instance of the DB cluster.
         */
        public var endpoint: kotlin.String? = null
        /**
         * The database engine used for this DB cluster.
         */
        public var engine: kotlin.String? = null
        /**
         * The life cycle type for the DB cluster.
         *
         * For more information, see CreateDBCluster.
         */
        public var engineLifecycleSupport: kotlin.String? = null
        /**
         * The DB engine mode of the DB cluster, either `provisioned` or `serverless`.
         *
         * For more information, see [ CreateDBCluster](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html).
         */
        public var engineMode: kotlin.String? = null
        /**
         * The version of the database engine.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * Indicates whether write forwarding is enabled for a secondary cluster in an Aurora global database. Because write forwarding takes time to enable, check the value of `GlobalWriteForwardingStatus` to confirm that the request has completed before using the write forwarding feature for this cluster.
         */
        public var globalWriteForwardingRequested: kotlin.Boolean? = null
        /**
         * The status of write forwarding for a secondary cluster in an Aurora global database.
         */
        public var globalWriteForwardingStatus: aws.sdk.kotlin.services.rds.model.WriteForwardingStatus? = null
        /**
         * The ID that Amazon Route 53 assigns when you create a hosted zone.
         */
        public var hostedZoneId: kotlin.String? = null
        /**
         * Indicates whether the HTTP endpoint is enabled for an Aurora DB cluster.
         *
         * When enabled, the HTTP endpoint provides a connectionless web service API (RDS Data API) for running SQL queries on the DB cluster. You can also query your database from inside the RDS console with the RDS query editor.
         *
         * For more information, see [Using RDS Data API](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html) in the *Amazon Aurora User Guide*.
         */
        public var httpEndpointEnabled: kotlin.Boolean? = null
        /**
         * Indicates whether the mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.
         */
        public var iamDatabaseAuthenticationEnabled: kotlin.Boolean? = null
        /**
         * The next time you can modify the DB cluster to use the `aurora-iopt1` storage type.
         *
         * This setting is only for Aurora DB clusters.
         */
        public var ioOptimizedNextAllowedModificationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Provisioned IOPS (I/O operations per second) value.
         *
         * This setting is only for non-Aurora Multi-AZ DB clusters.
         */
        public var iops: kotlin.Int? = null
        /**
         * If `StorageEncrypted` is enabled, the Amazon Web Services KMS key identifier for the encrypted DB cluster.
         *
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The latest time to which a database can be restored with point-in-time restore.
         */
        public var latestRestorableTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The details for Aurora Limitless Database.
         */
        public var limitlessDatabase: aws.sdk.kotlin.services.rds.model.LimitlessDatabase? = null
        /**
         * Indicates whether an Aurora DB cluster has in-cluster write forwarding enabled, not enabled, requested, or is in the process of enabling it.
         */
        public var localWriteForwardingStatus: aws.sdk.kotlin.services.rds.model.LocalWriteForwardingStatus? = null
        /**
         * The secret managed by RDS in Amazon Web Services Secrets Manager for the master user password.
         *
         * For more information, see [Password management with Amazon Web Services Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide* and [Password management with Amazon Web Services Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html) in the *Amazon Aurora User Guide.*
         */
        public var masterUserSecret: aws.sdk.kotlin.services.rds.model.MasterUserSecret? = null
        /**
         * The master username for the DB cluster.
         */
        public var masterUsername: kotlin.String? = null
        /**
         * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster.
         *
         * This setting is only for non-Aurora Multi-AZ DB clusters.
         */
        public var monitoringInterval: kotlin.Int? = null
        /**
         * The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.
         *
         * This setting is only for non-Aurora Multi-AZ DB clusters.
         */
        public var monitoringRoleArn: kotlin.String? = null
        /**
         * Indicates whether the DB cluster has instances in multiple Availability Zones.
         */
        public var multiAz: kotlin.Boolean? = null
        /**
         * The network type of the DB instance.
         *
         * The network type is determined by the `DBSubnetGroup` specified for the DB cluster. A `DBSubnetGroup` can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (`DUAL`).
         *
         * For more information, see [ Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon Aurora User Guide.*
         *
         * This setting is only for Aurora DB clusters.
         *
         * Valid Values: `IPV4 | DUAL`
         */
        public var networkType: kotlin.String? = null
        /**
         * Information about pending changes to the DB cluster. This information is returned only when there are pending changes. Specific changes are identified by subelements.
         */
        public var pendingModifiedValues: aws.sdk.kotlin.services.rds.model.ClusterPendingModifiedValues? = null
        /**
         * The progress of the operation as a percentage.
         */
        public var percentProgress: kotlin.String? = null
        /**
         * Indicates whether Performance Insights is enabled for the DB cluster.
         *
         * This setting is only for non-Aurora Multi-AZ DB clusters.
         */
        public var performanceInsightsEnabled: kotlin.Boolean? = null
        /**
         * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
         *
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         *
         * This setting is only for non-Aurora Multi-AZ DB clusters.
         */
        public var performanceInsightsKmsKeyId: kotlin.String? = null
        /**
         * The number of days to retain Performance Insights data.
         *
         * This setting is only for non-Aurora Multi-AZ DB clusters.
         *
         * Valid Values:
         * + `7`
         * + *month* * 31, where *month* is a number of months from 1-23. Examples: `93` (3 months * 31), `341` (11 months * 31), `589` (19 months * 31)
         * + `731`
         *
         * Default: `7` days
         */
        public var performanceInsightsRetentionPeriod: kotlin.Int? = null
        /**
         * The port that the database engine is listening on.
         */
        public var port: kotlin.Int? = null
        /**
         * The daily time range during which automated backups are created if automated backups are enabled, as determined by the `BackupRetentionPeriod`.
         */
        public var preferredBackupWindow: kotlin.String? = null
        /**
         * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * Indicates whether the DB cluster is publicly accessible.
         *
         * When the DB cluster is publicly accessible and you connect from outside of the DB cluster's virtual private cloud (VPC), its Domain Name System (DNS) endpoint resolves to the public IP address. When you connect from within the same VPC as the DB cluster, the endpoint resolves to the private IP address. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.
         *
         * When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.
         *
         * For more information, see CreateDBCluster.
         *
         * This setting is only for non-Aurora Multi-AZ DB clusters.
         */
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * Reserved for future use.
         */
        public var rdsCustomClusterConfiguration: aws.sdk.kotlin.services.rds.model.RdsCustomClusterConfiguration? = null
        /**
         * Contains one or more identifiers of the read replicas associated with this DB cluster.
         */
        public var readReplicaIdentifiers: List<String>? = null
        /**
         * The reader endpoint for the DB cluster. The reader endpoint for a DB cluster load-balances connections across the Aurora Replicas that are available in a DB cluster. As clients request new connections to the reader endpoint, Aurora distributes the connection requests among the Aurora Replicas in the DB cluster. This functionality can help balance your read workload across multiple Aurora Replicas in your DB cluster.
         *
         * If a failover occurs, and the Aurora Replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Aurora Replicas in the cluster, you can then reconnect to the reader endpoint.
         */
        public var readerEndpoint: kotlin.String? = null
        /**
         * The identifier of the source DB cluster if this DB cluster is a read replica.
         */
        public var replicationSourceIdentifier: kotlin.String? = null
        /**
         * The scaling configuration for an Aurora DB cluster in `serverless` DB engine mode.
         *
         * For more information, see [Using Amazon Aurora Serverless v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html) in the *Amazon Aurora User Guide*.
         */
        public var scalingConfigurationInfo: aws.sdk.kotlin.services.rds.model.ScalingConfigurationInfo? = null
        /**
         * The scaling configuration for an Aurora Serverless v2 DB cluster.
         *
         * For more information, see [Using Amazon Aurora Serverless v2](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html) in the *Amazon Aurora User Guide*.
         */
        public var serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfigurationInfo? = null
        /**
         * The current state of this DB cluster.
         */
        public var status: kotlin.String? = null
        /**
         * Reserved for future use.
         */
        public var statusInfos: List<DbClusterStatusInfo>? = null
        /**
         * Indicates whether the DB cluster is encrypted.
         */
        public var storageEncrypted: kotlin.Boolean? = null
        /**
         * The storage throughput for the DB cluster. The throughput is automatically set based on the IOPS that you provision, and is not configurable.
         *
         * This setting is only for non-Aurora Multi-AZ DB clusters.
         */
        public var storageThroughput: kotlin.Int? = null
        /**
         * The storage type associated with the DB cluster.
         */
        public var storageType: kotlin.String? = null
        /**
         * A list of tags.
         *
         * For more information, see [Tagging Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html) in the *Amazon Aurora User Guide*.
         */
        public var tagList: List<Tag>? = null
        /**
         * The list of VPC security groups that the DB cluster belongs to.
         */
        public var vpcSecurityGroups: List<VpcSecurityGroupMembership>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DbCluster) : this() {
            this.activityStreamKinesisStreamName = x.activityStreamKinesisStreamName
            this.activityStreamKmsKeyId = x.activityStreamKmsKeyId
            this.activityStreamMode = x.activityStreamMode
            this.activityStreamStatus = x.activityStreamStatus
            this.allocatedStorage = x.allocatedStorage
            this.associatedRoles = x.associatedRoles
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.automaticRestartTime = x.automaticRestartTime
            this.availabilityZones = x.availabilityZones
            this.awsBackupRecoveryPointArn = x.awsBackupRecoveryPointArn
            this.backtrackConsumedChangeRecords = x.backtrackConsumedChangeRecords
            this.backtrackWindow = x.backtrackWindow
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.capacity = x.capacity
            this.certificateDetails = x.certificateDetails
            this.characterSetName = x.characterSetName
            this.cloneGroupId = x.cloneGroupId
            this.clusterCreateTime = x.clusterCreateTime
            this.clusterScalabilityType = x.clusterScalabilityType
            this.copyTagsToSnapshot = x.copyTagsToSnapshot
            this.crossAccountClone = x.crossAccountClone
            this.customEndpoints = x.customEndpoints
            this.databaseName = x.databaseName
            this.dbClusterArn = x.dbClusterArn
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterInstanceClass = x.dbClusterInstanceClass
            this.dbClusterMembers = x.dbClusterMembers
            this.dbClusterOptionGroupMemberships = x.dbClusterOptionGroupMemberships
            this.dbClusterParameterGroup = x.dbClusterParameterGroup
            this.dbClusterResourceId = x.dbClusterResourceId
            this.dbSubnetGroup = x.dbSubnetGroup
            this.dbSystemId = x.dbSystemId
            this.deletionProtection = x.deletionProtection
            this.domainMemberships = x.domainMemberships
            this.earliestBacktrackTime = x.earliestBacktrackTime
            this.earliestRestorableTime = x.earliestRestorableTime
            this.enabledCloudwatchLogsExports = x.enabledCloudwatchLogsExports
            this.endpoint = x.endpoint
            this.engine = x.engine
            this.engineLifecycleSupport = x.engineLifecycleSupport
            this.engineMode = x.engineMode
            this.engineVersion = x.engineVersion
            this.globalWriteForwardingRequested = x.globalWriteForwardingRequested
            this.globalWriteForwardingStatus = x.globalWriteForwardingStatus
            this.hostedZoneId = x.hostedZoneId
            this.httpEndpointEnabled = x.httpEndpointEnabled
            this.iamDatabaseAuthenticationEnabled = x.iamDatabaseAuthenticationEnabled
            this.ioOptimizedNextAllowedModificationTime = x.ioOptimizedNextAllowedModificationTime
            this.iops = x.iops
            this.kmsKeyId = x.kmsKeyId
            this.latestRestorableTime = x.latestRestorableTime
            this.limitlessDatabase = x.limitlessDatabase
            this.localWriteForwardingStatus = x.localWriteForwardingStatus
            this.masterUserSecret = x.masterUserSecret
            this.masterUsername = x.masterUsername
            this.monitoringInterval = x.monitoringInterval
            this.monitoringRoleArn = x.monitoringRoleArn
            this.multiAz = x.multiAz
            this.networkType = x.networkType
            this.pendingModifiedValues = x.pendingModifiedValues
            this.percentProgress = x.percentProgress
            this.performanceInsightsEnabled = x.performanceInsightsEnabled
            this.performanceInsightsKmsKeyId = x.performanceInsightsKmsKeyId
            this.performanceInsightsRetentionPeriod = x.performanceInsightsRetentionPeriod
            this.port = x.port
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.publiclyAccessible = x.publiclyAccessible
            this.rdsCustomClusterConfiguration = x.rdsCustomClusterConfiguration
            this.readReplicaIdentifiers = x.readReplicaIdentifiers
            this.readerEndpoint = x.readerEndpoint
            this.replicationSourceIdentifier = x.replicationSourceIdentifier
            this.scalingConfigurationInfo = x.scalingConfigurationInfo
            this.serverlessV2ScalingConfiguration = x.serverlessV2ScalingConfiguration
            this.status = x.status
            this.statusInfos = x.statusInfos
            this.storageEncrypted = x.storageEncrypted
            this.storageThroughput = x.storageThroughput
            this.storageType = x.storageType
            this.tagList = x.tagList
            this.vpcSecurityGroups = x.vpcSecurityGroups
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DbCluster = DbCluster(this)

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.CertificateDetails] inside the given [block]
         */
        public fun certificateDetails(block: aws.sdk.kotlin.services.rds.model.CertificateDetails.Builder.() -> kotlin.Unit) {
            this.certificateDetails = aws.sdk.kotlin.services.rds.model.CertificateDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.LimitlessDatabase] inside the given [block]
         */
        public fun limitlessDatabase(block: aws.sdk.kotlin.services.rds.model.LimitlessDatabase.Builder.() -> kotlin.Unit) {
            this.limitlessDatabase = aws.sdk.kotlin.services.rds.model.LimitlessDatabase.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.MasterUserSecret] inside the given [block]
         */
        public fun masterUserSecret(block: aws.sdk.kotlin.services.rds.model.MasterUserSecret.Builder.() -> kotlin.Unit) {
            this.masterUserSecret = aws.sdk.kotlin.services.rds.model.MasterUserSecret.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.ClusterPendingModifiedValues] inside the given [block]
         */
        public fun pendingModifiedValues(block: aws.sdk.kotlin.services.rds.model.ClusterPendingModifiedValues.Builder.() -> kotlin.Unit) {
            this.pendingModifiedValues = aws.sdk.kotlin.services.rds.model.ClusterPendingModifiedValues.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.RdsCustomClusterConfiguration] inside the given [block]
         */
        public fun rdsCustomClusterConfiguration(block: aws.sdk.kotlin.services.rds.model.RdsCustomClusterConfiguration.Builder.() -> kotlin.Unit) {
            this.rdsCustomClusterConfiguration = aws.sdk.kotlin.services.rds.model.RdsCustomClusterConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.ScalingConfigurationInfo] inside the given [block]
         */
        public fun scalingConfigurationInfo(block: aws.sdk.kotlin.services.rds.model.ScalingConfigurationInfo.Builder.() -> kotlin.Unit) {
            this.scalingConfigurationInfo = aws.sdk.kotlin.services.rds.model.ScalingConfigurationInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfigurationInfo] inside the given [block]
         */
        public fun serverlessV2ScalingConfiguration(block: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfigurationInfo.Builder.() -> kotlin.Unit) {
            this.serverlessV2ScalingConfiguration = aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfigurationInfo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
