// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateTenantDatabaseRequest private constructor(builder: Builder) {
    /**
     * The character set for your tenant database. If you don't specify a value, the character set name defaults to `AL32UTF8`.
     */
    public val characterSetName: kotlin.String? = builder.characterSetName
    /**
     * The user-supplied DB instance identifier. RDS creates your tenant database in this DB instance. This parameter isn't case-sensitive.
     */
    public val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * The password for the master user in your tenant database.
     *
     * Constraints:
     * + Must be 8 to 30 characters.
     * + Can include any printable ASCII character except forward slash (`/`), double quote (`"`), at symbol (`@`), ampersand (`&`), or single quote (`'`).
     */
    public val masterUserPassword: kotlin.String? = builder.masterUserPassword
    /**
     * The name for the master user account in your tenant database. RDS creates this user account in the tenant database and grants privileges to the master user. This parameter is case-sensitive.
     *
     * Constraints:
     * + Must be 1 to 16 letters, numbers, or underscores.
     * + First character must be a letter.
     * + Can't be a reserved word for the chosen database engine.
     */
    public val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * The `NCHAR` value for the tenant database.
     */
    public val ncharCharacterSetName: kotlin.String? = builder.ncharCharacterSetName
    /**
     * A list of tags.
     *
     * For more information, see [Tagging Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html) in the *Amazon Aurora User Guide*.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The user-supplied name of the tenant database that you want to create in your DB instance. This parameter has the same constraints as `DBName` in `CreateDBInstance`.
     */
    public val tenantDbName: kotlin.String? = builder.tenantDbName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.CreateTenantDatabaseRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTenantDatabaseRequest(")
        append("characterSetName=$characterSetName,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("masterUserPassword=*** Sensitive Data Redacted ***,")
        append("masterUsername=$masterUsername,")
        append("ncharCharacterSetName=$ncharCharacterSetName,")
        append("tags=$tags,")
        append("tenantDbName=$tenantDbName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = characterSetName?.hashCode() ?: 0
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (masterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (ncharCharacterSetName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tenantDbName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTenantDatabaseRequest

        if (characterSetName != other.characterSetName) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (masterUserPassword != other.masterUserPassword) return false
        if (masterUsername != other.masterUsername) return false
        if (ncharCharacterSetName != other.ncharCharacterSetName) return false
        if (tags != other.tags) return false
        if (tenantDbName != other.tenantDbName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.CreateTenantDatabaseRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The character set for your tenant database. If you don't specify a value, the character set name defaults to `AL32UTF8`.
         */
        public var characterSetName: kotlin.String? = null
        /**
         * The user-supplied DB instance identifier. RDS creates your tenant database in this DB instance. This parameter isn't case-sensitive.
         */
        public var dbInstanceIdentifier: kotlin.String? = null
        /**
         * The password for the master user in your tenant database.
         *
         * Constraints:
         * + Must be 8 to 30 characters.
         * + Can include any printable ASCII character except forward slash (`/`), double quote (`"`), at symbol (`@`), ampersand (`&`), or single quote (`'`).
         */
        public var masterUserPassword: kotlin.String? = null
        /**
         * The name for the master user account in your tenant database. RDS creates this user account in the tenant database and grants privileges to the master user. This parameter is case-sensitive.
         *
         * Constraints:
         * + Must be 1 to 16 letters, numbers, or underscores.
         * + First character must be a letter.
         * + Can't be a reserved word for the chosen database engine.
         */
        public var masterUsername: kotlin.String? = null
        /**
         * The `NCHAR` value for the tenant database.
         */
        public var ncharCharacterSetName: kotlin.String? = null
        /**
         * A list of tags.
         *
         * For more information, see [Tagging Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html) in the *Amazon Aurora User Guide*.
         */
        public var tags: List<Tag>? = null
        /**
         * The user-supplied name of the tenant database that you want to create in your DB instance. This parameter has the same constraints as `DBName` in `CreateDBInstance`.
         */
        public var tenantDbName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.CreateTenantDatabaseRequest) : this() {
            this.characterSetName = x.characterSetName
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.masterUserPassword = x.masterUserPassword
            this.masterUsername = x.masterUsername
            this.ncharCharacterSetName = x.ncharCharacterSetName
            this.tags = x.tags
            this.tenantDbName = x.tenantDbName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.CreateTenantDatabaseRequest = CreateTenantDatabaseRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
