// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateIntegrationRequest private constructor(builder: Builder) {
    /**
     * An optional set of non-secret key–value pairs that contains additional contextual information about the data. For more information, see [Encryption context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context) in the *Amazon Web Services Key Management Service Developer Guide*.
     *
     * You can only include this parameter if you specify the `KMSKeyId` parameter.
     */
    public val additionalEncryptionContext: Map<String, String>? = builder.additionalEncryptionContext
    /**
     * Data filtering options for the integration. For more information, see [Data filtering for Aurora zero-ETL integrations with Amazon Redshift](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/zero-etl.filtering.html).
     *
     * Valid for: Integrations with Aurora MySQL source DB clusters only
     */
    public val dataFilter: kotlin.String? = builder.dataFilter
    /**
     * A description of the integration.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the integration.
     */
    public val integrationName: kotlin.String? = builder.integrationName
    /**
     * The Amazon Web Services Key Management System (Amazon Web Services KMS) key identifier for the key to use to encrypt the integration. If you don't specify an encryption key, RDS uses a default Amazon Web Services owned key.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The Amazon Resource Name (ARN) of the database to use as the source for replication.
     */
    public val sourceArn: kotlin.String? = builder.sourceArn
    /**
     * A list of tags.
     *
     * For more information, see [Tagging Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html) in the *Amazon Aurora User Guide*.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The ARN of the Redshift data warehouse to use as the target for replication.
     */
    public val targetArn: kotlin.String? = builder.targetArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.CreateIntegrationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateIntegrationRequest(")
        append("additionalEncryptionContext=$additionalEncryptionContext,")
        append("dataFilter=$dataFilter,")
        append("description=$description,")
        append("integrationName=$integrationName,")
        append("kmsKeyId=$kmsKeyId,")
        append("sourceArn=$sourceArn,")
        append("tags=$tags,")
        append("targetArn=$targetArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalEncryptionContext?.hashCode() ?: 0
        result = 31 * result + (dataFilter?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (integrationName?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (sourceArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateIntegrationRequest

        if (additionalEncryptionContext != other.additionalEncryptionContext) return false
        if (dataFilter != other.dataFilter) return false
        if (description != other.description) return false
        if (integrationName != other.integrationName) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (sourceArn != other.sourceArn) return false
        if (tags != other.tags) return false
        if (targetArn != other.targetArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.CreateIntegrationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An optional set of non-secret key–value pairs that contains additional contextual information about the data. For more information, see [Encryption context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context) in the *Amazon Web Services Key Management Service Developer Guide*.
         *
         * You can only include this parameter if you specify the `KMSKeyId` parameter.
         */
        public var additionalEncryptionContext: Map<String, String>? = null
        /**
         * Data filtering options for the integration. For more information, see [Data filtering for Aurora zero-ETL integrations with Amazon Redshift](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/zero-etl.filtering.html).
         *
         * Valid for: Integrations with Aurora MySQL source DB clusters only
         */
        public var dataFilter: kotlin.String? = null
        /**
         * A description of the integration.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the integration.
         */
        public var integrationName: kotlin.String? = null
        /**
         * The Amazon Web Services Key Management System (Amazon Web Services KMS) key identifier for the key to use to encrypt the integration. If you don't specify an encryption key, RDS uses a default Amazon Web Services owned key.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the database to use as the source for replication.
         */
        public var sourceArn: kotlin.String? = null
        /**
         * A list of tags.
         *
         * For more information, see [Tagging Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html) in the *Amazon Aurora User Guide*.
         */
        public var tags: List<Tag>? = null
        /**
         * The ARN of the Redshift data warehouse to use as the target for replication.
         */
        public var targetArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.CreateIntegrationRequest) : this() {
            this.additionalEncryptionContext = x.additionalEncryptionContext
            this.dataFilter = x.dataFilter
            this.description = x.description
            this.integrationName = x.integrationName
            this.kmsKeyId = x.kmsKeyId
            this.sourceArn = x.sourceArn
            this.tags = x.tags
            this.targetArn = x.targetArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.CreateIntegrationRequest = CreateIntegrationRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
