// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateGlobalClusterRequest private constructor(builder: Builder) {
    /**
     * The name for your database of up to 64 alphanumeric characters. If you don't specify a name, Amazon Aurora doesn't create a database in the global database cluster.
     *
     * Constraints:
     * + Can't be specified if `SourceDBClusterIdentifier` is specified. In this case, Amazon Aurora uses the database name from the source DB cluster.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * Specifies whether to enable deletion protection for the new global database cluster. The global database can't be deleted when deletion protection is enabled.
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The database engine to use for this global database cluster.
     *
     * Valid Values: `aurora-mysql | aurora-postgresql`
     *
     * Constraints:
     * + Can't be specified if `SourceDBClusterIdentifier` is specified. In this case, Amazon Aurora uses the engine of the source DB cluster.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The life cycle type for this global database cluster.
     *
     * By default, this value is set to `open-source-rds-extended-support`, which enrolls your global cluster into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to `open-source-rds-extended-support-disabled`. In this case, creating the global cluster will fail if the DB major version is past its end of standard support date.
     *
     * This setting only applies to Aurora PostgreSQL-based global databases.
     *
     * You can use this setting to enroll your global cluster into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your global cluster past the end of standard support for that engine version. For more information, see [Using Amazon RDS Extended Support](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html) in the *Amazon Aurora User Guide*.
     *
     * Valid Values: `open-source-rds-extended-support | open-source-rds-extended-support-disabled`
     *
     * Default: `open-source-rds-extended-support`
     */
    public val engineLifecycleSupport: kotlin.String? = builder.engineLifecycleSupport
    /**
     * The engine version to use for this global database cluster.
     *
     * Constraints:
     * + Can't be specified if `SourceDBClusterIdentifier` is specified. In this case, Amazon Aurora uses the engine version of the source DB cluster.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The cluster identifier for this global database cluster. This parameter is stored as a lowercase string.
     */
    public val globalClusterIdentifier: kotlin.String? = builder.globalClusterIdentifier
    /**
     * The Amazon Resource Name (ARN) to use as the primary cluster of the global database.
     *
     * If you provide a value for this parameter, don't specify values for the following settings because Amazon Aurora uses the values from the specified source DB cluster:
     * + `DatabaseName`
     * + `Engine`
     * + `EngineVersion`
     * + `StorageEncrypted`
     */
    public val sourceDbClusterIdentifier: kotlin.String? = builder.sourceDbClusterIdentifier
    /**
     * Specifies whether to enable storage encryption for the new global database cluster.
     *
     * Constraints:
     * + Can't be specified if `SourceDBClusterIdentifier` is specified. In this case, Amazon Aurora uses the setting from the source DB cluster.
     */
    public val storageEncrypted: kotlin.Boolean? = builder.storageEncrypted
    /**
     * Tags to assign to the global cluster.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.CreateGlobalClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateGlobalClusterRequest(")
        append("databaseName=$databaseName,")
        append("deletionProtection=$deletionProtection,")
        append("engine=$engine,")
        append("engineLifecycleSupport=$engineLifecycleSupport,")
        append("engineVersion=$engineVersion,")
        append("globalClusterIdentifier=$globalClusterIdentifier,")
        append("sourceDbClusterIdentifier=$sourceDbClusterIdentifier,")
        append("storageEncrypted=$storageEncrypted,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = databaseName?.hashCode() ?: 0
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineLifecycleSupport?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (globalClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (sourceDbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateGlobalClusterRequest

        if (databaseName != other.databaseName) return false
        if (deletionProtection != other.deletionProtection) return false
        if (engine != other.engine) return false
        if (engineLifecycleSupport != other.engineLifecycleSupport) return false
        if (engineVersion != other.engineVersion) return false
        if (globalClusterIdentifier != other.globalClusterIdentifier) return false
        if (sourceDbClusterIdentifier != other.sourceDbClusterIdentifier) return false
        if (storageEncrypted != other.storageEncrypted) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.CreateGlobalClusterRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name for your database of up to 64 alphanumeric characters. If you don't specify a name, Amazon Aurora doesn't create a database in the global database cluster.
         *
         * Constraints:
         * + Can't be specified if `SourceDBClusterIdentifier` is specified. In this case, Amazon Aurora uses the database name from the source DB cluster.
         */
        public var databaseName: kotlin.String? = null
        /**
         * Specifies whether to enable deletion protection for the new global database cluster. The global database can't be deleted when deletion protection is enabled.
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * The database engine to use for this global database cluster.
         *
         * Valid Values: `aurora-mysql | aurora-postgresql`
         *
         * Constraints:
         * + Can't be specified if `SourceDBClusterIdentifier` is specified. In this case, Amazon Aurora uses the engine of the source DB cluster.
         */
        public var engine: kotlin.String? = null
        /**
         * The life cycle type for this global database cluster.
         *
         * By default, this value is set to `open-source-rds-extended-support`, which enrolls your global cluster into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to `open-source-rds-extended-support-disabled`. In this case, creating the global cluster will fail if the DB major version is past its end of standard support date.
         *
         * This setting only applies to Aurora PostgreSQL-based global databases.
         *
         * You can use this setting to enroll your global cluster into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your global cluster past the end of standard support for that engine version. For more information, see [Using Amazon RDS Extended Support](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/extended-support.html) in the *Amazon Aurora User Guide*.
         *
         * Valid Values: `open-source-rds-extended-support | open-source-rds-extended-support-disabled`
         *
         * Default: `open-source-rds-extended-support`
         */
        public var engineLifecycleSupport: kotlin.String? = null
        /**
         * The engine version to use for this global database cluster.
         *
         * Constraints:
         * + Can't be specified if `SourceDBClusterIdentifier` is specified. In this case, Amazon Aurora uses the engine version of the source DB cluster.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The cluster identifier for this global database cluster. This parameter is stored as a lowercase string.
         */
        public var globalClusterIdentifier: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) to use as the primary cluster of the global database.
         *
         * If you provide a value for this parameter, don't specify values for the following settings because Amazon Aurora uses the values from the specified source DB cluster:
         * + `DatabaseName`
         * + `Engine`
         * + `EngineVersion`
         * + `StorageEncrypted`
         */
        public var sourceDbClusterIdentifier: kotlin.String? = null
        /**
         * Specifies whether to enable storage encryption for the new global database cluster.
         *
         * Constraints:
         * + Can't be specified if `SourceDBClusterIdentifier` is specified. In this case, Amazon Aurora uses the setting from the source DB cluster.
         */
        public var storageEncrypted: kotlin.Boolean? = null
        /**
         * Tags to assign to the global cluster.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.CreateGlobalClusterRequest) : this() {
            this.databaseName = x.databaseName
            this.deletionProtection = x.deletionProtection
            this.engine = x.engine
            this.engineLifecycleSupport = x.engineLifecycleSupport
            this.engineVersion = x.engineVersion
            this.globalClusterIdentifier = x.globalClusterIdentifier
            this.sourceDbClusterIdentifier = x.sourceDbClusterIdentifier
            this.storageEncrypted = x.storageEncrypted
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.CreateGlobalClusterRequest = CreateGlobalClusterRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
