// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateDbProxyRequest private constructor(builder: Builder) {
    /**
     * The authorization mechanism that the proxy uses.
     */
    public val auth: List<UserAuthConfig>? = builder.auth
    /**
     * The identifier for the proxy. This name must be unique for all proxies owned by your Amazon Web Services account in the specified Amazon Web Services Region. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
     */
    public val dbProxyName: kotlin.String? = builder.dbProxyName
    /**
     * Specifies whether the proxy includes detailed information about SQL statements in its logs. This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs.
     */
    public val debugLogging: kotlin.Boolean? = builder.debugLogging
    /**
     * The kinds of databases that the proxy can connect to. This value determines which database network protocol the proxy recognizes when it interprets network traffic to and from the database. For Aurora MySQL, RDS for MariaDB, and RDS for MySQL databases, specify `MYSQL`. For Aurora PostgreSQL and RDS for PostgreSQL databases, specify `POSTGRESQL`. For RDS for Microsoft SQL Server, specify `SQLSERVER`.
     */
    public val engineFamily: aws.sdk.kotlin.services.rds.model.EngineFamily? = builder.engineFamily
    /**
     * The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You can set this value higher or lower than the connection timeout limit for the associated database.
     */
    public val idleClientTimeout: kotlin.Int? = builder.idleClientTimeout
    /**
     * Specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy. By enabling this setting, you can enforce encrypted TLS connections to the proxy.
     */
    public val requireTls: kotlin.Boolean? = builder.requireTls
    /**
     * The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in Amazon Web Services Secrets Manager.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * An optional set of key-value pairs to associate arbitrary data of your choosing with the proxy.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * One or more VPC security group IDs to associate with the new proxy.
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds
    /**
     * One or more VPC subnet IDs to associate with the new proxy.
     */
    public val vpcSubnetIds: List<String>? = builder.vpcSubnetIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.CreateDbProxyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDbProxyRequest(")
        append("auth=$auth,")
        append("dbProxyName=$dbProxyName,")
        append("debugLogging=$debugLogging,")
        append("engineFamily=$engineFamily,")
        append("idleClientTimeout=$idleClientTimeout,")
        append("requireTls=$requireTls,")
        append("roleArn=$roleArn,")
        append("tags=$tags,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds,")
        append("vpcSubnetIds=$vpcSubnetIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = auth?.hashCode() ?: 0
        result = 31 * result + (dbProxyName?.hashCode() ?: 0)
        result = 31 * result + (debugLogging?.hashCode() ?: 0)
        result = 31 * result + (engineFamily?.hashCode() ?: 0)
        result = 31 * result + (idleClientTimeout ?: 0)
        result = 31 * result + (requireTls?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (vpcSubnetIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDbProxyRequest

        if (auth != other.auth) return false
        if (dbProxyName != other.dbProxyName) return false
        if (debugLogging != other.debugLogging) return false
        if (engineFamily != other.engineFamily) return false
        if (idleClientTimeout != other.idleClientTimeout) return false
        if (requireTls != other.requireTls) return false
        if (roleArn != other.roleArn) return false
        if (tags != other.tags) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false
        if (vpcSubnetIds != other.vpcSubnetIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.CreateDbProxyRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The authorization mechanism that the proxy uses.
         */
        public var auth: List<UserAuthConfig>? = null
        /**
         * The identifier for the proxy. This name must be unique for all proxies owned by your Amazon Web Services account in the specified Amazon Web Services Region. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
         */
        public var dbProxyName: kotlin.String? = null
        /**
         * Specifies whether the proxy includes detailed information about SQL statements in its logs. This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs.
         */
        public var debugLogging: kotlin.Boolean? = null
        /**
         * The kinds of databases that the proxy can connect to. This value determines which database network protocol the proxy recognizes when it interprets network traffic to and from the database. For Aurora MySQL, RDS for MariaDB, and RDS for MySQL databases, specify `MYSQL`. For Aurora PostgreSQL and RDS for PostgreSQL databases, specify `POSTGRESQL`. For RDS for Microsoft SQL Server, specify `SQLSERVER`.
         */
        public var engineFamily: aws.sdk.kotlin.services.rds.model.EngineFamily? = null
        /**
         * The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You can set this value higher or lower than the connection timeout limit for the associated database.
         */
        public var idleClientTimeout: kotlin.Int? = null
        /**
         * Specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy. By enabling this setting, you can enforce encrypted TLS connections to the proxy.
         */
        public var requireTls: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in Amazon Web Services Secrets Manager.
         */
        public var roleArn: kotlin.String? = null
        /**
         * An optional set of key-value pairs to associate arbitrary data of your choosing with the proxy.
         */
        public var tags: List<Tag>? = null
        /**
         * One or more VPC security group IDs to associate with the new proxy.
         */
        public var vpcSecurityGroupIds: List<String>? = null
        /**
         * One or more VPC subnet IDs to associate with the new proxy.
         */
        public var vpcSubnetIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.CreateDbProxyRequest) : this() {
            this.auth = x.auth
            this.dbProxyName = x.dbProxyName
            this.debugLogging = x.debugLogging
            this.engineFamily = x.engineFamily
            this.idleClientTimeout = x.idleClientTimeout
            this.requireTls = x.requireTls
            this.roleArn = x.roleArn
            this.tags = x.tags
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
            this.vpcSubnetIds = x.vpcSubnetIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.CreateDbProxyRequest = CreateDbProxyRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
