// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 *
 */
public class CopyDbClusterSnapshotRequest private constructor(builder: Builder) {
    /**
     * Specifies whether to copy all tags from the source DB cluster snapshot to the target DB cluster snapshot. By default, tags are not copied.
     */
    public val copyTags: kotlin.Boolean? = builder.copyTags
    /**
     * The Amazon Web Services KMS key identifier for an encrypted DB cluster snapshot. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS key.
     *
     * If you copy an encrypted DB cluster snapshot from your Amazon Web Services account, you can specify a value for `KmsKeyId` to encrypt the copy with a new KMS key. If you don't specify a value for `KmsKeyId`, then the copy of the DB cluster snapshot is encrypted with the same KMS key as the source DB cluster snapshot.
     *
     * If you copy an encrypted DB cluster snapshot that is shared from another Amazon Web Services account, then you must specify a value for `KmsKeyId`.
     *
     * To copy an encrypted DB cluster snapshot to another Amazon Web Services Region, you must set `KmsKeyId` to the Amazon Web Services KMS key identifier you want to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region. KMS keys are specific to the Amazon Web Services Region that they are created in, and you can't use KMS keys from one Amazon Web Services Region in another Amazon Web Services Region.
     *
     * If you copy an unencrypted DB cluster snapshot and specify a value for the `KmsKeyId` parameter, an error is returned.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * When you are copying a DB cluster snapshot from one Amazon Web Services GovCloud (US) Region to another, the URL that contains a Signature Version 4 signed request for the `CopyDBClusterSnapshot` API operation in the Amazon Web Services Region that contains the source DB cluster snapshot to copy. Use the `PreSignedUrl` parameter when copying an encrypted DB cluster snapshot from another Amazon Web Services Region. Don't specify `PreSignedUrl` when copying an encrypted DB cluster snapshot in the same Amazon Web Services Region.
     *
     * This setting applies only to Amazon Web Services GovCloud (US) Regions. It's ignored in other Amazon Web Services Regions.
     *
     * The presigned URL must be a valid request for the `CopyDBClusterSnapshot` API operation that can run in the source Amazon Web Services Region that contains the encrypted DB cluster snapshot to copy. The presigned URL request must contain the following parameter values:
     * + `KmsKeyId` - The KMS key identifier for the KMS key to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region. This is the same identifier for both the `CopyDBClusterSnapshot` operation that is called in the destination Amazon Web Services Region, and the operation contained in the presigned URL.
     * + `DestinationRegion` - The name of the Amazon Web Services Region that the DB cluster snapshot is to be created in.
     * + `SourceDBClusterSnapshotIdentifier` - The DB cluster snapshot identifier for the encrypted DB cluster snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted DB cluster snapshot from the us-west-2 Amazon Web Services Region, then your `SourceDBClusterSnapshotIdentifier` looks like the following example: `arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115`.
     *
     * To learn how to generate a Signature Version 4 signed request, see [ Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)](https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html) and [ Signature Version 4 Signing Process](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
     *
     * If you are using an Amazon Web Services SDK tool or the CLI, you can specify `SourceRegion` (or `--source-region` for the CLI) instead of specifying `PreSignedUrl` manually. Specifying `SourceRegion` autogenerates a presigned URL that is a valid request for the operation that can run in the source Amazon Web Services Region.
     */
    public val preSignedUrl: kotlin.String? = builder.preSignedUrl
    /**
     * The identifier of the DB cluster snapshot to copy. This parameter isn't case-sensitive.
     *
     * You can't copy an encrypted, shared DB cluster snapshot from one Amazon Web Services Region to another.
     *
     * Constraints:
     * + Must specify a valid system snapshot in the "available" state.
     * + If the source snapshot is in the same Amazon Web Services Region as the copy, specify a valid DB snapshot identifier.
     * + If the source snapshot is in a different Amazon Web Services Region than the copy, specify a valid DB cluster snapshot ARN. For more information, go to [ Copying Snapshots Across Amazon Web Services Regions](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html#USER_CopySnapshot.AcrossRegions) in the *Amazon Aurora User Guide*.
     *
     * Example: `my-cluster-snapshot1`
     */
    public val sourceDbClusterSnapshotIdentifier: kotlin.String? = builder.sourceDbClusterSnapshotIdentifier
    /**
     * A list of tags.
     *
     * For more information, see [Tagging Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html) in the *Amazon Aurora User Guide*.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The identifier of the new DB cluster snapshot to create from the source DB cluster snapshot. This parameter isn't case-sensitive.
     *
     * Constraints:
     * + Must contain from 1 to 63 letters, numbers, or hyphens.
     * + First character must be a letter.
     * + Can't end with a hyphen or contain two consecutive hyphens.
     *
     * Example: `my-cluster-snapshot2`
     */
    public val targetDbClusterSnapshotIdentifier: kotlin.String? = builder.targetDbClusterSnapshotIdentifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.CopyDbClusterSnapshotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CopyDbClusterSnapshotRequest(")
        append("copyTags=$copyTags,")
        append("kmsKeyId=$kmsKeyId,")
        append("preSignedUrl=$preSignedUrl,")
        append("sourceDbClusterSnapshotIdentifier=$sourceDbClusterSnapshotIdentifier,")
        append("tags=$tags,")
        append("targetDbClusterSnapshotIdentifier=$targetDbClusterSnapshotIdentifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = copyTags?.hashCode() ?: 0
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (preSignedUrl?.hashCode() ?: 0)
        result = 31 * result + (sourceDbClusterSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetDbClusterSnapshotIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CopyDbClusterSnapshotRequest

        if (copyTags != other.copyTags) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (preSignedUrl != other.preSignedUrl) return false
        if (sourceDbClusterSnapshotIdentifier != other.sourceDbClusterSnapshotIdentifier) return false
        if (tags != other.tags) return false
        if (targetDbClusterSnapshotIdentifier != other.targetDbClusterSnapshotIdentifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.CopyDbClusterSnapshotRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether to copy all tags from the source DB cluster snapshot to the target DB cluster snapshot. By default, tags are not copied.
         */
        public var copyTags: kotlin.Boolean? = null
        /**
         * The Amazon Web Services KMS key identifier for an encrypted DB cluster snapshot. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS key.
         *
         * If you copy an encrypted DB cluster snapshot from your Amazon Web Services account, you can specify a value for `KmsKeyId` to encrypt the copy with a new KMS key. If you don't specify a value for `KmsKeyId`, then the copy of the DB cluster snapshot is encrypted with the same KMS key as the source DB cluster snapshot.
         *
         * If you copy an encrypted DB cluster snapshot that is shared from another Amazon Web Services account, then you must specify a value for `KmsKeyId`.
         *
         * To copy an encrypted DB cluster snapshot to another Amazon Web Services Region, you must set `KmsKeyId` to the Amazon Web Services KMS key identifier you want to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region. KMS keys are specific to the Amazon Web Services Region that they are created in, and you can't use KMS keys from one Amazon Web Services Region in another Amazon Web Services Region.
         *
         * If you copy an unencrypted DB cluster snapshot and specify a value for the `KmsKeyId` parameter, an error is returned.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * When you are copying a DB cluster snapshot from one Amazon Web Services GovCloud (US) Region to another, the URL that contains a Signature Version 4 signed request for the `CopyDBClusterSnapshot` API operation in the Amazon Web Services Region that contains the source DB cluster snapshot to copy. Use the `PreSignedUrl` parameter when copying an encrypted DB cluster snapshot from another Amazon Web Services Region. Don't specify `PreSignedUrl` when copying an encrypted DB cluster snapshot in the same Amazon Web Services Region.
         *
         * This setting applies only to Amazon Web Services GovCloud (US) Regions. It's ignored in other Amazon Web Services Regions.
         *
         * The presigned URL must be a valid request for the `CopyDBClusterSnapshot` API operation that can run in the source Amazon Web Services Region that contains the encrypted DB cluster snapshot to copy. The presigned URL request must contain the following parameter values:
         * + `KmsKeyId` - The KMS key identifier for the KMS key to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region. This is the same identifier for both the `CopyDBClusterSnapshot` operation that is called in the destination Amazon Web Services Region, and the operation contained in the presigned URL.
         * + `DestinationRegion` - The name of the Amazon Web Services Region that the DB cluster snapshot is to be created in.
         * + `SourceDBClusterSnapshotIdentifier` - The DB cluster snapshot identifier for the encrypted DB cluster snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted DB cluster snapshot from the us-west-2 Amazon Web Services Region, then your `SourceDBClusterSnapshotIdentifier` looks like the following example: `arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115`.
         *
         * To learn how to generate a Signature Version 4 signed request, see [ Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)](https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html) and [ Signature Version 4 Signing Process](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
         *
         * If you are using an Amazon Web Services SDK tool or the CLI, you can specify `SourceRegion` (or `--source-region` for the CLI) instead of specifying `PreSignedUrl` manually. Specifying `SourceRegion` autogenerates a presigned URL that is a valid request for the operation that can run in the source Amazon Web Services Region.
         */
        public var preSignedUrl: kotlin.String? = null
        /**
         * The identifier of the DB cluster snapshot to copy. This parameter isn't case-sensitive.
         *
         * You can't copy an encrypted, shared DB cluster snapshot from one Amazon Web Services Region to another.
         *
         * Constraints:
         * + Must specify a valid system snapshot in the "available" state.
         * + If the source snapshot is in the same Amazon Web Services Region as the copy, specify a valid DB snapshot identifier.
         * + If the source snapshot is in a different Amazon Web Services Region than the copy, specify a valid DB cluster snapshot ARN. For more information, go to [ Copying Snapshots Across Amazon Web Services Regions](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html#USER_CopySnapshot.AcrossRegions) in the *Amazon Aurora User Guide*.
         *
         * Example: `my-cluster-snapshot1`
         */
        public var sourceDbClusterSnapshotIdentifier: kotlin.String? = null
        /**
         * A list of tags.
         *
         * For more information, see [Tagging Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html) in the *Amazon Aurora User Guide*.
         */
        public var tags: List<Tag>? = null
        /**
         * The identifier of the new DB cluster snapshot to create from the source DB cluster snapshot. This parameter isn't case-sensitive.
         *
         * Constraints:
         * + Must contain from 1 to 63 letters, numbers, or hyphens.
         * + First character must be a letter.
         * + Can't end with a hyphen or contain two consecutive hyphens.
         *
         * Example: `my-cluster-snapshot2`
         */
        public var targetDbClusterSnapshotIdentifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.CopyDbClusterSnapshotRequest) : this() {
            this.copyTags = x.copyTags
            this.kmsKeyId = x.kmsKeyId
            this.preSignedUrl = x.preSignedUrl
            this.sourceDbClusterSnapshotIdentifier = x.sourceDbClusterSnapshotIdentifier
            this.tags = x.tags
            this.targetDbClusterSnapshotIdentifier = x.targetDbClusterSnapshotIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.CopyDbClusterSnapshotRequest = CopyDbClusterSnapshotRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
