// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CopyDbClusterParameterGroupRequest private constructor(builder: Builder) {
    /**
     * The identifier or Amazon Resource Name (ARN) for the source DB cluster parameter group. For information about creating an ARN, see [ Constructing an ARN for Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing) in the *Amazon Aurora User Guide*.
     *
     * Constraints:
     * + Must specify a valid DB cluster parameter group.
     */
    public val sourceDbClusterParameterGroupIdentifier: kotlin.String? = builder.sourceDbClusterParameterGroupIdentifier
    /**
     * A list of tags.
     *
     * For more information, see [Tagging Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html) in the *Amazon Aurora User Guide*.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A description for the copied DB cluster parameter group.
     */
    public val targetDbClusterParameterGroupDescription: kotlin.String? = builder.targetDbClusterParameterGroupDescription
    /**
     * The identifier for the copied DB cluster parameter group.
     *
     * Constraints:
     * + Can't be null, empty, or blank
     * + Must contain from 1 to 255 letters, numbers, or hyphens
     * + First character must be a letter
     * + Can't end with a hyphen or contain two consecutive hyphens
     *
     * Example: `my-cluster-param-group1`
     */
    public val targetDbClusterParameterGroupIdentifier: kotlin.String? = builder.targetDbClusterParameterGroupIdentifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.CopyDbClusterParameterGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CopyDbClusterParameterGroupRequest(")
        append("sourceDbClusterParameterGroupIdentifier=$sourceDbClusterParameterGroupIdentifier,")
        append("tags=$tags,")
        append("targetDbClusterParameterGroupDescription=$targetDbClusterParameterGroupDescription,")
        append("targetDbClusterParameterGroupIdentifier=$targetDbClusterParameterGroupIdentifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = sourceDbClusterParameterGroupIdentifier?.hashCode() ?: 0
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetDbClusterParameterGroupDescription?.hashCode() ?: 0)
        result = 31 * result + (targetDbClusterParameterGroupIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CopyDbClusterParameterGroupRequest

        if (sourceDbClusterParameterGroupIdentifier != other.sourceDbClusterParameterGroupIdentifier) return false
        if (tags != other.tags) return false
        if (targetDbClusterParameterGroupDescription != other.targetDbClusterParameterGroupDescription) return false
        if (targetDbClusterParameterGroupIdentifier != other.targetDbClusterParameterGroupIdentifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.CopyDbClusterParameterGroupRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier or Amazon Resource Name (ARN) for the source DB cluster parameter group. For information about creating an ARN, see [ Constructing an ARN for Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing) in the *Amazon Aurora User Guide*.
         *
         * Constraints:
         * + Must specify a valid DB cluster parameter group.
         */
        public var sourceDbClusterParameterGroupIdentifier: kotlin.String? = null
        /**
         * A list of tags.
         *
         * For more information, see [Tagging Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide* or [Tagging Amazon Aurora and Amazon RDS resources](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.html) in the *Amazon Aurora User Guide*.
         */
        public var tags: List<Tag>? = null
        /**
         * A description for the copied DB cluster parameter group.
         */
        public var targetDbClusterParameterGroupDescription: kotlin.String? = null
        /**
         * The identifier for the copied DB cluster parameter group.
         *
         * Constraints:
         * + Can't be null, empty, or blank
         * + Must contain from 1 to 255 letters, numbers, or hyphens
         * + First character must be a letter
         * + Can't end with a hyphen or contain two consecutive hyphens
         *
         * Example: `my-cluster-param-group1`
         */
        public var targetDbClusterParameterGroupIdentifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.CopyDbClusterParameterGroupRequest) : this() {
            this.sourceDbClusterParameterGroupIdentifier = x.sourceDbClusterParameterGroupIdentifier
            this.tags = x.tags
            this.targetDbClusterParameterGroupDescription = x.targetDbClusterParameterGroupDescription
            this.targetDbClusterParameterGroupIdentifier = x.targetDbClusterParameterGroupIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.CopyDbClusterParameterGroupRequest = CopyDbClusterParameterGroupRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
