// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains the available processor feature information for the DB instance class of a DB instance.
 *
 * For more information, see [Configuring the Processor of the DB Instance Class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor) in the *Amazon RDS User Guide. *
 */
public class AvailableProcessorFeature private constructor(builder: Builder) {
    /**
     * The allowed values for the processor feature of the DB instance class.
     */
    public val allowedValues: kotlin.String? = builder.allowedValues
    /**
     * The default value for the processor feature of the DB instance class.
     */
    public val defaultValue: kotlin.String? = builder.defaultValue
    /**
     * The name of the processor feature. Valid names are `coreCount` and `threadsPerCore`.
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.AvailableProcessorFeature = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AvailableProcessorFeature(")
        append("allowedValues=$allowedValues,")
        append("defaultValue=$defaultValue,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedValues?.hashCode() ?: 0
        result = 31 * result + (defaultValue?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AvailableProcessorFeature

        if (allowedValues != other.allowedValues) return false
        if (defaultValue != other.defaultValue) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.AvailableProcessorFeature = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The allowed values for the processor feature of the DB instance class.
         */
        public var allowedValues: kotlin.String? = null
        /**
         * The default value for the processor feature of the DB instance class.
         */
        public var defaultValue: kotlin.String? = null
        /**
         * The name of the processor feature. Valid names are `coreCount` and `threadsPerCore`.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.AvailableProcessorFeature) : this() {
            this.allowedValues = x.allowedValues
            this.defaultValue = x.defaultValue
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.AvailableProcessorFeature = AvailableProcessorFeature(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
