// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.DbSecurityGroup
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.sdk.kotlin.services.rds.model.RevokeDbSecurityGroupIngressResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class RevokeDBSecurityGroupIngressOperationDeserializer: HttpDeserializer.NonStreaming<RevokeDbSecurityGroupIngressResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): RevokeDbSecurityGroupIngressResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwRevokeDbSecurityGroupIngressError(context, call, payload)
        }
        val builder = RevokeDbSecurityGroupIngressResponse.Builder()

        if (payload != null) {
            deserializeRevokeDBSecurityGroupIngressOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwRevokeDbSecurityGroupIngressError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBSecurityGroupNotFound" -> DbSecurityGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "AuthorizationNotFound" -> AuthorizationNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDBSecurityGroupState" -> InvalidDbSecurityGroupStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRevokeDBSecurityGroupIngressOperationBody(builder: RevokeDbSecurityGroupIngressResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "RevokeDBSecurityGroupIngress")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBSecurityGroup com.amazonaws.rds#RevokeDBSecurityGroupIngressResult$DBSecurityGroup
            "DBSecurityGroup" -> builder.dbSecurityGroup = deserializeDbSecurityGroupDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
