// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.DbInstance
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.sdk.kotlin.services.rds.model.RestoreDbInstanceFromS3Response
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class RestoreDBInstanceFromS3OperationDeserializer: HttpDeserializer.NonStreaming<RestoreDbInstanceFromS3Response> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): RestoreDbInstanceFromS3Response {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwRestoreDbInstanceFromS3Error(context, call, payload)
        }
        val builder = RestoreDbInstanceFromS3Response.Builder()

        if (payload != null) {
            deserializeRestoreDBInstanceFromS3OperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwRestoreDbInstanceFromS3Error(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBSubnetGroupDoesNotCoverEnoughAZs" -> DbSubnetGroupDoesNotCoverEnoughAzsDeserializer().deserialize(context, wrappedCall, payload)
        "DBSubnetGroupNotFoundFault" -> DbSubnetGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "KMSKeyNotAccessibleFault" -> KmsKeyNotAccessibleFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InstanceQuotaExceeded" -> InstanceQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "OptionGroupNotFoundFault" -> OptionGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidVPCNetworkStateFault" -> InvalidVpcNetworkStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "StorageQuotaExceeded" -> StorageQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSubnet" -> InvalidSubnetDeserializer().deserialize(context, wrappedCall, payload)
        "DBInstanceAlreadyExists" -> DbInstanceAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InsufficientDBInstanceCapacity" -> InsufficientDbInstanceCapacityFaultDeserializer().deserialize(context, wrappedCall, payload)
        "CertificateNotFound" -> CertificateNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "NetworkTypeNotSupported" -> NetworkTypeNotSupportedDeserializer().deserialize(context, wrappedCall, payload)
        "DBSecurityGroupNotFound" -> DbSecurityGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ProvisionedIopsNotAvailableInAZFault" -> ProvisionedIopsNotAvailableInAzFaultDeserializer().deserialize(context, wrappedCall, payload)
        "AuthorizationNotFound" -> AuthorizationNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidS3BucketFault" -> InvalidS3BucketFaultDeserializer().deserialize(context, wrappedCall, payload)
        "StorageTypeNotSupported" -> StorageTypeNotSupportedFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBParameterGroupNotFound" -> DbParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "BackupPolicyNotFoundFault" -> BackupPolicyNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRestoreDBInstanceFromS3OperationBody(builder: RestoreDbInstanceFromS3Response.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "RestoreDBInstanceFromS3")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBInstance com.amazonaws.rds#RestoreDBInstanceFromS3Result$DBInstance
            "DBInstance" -> builder.dbInstance = deserializeDbInstanceDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
