// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.DbCluster
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.sdk.kotlin.services.rds.model.RestoreDbClusterFromS3Response
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class RestoreDBClusterFromS3OperationDeserializer: HttpDeserializer.NonStreaming<RestoreDbClusterFromS3Response> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): RestoreDbClusterFromS3Response {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwRestoreDbClusterFromS3Error(context, call, payload)
        }
        val builder = RestoreDbClusterFromS3Response.Builder()

        if (payload != null) {
            deserializeRestoreDBClusterFromS3OperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwRestoreDbClusterFromS3Error(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDBSubnetGroupStateFault" -> InvalidDbSubnetGroupStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InsufficientStorageClusterCapacity" -> InsufficientStorageClusterCapacityFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBSubnetGroupNotFoundFault" -> DbSubnetGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "KMSKeyNotAccessibleFault" -> KmsKeyNotAccessibleFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBClusterParameterGroupNotFound" -> DbClusterParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidVPCNetworkStateFault" -> InvalidVpcNetworkStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "StorageQuotaExceeded" -> StorageQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSubnet" -> InvalidSubnetDeserializer().deserialize(context, wrappedCall, payload)
        "DBClusterAlreadyExistsFault" -> DbClusterAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DomainNotFoundFault" -> DomainNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBClusterQuotaExceededFault" -> DbClusterQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidS3BucketFault" -> InvalidS3BucketFaultDeserializer().deserialize(context, wrappedCall, payload)
        "StorageTypeNotSupported" -> StorageTypeNotSupportedFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRestoreDBClusterFromS3OperationBody(builder: RestoreDbClusterFromS3Response.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "RestoreDBClusterFromS3")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBCluster com.amazonaws.rds#RestoreDBClusterFromS3Result$DBCluster
            "DBCluster" -> builder.dbCluster = deserializeDbClusterDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
