// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.ReservedDbInstance
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseDouble
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeReservedDbInstanceDocument(reader: XmlTagReader): ReservedDbInstance {
    val builder = ReservedDbInstance.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // ReservedDBInstanceId com.amazonaws.rds#ReservedDBInstance$ReservedDBInstanceId
            "ReservedDBInstanceId" -> builder.reservedDbInstanceId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // ReservedDBInstancesOfferingId com.amazonaws.rds#ReservedDBInstance$ReservedDBInstancesOfferingId
            "ReservedDBInstancesOfferingId" -> builder.reservedDbInstancesOfferingId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBInstanceClass com.amazonaws.rds#ReservedDBInstance$DBInstanceClass
            "DBInstanceClass" -> builder.dbInstanceClass = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // StartTime com.amazonaws.rds#ReservedDBInstance$StartTime
            "StartTime" -> builder.startTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // Duration com.amazonaws.rds#ReservedDBInstance$Duration
            "Duration" -> builder.duration = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#Integer`)" }
            // FixedPrice com.amazonaws.rds#ReservedDBInstance$FixedPrice
            "FixedPrice" -> builder.fixedPrice = curr.tryData()
                .parseDouble()
                .getOrDeserializeErr { "expected (double: `com.amazonaws.rds#Double`)" }
            // UsagePrice com.amazonaws.rds#ReservedDBInstance$UsagePrice
            "UsagePrice" -> builder.usagePrice = curr.tryData()
                .parseDouble()
                .getOrDeserializeErr { "expected (double: `com.amazonaws.rds#Double`)" }
            // CurrencyCode com.amazonaws.rds#ReservedDBInstance$CurrencyCode
            "CurrencyCode" -> builder.currencyCode = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBInstanceCount com.amazonaws.rds#ReservedDBInstance$DBInstanceCount
            "DBInstanceCount" -> builder.dbInstanceCount = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#Integer`)" }
            // ProductDescription com.amazonaws.rds#ReservedDBInstance$ProductDescription
            "ProductDescription" -> builder.productDescription = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // OfferingType com.amazonaws.rds#ReservedDBInstance$OfferingType
            "OfferingType" -> builder.offeringType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // MultiAZ com.amazonaws.rds#ReservedDBInstance$MultiAZ
            "MultiAZ" -> builder.multiAz = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // State com.amazonaws.rds#ReservedDBInstance$State
            "State" -> builder.state = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // RecurringCharges com.amazonaws.rds#ReservedDBInstance$RecurringCharges
            "RecurringCharges" -> builder.recurringCharges = deserializeRecurringChargeListShape(curr)
            // ReservedDBInstanceArn com.amazonaws.rds#ReservedDBInstance$ReservedDBInstanceArn
            "ReservedDBInstanceArn" -> builder.reservedDbInstanceArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // LeaseId com.amazonaws.rds#ReservedDBInstance$LeaseId
            "LeaseId" -> builder.leaseId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
