// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.AutomationMode
import aws.sdk.kotlin.services.rds.model.PendingModifiedValues
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializePendingModifiedValuesDocument(reader: XmlTagReader): PendingModifiedValues {
    val builder = PendingModifiedValues.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBInstanceClass com.amazonaws.rds#PendingModifiedValues$DBInstanceClass
            "DBInstanceClass" -> builder.dbInstanceClass = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // AllocatedStorage com.amazonaws.rds#PendingModifiedValues$AllocatedStorage
            "AllocatedStorage" -> builder.allocatedStorage = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            // MasterUserPassword com.amazonaws.rds#PendingModifiedValues$MasterUserPassword
            "MasterUserPassword" -> builder.masterUserPassword = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Port com.amazonaws.rds#PendingModifiedValues$Port
            "Port" -> builder.port = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            // BackupRetentionPeriod com.amazonaws.rds#PendingModifiedValues$BackupRetentionPeriod
            "BackupRetentionPeriod" -> builder.backupRetentionPeriod = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            // MultiAZ com.amazonaws.rds#PendingModifiedValues$MultiAZ
            "MultiAZ" -> builder.multiAz = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#BooleanOptional`)" }
            // EngineVersion com.amazonaws.rds#PendingModifiedValues$EngineVersion
            "EngineVersion" -> builder.engineVersion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // LicenseModel com.amazonaws.rds#PendingModifiedValues$LicenseModel
            "LicenseModel" -> builder.licenseModel = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Iops com.amazonaws.rds#PendingModifiedValues$Iops
            "Iops" -> builder.iops = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            // DBInstanceIdentifier com.amazonaws.rds#PendingModifiedValues$DBInstanceIdentifier
            "DBInstanceIdentifier" -> builder.dbInstanceIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // StorageType com.amazonaws.rds#PendingModifiedValues$StorageType
            "StorageType" -> builder.storageType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // CACertificateIdentifier com.amazonaws.rds#PendingModifiedValues$CACertificateIdentifier
            "CACertificateIdentifier" -> builder.caCertificateIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBSubnetGroupName com.amazonaws.rds#PendingModifiedValues$DBSubnetGroupName
            "DBSubnetGroupName" -> builder.dbSubnetGroupName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // PendingCloudwatchLogsExports com.amazonaws.rds#PendingModifiedValues$PendingCloudwatchLogsExports
            "PendingCloudwatchLogsExports" -> builder.pendingCloudwatchLogsExports = deserializePendingCloudwatchLogsExportsDocument(curr)
            // ProcessorFeatures com.amazonaws.rds#PendingModifiedValues$ProcessorFeatures
            "ProcessorFeatures" -> builder.processorFeatures = deserializeProcessorFeatureListShape(curr)
            // IAMDatabaseAuthenticationEnabled com.amazonaws.rds#PendingModifiedValues$IAMDatabaseAuthenticationEnabled
            "IAMDatabaseAuthenticationEnabled" -> builder.iamDatabaseAuthenticationEnabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#BooleanOptional`)" }
            // AutomationMode com.amazonaws.rds#PendingModifiedValues$AutomationMode
            "AutomationMode" -> builder.automationMode = curr.tryData()
                .parse { AutomationMode.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.rds#AutomationMode`)" }
            // ResumeFullAutomationModeTime com.amazonaws.rds#PendingModifiedValues$ResumeFullAutomationModeTime
            "ResumeFullAutomationModeTime" -> builder.resumeFullAutomationModeTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // StorageThroughput com.amazonaws.rds#PendingModifiedValues$StorageThroughput
            "StorageThroughput" -> builder.storageThroughput = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            // Engine com.amazonaws.rds#PendingModifiedValues$Engine
            "Engine" -> builder.engine = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DedicatedLogVolume com.amazonaws.rds#PendingModifiedValues$DedicatedLogVolume
            "DedicatedLogVolume" -> builder.dedicatedLogVolume = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#BooleanOptional`)" }
            // MultiTenant com.amazonaws.rds#PendingModifiedValues$MultiTenant
            "MultiTenant" -> builder.multiTenant = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#BooleanOptional`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
