// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.DbRecommendation
import aws.sdk.kotlin.services.rds.model.ModifyDbRecommendationResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ModifyDBRecommendationOperationDeserializer: HttpDeserializer.NonStreaming<ModifyDbRecommendationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ModifyDbRecommendationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwModifyDbRecommendationError(context, call, payload)
        }
        val builder = ModifyDbRecommendationResponse.Builder()

        if (payload != null) {
            deserializeModifyDBRecommendationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwModifyDbRecommendationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyDBRecommendationOperationBody(builder: ModifyDbRecommendationResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ModifyDBRecommendation")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBRecommendation com.amazonaws.rds#DBRecommendationMessage$DBRecommendation
            "DBRecommendation" -> builder.dbRecommendation = deserializeDbRecommendationDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
