// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.DbCluster
import aws.sdk.kotlin.services.rds.model.ModifyDbClusterResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ModifyDBClusterOperationDeserializer: HttpDeserializer.NonStreaming<ModifyDbClusterResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ModifyDbClusterResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwModifyDbClusterError(context, call, payload)
        }
        val builder = ModifyDbClusterResponse.Builder()

        if (payload != null) {
            deserializeModifyDBClusterOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwModifyDbClusterError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDBSubnetGroupStateFault" -> InvalidDbSubnetGroupStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBSubnetGroupNotFoundFault" -> DbSubnetGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "OptionGroupNotFoundFault" -> OptionGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBClusterParameterGroupNotFound" -> DbClusterParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDBSecurityGroupState" -> InvalidDbSecurityGroupStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidVPCNetworkStateFault" -> InvalidVpcNetworkStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "StorageQuotaExceeded" -> StorageQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSubnet" -> InvalidSubnetDeserializer().deserialize(context, wrappedCall, payload)
        "DBInstanceAlreadyExists" -> DbInstanceAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDBInstanceState" -> InvalidDbInstanceStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBClusterAlreadyExistsFault" -> DbClusterAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DomainNotFoundFault" -> DomainNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "StorageTypeNotAvailableFault" -> StorageTypeNotAvailableFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyDBClusterOperationBody(builder: ModifyDbClusterResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ModifyDBCluster")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBCluster com.amazonaws.rds#ModifyDBClusterResult$DBCluster
            "DBCluster" -> builder.dbCluster = deserializeDbClusterDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
