// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.sdk.kotlin.services.rds.model.Tag
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ListTagsForResourceOperationDeserializer: HttpDeserializer.NonStreaming<ListTagsForResourceResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListTagsForResourceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListTagsForResourceError(context, call, payload)
        }
        val builder = ListTagsForResourceResponse.Builder()

        if (payload != null) {
            deserializeListTagsForResourceOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListTagsForResourceError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBInstanceNotFound" -> DbInstanceNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "BlueGreenDeploymentNotFoundFault" -> BlueGreenDeploymentNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBProxyTargetGroupNotFoundFault" -> DbProxyTargetGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBProxyNotFoundFault" -> DbProxyNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBSnapshotTenantDatabaseNotFoundFault" -> DbSnapshotTenantDatabaseNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "IntegrationNotFoundFault" -> IntegrationNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "TenantDatabaseNotFound" -> TenantDatabaseNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBSnapshotNotFound" -> DbSnapshotNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListTagsForResourceOperationBody(builder: ListTagsForResourceResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ListTagsForResource")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // TagList com.amazonaws.rds#TagListMessage$TagList
            "TagList" -> builder.tagList = deserializeTagListShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
