// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.DescribeTenantDatabasesResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.sdk.kotlin.services.rds.model.TenantDatabase
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class DescribeTenantDatabasesOperationDeserializer: HttpDeserializer.NonStreaming<DescribeTenantDatabasesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeTenantDatabasesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeTenantDatabasesError(context, call, payload)
        }
        val builder = DescribeTenantDatabasesResponse.Builder()

        if (payload != null) {
            deserializeDescribeTenantDatabasesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeTenantDatabasesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBInstanceNotFound" -> DbInstanceNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeTenantDatabasesOperationBody(builder: DescribeTenantDatabasesResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DescribeTenantDatabases")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Marker com.amazonaws.rds#TenantDatabasesMessage$Marker
            "Marker" -> builder.marker = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // TenantDatabases com.amazonaws.rds#TenantDatabasesMessage$TenantDatabases
            "TenantDatabases" -> builder.tenantDatabases = deserializeTenantDatabasesListShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
