// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.DbInstanceAutomatedBackup
import aws.sdk.kotlin.services.rds.model.DescribeDbInstanceAutomatedBackupsResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class DescribeDBInstanceAutomatedBackupsOperationDeserializer: HttpDeserializer.NonStreaming<DescribeDbInstanceAutomatedBackupsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeDbInstanceAutomatedBackupsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeDbInstanceAutomatedBackupsError(context, call, payload)
        }
        val builder = DescribeDbInstanceAutomatedBackupsResponse.Builder()

        if (payload != null) {
            deserializeDescribeDBInstanceAutomatedBackupsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeDbInstanceAutomatedBackupsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBInstanceAutomatedBackupNotFound" -> DbInstanceAutomatedBackupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDBInstanceAutomatedBackupsOperationBody(builder: DescribeDbInstanceAutomatedBackupsResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DescribeDBInstanceAutomatedBackups")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBInstanceAutomatedBackups com.amazonaws.rds#DBInstanceAutomatedBackupMessage$DBInstanceAutomatedBackups
            "DBInstanceAutomatedBackups" -> builder.dbInstanceAutomatedBackups = deserializeDBInstanceAutomatedBackupListShape(curr)
            // Marker com.amazonaws.rds#DBInstanceAutomatedBackupMessage$Marker
            "Marker" -> builder.marker = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            else -> {}
        }
        curr.drop()
    }
}
