// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.DbClusterSnapshotAttributesResult
import aws.sdk.kotlin.services.rds.model.DescribeDbClusterSnapshotAttributesResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class DescribeDBClusterSnapshotAttributesOperationDeserializer: HttpDeserializer.NonStreaming<DescribeDbClusterSnapshotAttributesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeDbClusterSnapshotAttributesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeDbClusterSnapshotAttributesError(context, call, payload)
        }
        val builder = DescribeDbClusterSnapshotAttributesResponse.Builder()

        if (payload != null) {
            deserializeDescribeDBClusterSnapshotAttributesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeDbClusterSnapshotAttributesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterSnapshotNotFoundFault" -> DbClusterSnapshotNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDBClusterSnapshotAttributesOperationBody(builder: DescribeDbClusterSnapshotAttributesResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DescribeDBClusterSnapshotAttributes")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBClusterSnapshotAttributesResult com.amazonaws.rds#DescribeDBClusterSnapshotAttributesResult$DBClusterSnapshotAttributesResult
            "DBClusterSnapshotAttributesResult" -> builder.dbClusterSnapshotAttributesResult = deserializeDbClusterSnapshotAttributesResultDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
