// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.DbInstance
import aws.sdk.kotlin.services.rds.model.DeleteDbInstanceResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class DeleteDBInstanceOperationDeserializer: HttpDeserializer.NonStreaming<DeleteDbInstanceResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DeleteDbInstanceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteDbInstanceError(context, call, payload)
        }
        val builder = DeleteDbInstanceResponse.Builder()

        if (payload != null) {
            deserializeDeleteDBInstanceOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDeleteDbInstanceError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBInstanceNotFound" -> DbInstanceNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "SnapshotQuotaExceeded" -> SnapshotQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBInstanceAutomatedBackupQuotaExceeded" -> DbInstanceAutomatedBackupQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBSnapshotAlreadyExists" -> DbSnapshotAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDBInstanceState" -> InvalidDbInstanceStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteDBInstanceOperationBody(builder: DeleteDbInstanceResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DeleteDBInstance")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBInstance com.amazonaws.rds#DeleteDBInstanceResult$DBInstance
            "DBInstance" -> builder.dbInstance = deserializeDbInstanceDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
