// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.DbInstanceAutomatedBackup
import aws.sdk.kotlin.services.rds.model.DeleteDbInstanceAutomatedBackupResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class DeleteDBInstanceAutomatedBackupOperationDeserializer: HttpDeserializer.NonStreaming<DeleteDbInstanceAutomatedBackupResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DeleteDbInstanceAutomatedBackupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteDbInstanceAutomatedBackupError(context, call, payload)
        }
        val builder = DeleteDbInstanceAutomatedBackupResponse.Builder()

        if (payload != null) {
            deserializeDeleteDBInstanceAutomatedBackupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDeleteDbInstanceAutomatedBackupError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBInstanceAutomatedBackupNotFound" -> DbInstanceAutomatedBackupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDBInstanceAutomatedBackupState" -> InvalidDbInstanceAutomatedBackupStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteDBInstanceAutomatedBackupOperationBody(builder: DeleteDbInstanceAutomatedBackupResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DeleteDBInstanceAutomatedBackup")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBInstanceAutomatedBackup com.amazonaws.rds#DeleteDBInstanceAutomatedBackupResult$DBInstanceAutomatedBackup
            "DBInstanceAutomatedBackup" -> builder.dbInstanceAutomatedBackup = deserializeDbInstanceAutomatedBackupDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
