// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.BlueGreenDeployment
import aws.sdk.kotlin.services.rds.model.DeleteBlueGreenDeploymentResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class DeleteBlueGreenDeploymentOperationDeserializer: HttpDeserializer.NonStreaming<DeleteBlueGreenDeploymentResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DeleteBlueGreenDeploymentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteBlueGreenDeploymentError(context, call, payload)
        }
        val builder = DeleteBlueGreenDeploymentResponse.Builder()

        if (payload != null) {
            deserializeDeleteBlueGreenDeploymentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDeleteBlueGreenDeploymentError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BlueGreenDeploymentNotFoundFault" -> BlueGreenDeploymentNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidBlueGreenDeploymentStateFault" -> InvalidBlueGreenDeploymentStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteBlueGreenDeploymentOperationBody(builder: DeleteBlueGreenDeploymentResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DeleteBlueGreenDeployment")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // BlueGreenDeployment com.amazonaws.rds#DeleteBlueGreenDeploymentResponse$BlueGreenDeployment
            "BlueGreenDeployment" -> builder.blueGreenDeployment = deserializeBlueGreenDeploymentDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
