// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.DbProxyEndpoint
import aws.sdk.kotlin.services.rds.model.DbProxyEndpointStatus
import aws.sdk.kotlin.services.rds.model.DbProxyEndpointTargetRole
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeDbProxyEndpointDocument(reader: XmlTagReader): DbProxyEndpoint {
    val builder = DbProxyEndpoint.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBProxyEndpointName com.amazonaws.rds#DBProxyEndpoint$DBProxyEndpointName
            "DBProxyEndpointName" -> builder.dbProxyEndpointName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBProxyEndpointArn com.amazonaws.rds#DBProxyEndpoint$DBProxyEndpointArn
            "DBProxyEndpointArn" -> builder.dbProxyEndpointArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBProxyName com.amazonaws.rds#DBProxyEndpoint$DBProxyName
            "DBProxyName" -> builder.dbProxyName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Status com.amazonaws.rds#DBProxyEndpoint$Status
            "Status" -> builder.status = curr.tryData()
                .parse { DbProxyEndpointStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.rds#DBProxyEndpointStatus`)" }
            // VpcId com.amazonaws.rds#DBProxyEndpoint$VpcId
            "VpcId" -> builder.vpcId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // VpcSecurityGroupIds com.amazonaws.rds#DBProxyEndpoint$VpcSecurityGroupIds
            "VpcSecurityGroupIds" -> builder.vpcSecurityGroupIds = deserializeStringListShape(curr)
            // VpcSubnetIds com.amazonaws.rds#DBProxyEndpoint$VpcSubnetIds
            "VpcSubnetIds" -> builder.vpcSubnetIds = deserializeStringListShape(curr)
            // Endpoint com.amazonaws.rds#DBProxyEndpoint$Endpoint
            "Endpoint" -> builder.endpoint = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // CreatedDate com.amazonaws.rds#DBProxyEndpoint$CreatedDate
            "CreatedDate" -> builder.createdDate = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // TargetRole com.amazonaws.rds#DBProxyEndpoint$TargetRole
            "TargetRole" -> builder.targetRole = curr.tryData()
                .parse { DbProxyEndpointTargetRole.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.rds#DBProxyEndpointTargetRole`)" }
            // IsDefault com.amazonaws.rds#DBProxyEndpoint$IsDefault
            "IsDefault" -> builder.isDefault = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
