// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.DbProxy
import aws.sdk.kotlin.services.rds.model.DbProxyStatus
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeDbProxyDocument(reader: XmlTagReader): DbProxy {
    val builder = DbProxy.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBProxyName com.amazonaws.rds#DBProxy$DBProxyName
            "DBProxyName" -> builder.dbProxyName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBProxyArn com.amazonaws.rds#DBProxy$DBProxyArn
            "DBProxyArn" -> builder.dbProxyArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Status com.amazonaws.rds#DBProxy$Status
            "Status" -> builder.status = curr.tryData()
                .parse { DbProxyStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.rds#DBProxyStatus`)" }
            // EngineFamily com.amazonaws.rds#DBProxy$EngineFamily
            "EngineFamily" -> builder.engineFamily = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // VpcId com.amazonaws.rds#DBProxy$VpcId
            "VpcId" -> builder.vpcId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // VpcSecurityGroupIds com.amazonaws.rds#DBProxy$VpcSecurityGroupIds
            "VpcSecurityGroupIds" -> builder.vpcSecurityGroupIds = deserializeStringListShape(curr)
            // VpcSubnetIds com.amazonaws.rds#DBProxy$VpcSubnetIds
            "VpcSubnetIds" -> builder.vpcSubnetIds = deserializeStringListShape(curr)
            // Auth com.amazonaws.rds#DBProxy$Auth
            "Auth" -> builder.auth = deserializeUserAuthConfigInfoListShape(curr)
            // RoleArn com.amazonaws.rds#DBProxy$RoleArn
            "RoleArn" -> builder.roleArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Endpoint com.amazonaws.rds#DBProxy$Endpoint
            "Endpoint" -> builder.endpoint = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // RequireTLS com.amazonaws.rds#DBProxy$RequireTLS
            "RequireTLS" -> builder.requireTls = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // IdleClientTimeout com.amazonaws.rds#DBProxy$IdleClientTimeout
            "IdleClientTimeout" -> builder.idleClientTimeout = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#Integer`)" }
            // DebugLogging com.amazonaws.rds#DBProxy$DebugLogging
            "DebugLogging" -> builder.debugLogging = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // CreatedDate com.amazonaws.rds#DBProxy$CreatedDate
            "CreatedDate" -> builder.createdDate = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // UpdatedDate com.amazonaws.rds#DBProxy$UpdatedDate
            "UpdatedDate" -> builder.updatedDate = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
