// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.DbClusterSnapshot
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeDbClusterSnapshotDocument(reader: XmlTagReader): DbClusterSnapshot {
    val builder = DbClusterSnapshot.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // AvailabilityZones com.amazonaws.rds#DBClusterSnapshot$AvailabilityZones
            "AvailabilityZones" -> builder.availabilityZones = deserializeAvailabilityZonesShape(curr)
            // DBClusterSnapshotIdentifier com.amazonaws.rds#DBClusterSnapshot$DBClusterSnapshotIdentifier
            "DBClusterSnapshotIdentifier" -> builder.dbClusterSnapshotIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBClusterIdentifier com.amazonaws.rds#DBClusterSnapshot$DBClusterIdentifier
            "DBClusterIdentifier" -> builder.dbClusterIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // SnapshotCreateTime com.amazonaws.rds#DBClusterSnapshot$SnapshotCreateTime
            "SnapshotCreateTime" -> builder.snapshotCreateTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // Engine com.amazonaws.rds#DBClusterSnapshot$Engine
            "Engine" -> builder.engine = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // EngineMode com.amazonaws.rds#DBClusterSnapshot$EngineMode
            "EngineMode" -> builder.engineMode = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // AllocatedStorage com.amazonaws.rds#DBClusterSnapshot$AllocatedStorage
            "AllocatedStorage" -> builder.allocatedStorage = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#Integer`)" }
            // Status com.amazonaws.rds#DBClusterSnapshot$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Port com.amazonaws.rds#DBClusterSnapshot$Port
            "Port" -> builder.port = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#Integer`)" }
            // VpcId com.amazonaws.rds#DBClusterSnapshot$VpcId
            "VpcId" -> builder.vpcId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // ClusterCreateTime com.amazonaws.rds#DBClusterSnapshot$ClusterCreateTime
            "ClusterCreateTime" -> builder.clusterCreateTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // MasterUsername com.amazonaws.rds#DBClusterSnapshot$MasterUsername
            "MasterUsername" -> builder.masterUsername = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // EngineVersion com.amazonaws.rds#DBClusterSnapshot$EngineVersion
            "EngineVersion" -> builder.engineVersion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // LicenseModel com.amazonaws.rds#DBClusterSnapshot$LicenseModel
            "LicenseModel" -> builder.licenseModel = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // SnapshotType com.amazonaws.rds#DBClusterSnapshot$SnapshotType
            "SnapshotType" -> builder.snapshotType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // PercentProgress com.amazonaws.rds#DBClusterSnapshot$PercentProgress
            "PercentProgress" -> builder.percentProgress = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#Integer`)" }
            // StorageEncrypted com.amazonaws.rds#DBClusterSnapshot$StorageEncrypted
            "StorageEncrypted" -> builder.storageEncrypted = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // KmsKeyId com.amazonaws.rds#DBClusterSnapshot$KmsKeyId
            "KmsKeyId" -> builder.kmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBClusterSnapshotArn com.amazonaws.rds#DBClusterSnapshot$DBClusterSnapshotArn
            "DBClusterSnapshotArn" -> builder.dbClusterSnapshotArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // SourceDBClusterSnapshotArn com.amazonaws.rds#DBClusterSnapshot$SourceDBClusterSnapshotArn
            "SourceDBClusterSnapshotArn" -> builder.sourceDbClusterSnapshotArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // IAMDatabaseAuthenticationEnabled com.amazonaws.rds#DBClusterSnapshot$IAMDatabaseAuthenticationEnabled
            "IAMDatabaseAuthenticationEnabled" -> builder.iamDatabaseAuthenticationEnabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // TagList com.amazonaws.rds#DBClusterSnapshot$TagList
            "TagList" -> builder.tagList = deserializeTagListShape(curr)
            // DBSystemId com.amazonaws.rds#DBClusterSnapshot$DBSystemId
            "DBSystemId" -> builder.dbSystemId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // StorageType com.amazonaws.rds#DBClusterSnapshot$StorageType
            "StorageType" -> builder.storageType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DbClusterResourceId com.amazonaws.rds#DBClusterSnapshot$DbClusterResourceId
            "DbClusterResourceId" -> builder.dbClusterResourceId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // StorageThroughput com.amazonaws.rds#DBClusterSnapshot$StorageThroughput
            "StorageThroughput" -> builder.storageThroughput = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
