// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.ActivityStreamMode
import aws.sdk.kotlin.services.rds.model.ActivityStreamStatus
import aws.sdk.kotlin.services.rds.model.DbCluster
import aws.sdk.kotlin.services.rds.model.LocalWriteForwardingStatus
import aws.sdk.kotlin.services.rds.model.WriteForwardingStatus
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseLong
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeDbClusterDocument(reader: XmlTagReader): DbCluster {
    val builder = DbCluster.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // AllocatedStorage com.amazonaws.rds#DBCluster$AllocatedStorage
            "AllocatedStorage" -> builder.allocatedStorage = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            // AvailabilityZones com.amazonaws.rds#DBCluster$AvailabilityZones
            "AvailabilityZones" -> builder.availabilityZones = deserializeAvailabilityZonesShape(curr)
            // BackupRetentionPeriod com.amazonaws.rds#DBCluster$BackupRetentionPeriod
            "BackupRetentionPeriod" -> builder.backupRetentionPeriod = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            // CharacterSetName com.amazonaws.rds#DBCluster$CharacterSetName
            "CharacterSetName" -> builder.characterSetName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DatabaseName com.amazonaws.rds#DBCluster$DatabaseName
            "DatabaseName" -> builder.databaseName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBClusterIdentifier com.amazonaws.rds#DBCluster$DBClusterIdentifier
            "DBClusterIdentifier" -> builder.dbClusterIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBClusterParameterGroup com.amazonaws.rds#DBCluster$DBClusterParameterGroup
            "DBClusterParameterGroup" -> builder.dbClusterParameterGroup = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBSubnetGroup com.amazonaws.rds#DBCluster$DBSubnetGroup
            "DBSubnetGroup" -> builder.dbSubnetGroup = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Status com.amazonaws.rds#DBCluster$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // AutomaticRestartTime com.amazonaws.rds#DBCluster$AutomaticRestartTime
            "AutomaticRestartTime" -> builder.automaticRestartTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // PercentProgress com.amazonaws.rds#DBCluster$PercentProgress
            "PercentProgress" -> builder.percentProgress = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // EarliestRestorableTime com.amazonaws.rds#DBCluster$EarliestRestorableTime
            "EarliestRestorableTime" -> builder.earliestRestorableTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // Endpoint com.amazonaws.rds#DBCluster$Endpoint
            "Endpoint" -> builder.endpoint = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // ReaderEndpoint com.amazonaws.rds#DBCluster$ReaderEndpoint
            "ReaderEndpoint" -> builder.readerEndpoint = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // CustomEndpoints com.amazonaws.rds#DBCluster$CustomEndpoints
            "CustomEndpoints" -> builder.customEndpoints = deserializeStringListShape(curr)
            // MultiAZ com.amazonaws.rds#DBCluster$MultiAZ
            "MultiAZ" -> builder.multiAz = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#BooleanOptional`)" }
            // Engine com.amazonaws.rds#DBCluster$Engine
            "Engine" -> builder.engine = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // EngineVersion com.amazonaws.rds#DBCluster$EngineVersion
            "EngineVersion" -> builder.engineVersion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // LatestRestorableTime com.amazonaws.rds#DBCluster$LatestRestorableTime
            "LatestRestorableTime" -> builder.latestRestorableTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // Port com.amazonaws.rds#DBCluster$Port
            "Port" -> builder.port = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            // MasterUsername com.amazonaws.rds#DBCluster$MasterUsername
            "MasterUsername" -> builder.masterUsername = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBClusterOptionGroupMemberships com.amazonaws.rds#DBCluster$DBClusterOptionGroupMemberships
            "DBClusterOptionGroupMemberships" -> builder.dbClusterOptionGroupMemberships = deserializeDBClusterOptionGroupMembershipsShape(curr)
            // PreferredBackupWindow com.amazonaws.rds#DBCluster$PreferredBackupWindow
            "PreferredBackupWindow" -> builder.preferredBackupWindow = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // PreferredMaintenanceWindow com.amazonaws.rds#DBCluster$PreferredMaintenanceWindow
            "PreferredMaintenanceWindow" -> builder.preferredMaintenanceWindow = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // ReplicationSourceIdentifier com.amazonaws.rds#DBCluster$ReplicationSourceIdentifier
            "ReplicationSourceIdentifier" -> builder.replicationSourceIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // ReadReplicaIdentifiers com.amazonaws.rds#DBCluster$ReadReplicaIdentifiers
            "ReadReplicaIdentifiers" -> builder.readReplicaIdentifiers = deserializeReadReplicaIdentifierListShape(curr)
            // StatusInfos com.amazonaws.rds#DBCluster$StatusInfos
            "StatusInfos" -> builder.statusInfos = deserializeDBClusterStatusInfoListShape(curr)
            // DBClusterMembers com.amazonaws.rds#DBCluster$DBClusterMembers
            "DBClusterMembers" -> builder.dbClusterMembers = deserializeDBClusterMemberListShape(curr)
            // VpcSecurityGroups com.amazonaws.rds#DBCluster$VpcSecurityGroups
            "VpcSecurityGroups" -> builder.vpcSecurityGroups = deserializeVpcSecurityGroupMembershipListShape(curr)
            // HostedZoneId com.amazonaws.rds#DBCluster$HostedZoneId
            "HostedZoneId" -> builder.hostedZoneId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // StorageEncrypted com.amazonaws.rds#DBCluster$StorageEncrypted
            "StorageEncrypted" -> builder.storageEncrypted = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // KmsKeyId com.amazonaws.rds#DBCluster$KmsKeyId
            "KmsKeyId" -> builder.kmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DbClusterResourceId com.amazonaws.rds#DBCluster$DbClusterResourceId
            "DbClusterResourceId" -> builder.dbClusterResourceId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBClusterArn com.amazonaws.rds#DBCluster$DBClusterArn
            "DBClusterArn" -> builder.dbClusterArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // AssociatedRoles com.amazonaws.rds#DBCluster$AssociatedRoles
            "AssociatedRoles" -> builder.associatedRoles = deserializeDBClusterRolesShape(curr)
            // IAMDatabaseAuthenticationEnabled com.amazonaws.rds#DBCluster$IAMDatabaseAuthenticationEnabled
            "IAMDatabaseAuthenticationEnabled" -> builder.iamDatabaseAuthenticationEnabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#BooleanOptional`)" }
            // CloneGroupId com.amazonaws.rds#DBCluster$CloneGroupId
            "CloneGroupId" -> builder.cloneGroupId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // ClusterCreateTime com.amazonaws.rds#DBCluster$ClusterCreateTime
            "ClusterCreateTime" -> builder.clusterCreateTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // EarliestBacktrackTime com.amazonaws.rds#DBCluster$EarliestBacktrackTime
            "EarliestBacktrackTime" -> builder.earliestBacktrackTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // BacktrackWindow com.amazonaws.rds#DBCluster$BacktrackWindow
            "BacktrackWindow" -> builder.backtrackWindow = curr.tryData()
                .parseLong()
                .getOrDeserializeErr { "expected (long: `com.amazonaws.rds#LongOptional`)" }
            // BacktrackConsumedChangeRecords com.amazonaws.rds#DBCluster$BacktrackConsumedChangeRecords
            "BacktrackConsumedChangeRecords" -> builder.backtrackConsumedChangeRecords = curr.tryData()
                .parseLong()
                .getOrDeserializeErr { "expected (long: `com.amazonaws.rds#LongOptional`)" }
            // EnabledCloudwatchLogsExports com.amazonaws.rds#DBCluster$EnabledCloudwatchLogsExports
            "EnabledCloudwatchLogsExports" -> builder.enabledCloudwatchLogsExports = deserializeLogTypeListShape(curr)
            // Capacity com.amazonaws.rds#DBCluster$Capacity
            "Capacity" -> builder.capacity = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            // EngineMode com.amazonaws.rds#DBCluster$EngineMode
            "EngineMode" -> builder.engineMode = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // ScalingConfigurationInfo com.amazonaws.rds#DBCluster$ScalingConfigurationInfo
            "ScalingConfigurationInfo" -> builder.scalingConfigurationInfo = deserializeScalingConfigurationInfoDocument(curr)
            // RdsCustomClusterConfiguration com.amazonaws.rds#DBCluster$RdsCustomClusterConfiguration
            "RdsCustomClusterConfiguration" -> builder.rdsCustomClusterConfiguration = deserializeRdsCustomClusterConfigurationDocument(curr)
            // DeletionProtection com.amazonaws.rds#DBCluster$DeletionProtection
            "DeletionProtection" -> builder.deletionProtection = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#BooleanOptional`)" }
            // HttpEndpointEnabled com.amazonaws.rds#DBCluster$HttpEndpointEnabled
            "HttpEndpointEnabled" -> builder.httpEndpointEnabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#BooleanOptional`)" }
            // ActivityStreamMode com.amazonaws.rds#DBCluster$ActivityStreamMode
            "ActivityStreamMode" -> builder.activityStreamMode = curr.tryData()
                .parse { ActivityStreamMode.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.rds#ActivityStreamMode`)" }
            // ActivityStreamStatus com.amazonaws.rds#DBCluster$ActivityStreamStatus
            "ActivityStreamStatus" -> builder.activityStreamStatus = curr.tryData()
                .parse { ActivityStreamStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.rds#ActivityStreamStatus`)" }
            // ActivityStreamKmsKeyId com.amazonaws.rds#DBCluster$ActivityStreamKmsKeyId
            "ActivityStreamKmsKeyId" -> builder.activityStreamKmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // ActivityStreamKinesisStreamName com.amazonaws.rds#DBCluster$ActivityStreamKinesisStreamName
            "ActivityStreamKinesisStreamName" -> builder.activityStreamKinesisStreamName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // CopyTagsToSnapshot com.amazonaws.rds#DBCluster$CopyTagsToSnapshot
            "CopyTagsToSnapshot" -> builder.copyTagsToSnapshot = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#BooleanOptional`)" }
            // CrossAccountClone com.amazonaws.rds#DBCluster$CrossAccountClone
            "CrossAccountClone" -> builder.crossAccountClone = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#BooleanOptional`)" }
            // DomainMemberships com.amazonaws.rds#DBCluster$DomainMemberships
            "DomainMemberships" -> builder.domainMemberships = deserializeDomainMembershipListShape(curr)
            // TagList com.amazonaws.rds#DBCluster$TagList
            "TagList" -> builder.tagList = deserializeTagListShape(curr)
            // GlobalWriteForwardingStatus com.amazonaws.rds#DBCluster$GlobalWriteForwardingStatus
            "GlobalWriteForwardingStatus" -> builder.globalWriteForwardingStatus = curr.tryData()
                .parse { WriteForwardingStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.rds#WriteForwardingStatus`)" }
            // GlobalWriteForwardingRequested com.amazonaws.rds#DBCluster$GlobalWriteForwardingRequested
            "GlobalWriteForwardingRequested" -> builder.globalWriteForwardingRequested = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#BooleanOptional`)" }
            // PendingModifiedValues com.amazonaws.rds#DBCluster$PendingModifiedValues
            "PendingModifiedValues" -> builder.pendingModifiedValues = deserializeClusterPendingModifiedValuesDocument(curr)
            // DBClusterInstanceClass com.amazonaws.rds#DBCluster$DBClusterInstanceClass
            "DBClusterInstanceClass" -> builder.dbClusterInstanceClass = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // StorageType com.amazonaws.rds#DBCluster$StorageType
            "StorageType" -> builder.storageType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Iops com.amazonaws.rds#DBCluster$Iops
            "Iops" -> builder.iops = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            // PubliclyAccessible com.amazonaws.rds#DBCluster$PubliclyAccessible
            "PubliclyAccessible" -> builder.publiclyAccessible = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#BooleanOptional`)" }
            // AutoMinorVersionUpgrade com.amazonaws.rds#DBCluster$AutoMinorVersionUpgrade
            "AutoMinorVersionUpgrade" -> builder.autoMinorVersionUpgrade = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#Boolean`)" }
            // MonitoringInterval com.amazonaws.rds#DBCluster$MonitoringInterval
            "MonitoringInterval" -> builder.monitoringInterval = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            // MonitoringRoleArn com.amazonaws.rds#DBCluster$MonitoringRoleArn
            "MonitoringRoleArn" -> builder.monitoringRoleArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // PerformanceInsightsEnabled com.amazonaws.rds#DBCluster$PerformanceInsightsEnabled
            "PerformanceInsightsEnabled" -> builder.performanceInsightsEnabled = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#BooleanOptional`)" }
            // PerformanceInsightsKMSKeyId com.amazonaws.rds#DBCluster$PerformanceInsightsKMSKeyId
            "PerformanceInsightsKMSKeyId" -> builder.performanceInsightsKmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // PerformanceInsightsRetentionPeriod com.amazonaws.rds#DBCluster$PerformanceInsightsRetentionPeriod
            "PerformanceInsightsRetentionPeriod" -> builder.performanceInsightsRetentionPeriod = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            // ServerlessV2ScalingConfiguration com.amazonaws.rds#DBCluster$ServerlessV2ScalingConfiguration
            "ServerlessV2ScalingConfiguration" -> builder.serverlessV2ScalingConfiguration = deserializeServerlessV2ScalingConfigurationInfoDocument(curr)
            // NetworkType com.amazonaws.rds#DBCluster$NetworkType
            "NetworkType" -> builder.networkType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBSystemId com.amazonaws.rds#DBCluster$DBSystemId
            "DBSystemId" -> builder.dbSystemId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // MasterUserSecret com.amazonaws.rds#DBCluster$MasterUserSecret
            "MasterUserSecret" -> builder.masterUserSecret = deserializeMasterUserSecretDocument(curr)
            // IOOptimizedNextAllowedModificationTime com.amazonaws.rds#DBCluster$IOOptimizedNextAllowedModificationTime
            "IOOptimizedNextAllowedModificationTime" -> builder.ioOptimizedNextAllowedModificationTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // LocalWriteForwardingStatus com.amazonaws.rds#DBCluster$LocalWriteForwardingStatus
            "LocalWriteForwardingStatus" -> builder.localWriteForwardingStatus = curr.tryData()
                .parse { LocalWriteForwardingStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.rds#LocalWriteForwardingStatus`)" }
            // AwsBackupRecoveryPointArn com.amazonaws.rds#DBCluster$AwsBackupRecoveryPointArn
            "AwsBackupRecoveryPointArn" -> builder.awsBackupRecoveryPointArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // LimitlessDatabase com.amazonaws.rds#DBCluster$LimitlessDatabase
            "LimitlessDatabase" -> builder.limitlessDatabase = deserializeLimitlessDatabaseDocument(curr)
            // StorageThroughput com.amazonaws.rds#DBCluster$StorageThroughput
            "StorageThroughput" -> builder.storageThroughput = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            // CertificateDetails com.amazonaws.rds#DBCluster$CertificateDetails
            "CertificateDetails" -> builder.certificateDetails = deserializeCertificateDetailsDocument(curr)
            // EngineLifecycleSupport com.amazonaws.rds#DBCluster$EngineLifecycleSupport
            "EngineLifecycleSupport" -> builder.engineLifecycleSupport = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
