// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.CreateIntegrationResponse
import aws.sdk.kotlin.services.rds.model.IntegrationError
import aws.sdk.kotlin.services.rds.model.IntegrationStatus
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.sdk.kotlin.services.rds.model.Tag
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class CreateIntegrationOperationDeserializer: HttpDeserializer.NonStreaming<CreateIntegrationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateIntegrationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateIntegrationError(context, call, payload)
        }
        val builder = CreateIntegrationResponse.Builder()

        if (payload != null) {
            deserializeCreateIntegrationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateIntegrationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBInstanceNotFound" -> DbInstanceNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "IntegrationQuotaExceededFault" -> IntegrationQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "KMSKeyNotAccessibleFault" -> KmsKeyNotAccessibleFaultDeserializer().deserialize(context, wrappedCall, payload)
        "IntegrationConflictOperationFault" -> IntegrationConflictOperationFaultDeserializer().deserialize(context, wrappedCall, payload)
        "IntegrationAlreadyExistsFault" -> IntegrationAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateIntegrationOperationBody(builder: CreateIntegrationResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateIntegration")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // AdditionalEncryptionContext com.amazonaws.rds#Integration$AdditionalEncryptionContext
            "AdditionalEncryptionContext" -> builder.additionalEncryptionContext = deserializeEncryptionContextMapShape(curr)
            // CreateTime com.amazonaws.rds#Integration$CreateTime
            "CreateTime" -> builder.createTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // DataFilter com.amazonaws.rds#Integration$DataFilter
            "DataFilter" -> builder.dataFilter = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#DataFilter`)" }
            // Description com.amazonaws.rds#Integration$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#IntegrationDescription`)" }
            // Errors com.amazonaws.rds#Integration$Errors
            "Errors" -> builder.errors = deserializeIntegrationErrorListShape(curr)
            // IntegrationArn com.amazonaws.rds#Integration$IntegrationArn
            "IntegrationArn" -> builder.integrationArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#IntegrationArn`)" }
            // IntegrationName com.amazonaws.rds#Integration$IntegrationName
            "IntegrationName" -> builder.integrationName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#IntegrationName`)" }
            // KMSKeyId com.amazonaws.rds#Integration$KMSKeyId
            "KMSKeyId" -> builder.kmsKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // SourceArn com.amazonaws.rds#Integration$SourceArn
            "SourceArn" -> builder.sourceArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#SourceArn`)" }
            // Status com.amazonaws.rds#Integration$Status
            "Status" -> builder.status = curr.tryData()
                .parse { IntegrationStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.rds#IntegrationStatus`)" }
            // Tags com.amazonaws.rds#Integration$Tags
            "Tags" -> builder.tags = deserializeTagListShape(curr)
            // TargetArn com.amazonaws.rds#Integration$TargetArn
            "TargetArn" -> builder.targetArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#Arn`)" }
            else -> {}
        }
        curr.drop()
    }
}
