// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.CreateEventSubscriptionResponse
import aws.sdk.kotlin.services.rds.model.EventSubscription
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateEventSubscriptionOperationDeserializer: HttpDeserializer.NonStreaming<CreateEventSubscriptionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateEventSubscriptionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateEventSubscriptionError(context, call, payload)
        }
        val builder = CreateEventSubscriptionResponse.Builder()

        if (payload != null) {
            deserializeCreateEventSubscriptionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateEventSubscriptionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "SNSInvalidTopic" -> SnsInvalidTopicFaultDeserializer().deserialize(context, wrappedCall, payload)
        "SubscriptionCategoryNotFound" -> SubscriptionCategoryNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "SourceNotFound" -> SourceNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "SNSNoAuthorization" -> SnsNoAuthorizationFaultDeserializer().deserialize(context, wrappedCall, payload)
        "SNSTopicArnNotFound" -> SnsTopicArnNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "SubscriptionAlreadyExist" -> SubscriptionAlreadyExistFaultDeserializer().deserialize(context, wrappedCall, payload)
        "EventSubscriptionQuotaExceeded" -> EventSubscriptionQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateEventSubscriptionOperationBody(builder: CreateEventSubscriptionResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateEventSubscription")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // EventSubscription com.amazonaws.rds#CreateEventSubscriptionResult$EventSubscription
            "EventSubscription" -> builder.eventSubscription = deserializeEventSubscriptionDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
