// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.CreateDbShardGroupResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseDouble
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateDBShardGroupOperationDeserializer: HttpDeserializer.NonStreaming<CreateDbShardGroupResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateDbShardGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateDbShardGroupError(context, call, payload)
        }
        val builder = CreateDbShardGroupResponse.Builder()

        if (payload != null) {
            deserializeCreateDBShardGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateDbShardGroupError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "MaxDBShardGroupLimitReached" -> MaxDbShardGroupLimitReachedDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedDBEngineVersion" -> UnsupportedDbEngineVersionFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBShardGroupAlreadyExists" -> DbShardGroupAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidVPCNetworkStateFault" -> InvalidVpcNetworkStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidMaxAcu" -> InvalidMaxAcuFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateDBShardGroupOperationBody(builder: CreateDbShardGroupResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateDBShardGroup")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ComputeRedundancy com.amazonaws.rds#DBShardGroup$ComputeRedundancy
            "ComputeRedundancy" -> builder.computeRedundancy = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.rds#IntegerOptional`)" }
            // DBClusterIdentifier com.amazonaws.rds#DBShardGroup$DBClusterIdentifier
            "DBClusterIdentifier" -> builder.dbClusterIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // DBShardGroupIdentifier com.amazonaws.rds#DBShardGroup$DBShardGroupIdentifier
            "DBShardGroupIdentifier" -> builder.dbShardGroupIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#DBShardGroupIdentifier`)" }
            // DBShardGroupResourceId com.amazonaws.rds#DBShardGroup$DBShardGroupResourceId
            "DBShardGroupResourceId" -> builder.dbShardGroupResourceId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Endpoint com.amazonaws.rds#DBShardGroup$Endpoint
            "Endpoint" -> builder.endpoint = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // MaxACU com.amazonaws.rds#DBShardGroup$MaxACU
            "MaxACU" -> builder.maxAcu = curr.tryData()
                .parseDouble()
                .getOrDeserializeErr { "expected (double: `com.amazonaws.rds#DoubleOptional`)" }
            // PubliclyAccessible com.amazonaws.rds#DBShardGroup$PubliclyAccessible
            "PubliclyAccessible" -> builder.publiclyAccessible = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#BooleanOptional`)" }
            // Status com.amazonaws.rds#DBShardGroup$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            else -> {}
        }
        curr.drop()
    }
}
