// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.CopyDbClusterParameterGroupResponse
import aws.sdk.kotlin.services.rds.model.DbClusterParameterGroup
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CopyDBClusterParameterGroupOperationDeserializer: HttpDeserializer.NonStreaming<CopyDbClusterParameterGroupResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CopyDbClusterParameterGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCopyDbClusterParameterGroupError(context, call, payload)
        }
        val builder = CopyDbClusterParameterGroupResponse.Builder()

        if (payload != null) {
            deserializeCopyDBClusterParameterGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCopyDbClusterParameterGroupError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBParameterGroupAlreadyExists" -> DbParameterGroupAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBParameterGroupQuotaExceeded" -> DbParameterGroupQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DBParameterGroupNotFound" -> DbParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCopyDBClusterParameterGroupOperationBody(builder: CopyDbClusterParameterGroupResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CopyDBClusterParameterGroup")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DBClusterParameterGroup com.amazonaws.rds#CopyDBClusterParameterGroupResult$DBClusterParameterGroup
            "DBClusterParameterGroup" -> builder.dbClusterParameterGroup = deserializeDbClusterParameterGroupDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
