// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.Certificate
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeCertificateDocument(reader: XmlTagReader): Certificate {
    val builder = Certificate.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // CertificateIdentifier com.amazonaws.rds#Certificate$CertificateIdentifier
            "CertificateIdentifier" -> builder.certificateIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // CertificateType com.amazonaws.rds#Certificate$CertificateType
            "CertificateType" -> builder.certificateType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Thumbprint com.amazonaws.rds#Certificate$Thumbprint
            "Thumbprint" -> builder.thumbprint = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // ValidFrom com.amazonaws.rds#Certificate$ValidFrom
            "ValidFrom" -> builder.validFrom = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // ValidTill com.amazonaws.rds#Certificate$ValidTill
            "ValidTill" -> builder.validTill = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // CertificateArn com.amazonaws.rds#Certificate$CertificateArn
            "CertificateArn" -> builder.certificateArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // CustomerOverride com.amazonaws.rds#Certificate$CustomerOverride
            "CustomerOverride" -> builder.customerOverride = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.rds#BooleanOptional`)" }
            // CustomerOverrideValidTill com.amazonaws.rds#Certificate$CustomerOverrideValidTill
            "CustomerOverrideValidTill" -> builder.customerOverrideValidTill = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
