// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.BacktrackDbClusterResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class BacktrackDBClusterOperationDeserializer: HttpDeserializer.NonStreaming<BacktrackDbClusterResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): BacktrackDbClusterResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBacktrackDbClusterError(context, call, payload)
        }
        val builder = BacktrackDbClusterResponse.Builder()

        if (payload != null) {
            deserializeBacktrackDBClusterOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwBacktrackDbClusterError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBacktrackDBClusterOperationBody(builder: BacktrackDbClusterResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "BacktrackDBCluster")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // BacktrackIdentifier com.amazonaws.rds#DBClusterBacktrack$BacktrackIdentifier
            "BacktrackIdentifier" -> builder.backtrackIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // BacktrackRequestCreationTime com.amazonaws.rds#DBClusterBacktrack$BacktrackRequestCreationTime
            "BacktrackRequestCreationTime" -> builder.backtrackRequestCreationTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // BacktrackTo com.amazonaws.rds#DBClusterBacktrack$BacktrackTo
            "BacktrackTo" -> builder.backtrackTo = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // BacktrackedFrom com.amazonaws.rds#DBClusterBacktrack$BacktrackedFrom
            "BacktrackedFrom" -> builder.backtrackedFrom = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.rds#TStamp`)" }
            // DBClusterIdentifier com.amazonaws.rds#DBClusterBacktrack$DBClusterIdentifier
            "DBClusterIdentifier" -> builder.dbClusterIdentifier = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            // Status com.amazonaws.rds#DBClusterBacktrack$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.rds#String`)" }
            else -> {}
        }
        curr.drop()
    }
}
