// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.AddSourceIdentifierToSubscriptionResponse
import aws.sdk.kotlin.services.rds.model.EventSubscription
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class AddSourceIdentifierToSubscriptionOperationDeserializer: HttpDeserializer.NonStreaming<AddSourceIdentifierToSubscriptionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): AddSourceIdentifierToSubscriptionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAddSourceIdentifierToSubscriptionError(context, call, payload)
        }
        val builder = AddSourceIdentifierToSubscriptionResponse.Builder()

        if (payload != null) {
            deserializeAddSourceIdentifierToSubscriptionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwAddSourceIdentifierToSubscriptionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "SubscriptionNotFound" -> SubscriptionNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "SourceNotFound" -> SourceNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAddSourceIdentifierToSubscriptionOperationBody(builder: AddSourceIdentifierToSubscriptionResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "AddSourceIdentifierToSubscription")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // EventSubscription com.amazonaws.rds#AddSourceIdentifierToSubscriptionResult$EventSubscription
            "EventSubscription" -> builder.eventSubscription = deserializeEventSubscriptionDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
