// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The version of the database engine that a DB instance can be upgraded to.
 */
public class UpgradeTarget private constructor(builder: Builder) {
    /**
     * Indicates whether the target version is applied to any source DB instances that have `AutoMinorVersionUpgrade` set to true.
     *
     * This parameter is dynamic, and is set by RDS.
     */
    public val autoUpgrade: kotlin.Boolean? = builder.autoUpgrade
    /**
     * The version of the database engine that a DB instance can be upgraded to.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the upgrade target database engine.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The version number of the upgrade target database engine.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * Indicates whether upgrading to the target version requires upgrading the major version of the database engine.
     */
    public val isMajorVersionUpgrade: kotlin.Boolean? = builder.isMajorVersionUpgrade
    /**
     * A list of the supported DB engine modes for the target engine version.
     */
    public val supportedEngineModes: List<String>? = builder.supportedEngineModes
    /**
     * Indicates whether you can use Babelfish for Aurora PostgreSQL with the target engine version.
     */
    public val supportsBabelfish: kotlin.Boolean? = builder.supportsBabelfish
    /**
     * Indicates whether you can use Aurora global databases with the target engine version.
     */
    public val supportsGlobalDatabases: kotlin.Boolean? = builder.supportsGlobalDatabases
    /**
     * Indicates whether the DB engine version supports zero-ETL integrations with Amazon Redshift.
     */
    public val supportsIntegrations: kotlin.Boolean? = builder.supportsIntegrations
    /**
     * Indicates whether the DB engine version supports Aurora Limitless Database.
     */
    public val supportsLimitlessDatabase: kotlin.Boolean? = builder.supportsLimitlessDatabase
    /**
     * Indicates whether the target engine version supports forwarding write operations from reader DB instances to the writer DB instance in the DB cluster. By default, write operations aren't allowed on reader DB instances.
     *
     * Valid for: Aurora DB clusters only
     */
    public val supportsLocalWriteForwarding: kotlin.Boolean? = builder.supportsLocalWriteForwarding
    /**
     * Indicates whether you can use Aurora parallel query with the target engine version.
     */
    public val supportsParallelQuery: kotlin.Boolean? = builder.supportsParallelQuery

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.UpgradeTarget = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpgradeTarget(")
        append("autoUpgrade=$autoUpgrade,")
        append("description=$description,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("isMajorVersionUpgrade=$isMajorVersionUpgrade,")
        append("supportedEngineModes=$supportedEngineModes,")
        append("supportsBabelfish=$supportsBabelfish,")
        append("supportsGlobalDatabases=$supportsGlobalDatabases,")
        append("supportsIntegrations=$supportsIntegrations,")
        append("supportsLimitlessDatabase=$supportsLimitlessDatabase,")
        append("supportsLocalWriteForwarding=$supportsLocalWriteForwarding,")
        append("supportsParallelQuery=$supportsParallelQuery")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoUpgrade?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (isMajorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (supportedEngineModes?.hashCode() ?: 0)
        result = 31 * result + (supportsBabelfish?.hashCode() ?: 0)
        result = 31 * result + (supportsGlobalDatabases?.hashCode() ?: 0)
        result = 31 * result + (supportsIntegrations?.hashCode() ?: 0)
        result = 31 * result + (supportsLimitlessDatabase?.hashCode() ?: 0)
        result = 31 * result + (supportsLocalWriteForwarding?.hashCode() ?: 0)
        result = 31 * result + (supportsParallelQuery?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpgradeTarget

        if (autoUpgrade != other.autoUpgrade) return false
        if (description != other.description) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (isMajorVersionUpgrade != other.isMajorVersionUpgrade) return false
        if (supportedEngineModes != other.supportedEngineModes) return false
        if (supportsBabelfish != other.supportsBabelfish) return false
        if (supportsGlobalDatabases != other.supportsGlobalDatabases) return false
        if (supportsIntegrations != other.supportsIntegrations) return false
        if (supportsLimitlessDatabase != other.supportsLimitlessDatabase) return false
        if (supportsLocalWriteForwarding != other.supportsLocalWriteForwarding) return false
        if (supportsParallelQuery != other.supportsParallelQuery) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.UpgradeTarget = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether the target version is applied to any source DB instances that have `AutoMinorVersionUpgrade` set to true.
         *
         * This parameter is dynamic, and is set by RDS.
         */
        public var autoUpgrade: kotlin.Boolean? = null
        /**
         * The version of the database engine that a DB instance can be upgraded to.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the upgrade target database engine.
         */
        public var engine: kotlin.String? = null
        /**
         * The version number of the upgrade target database engine.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * Indicates whether upgrading to the target version requires upgrading the major version of the database engine.
         */
        public var isMajorVersionUpgrade: kotlin.Boolean? = null
        /**
         * A list of the supported DB engine modes for the target engine version.
         */
        public var supportedEngineModes: List<String>? = null
        /**
         * Indicates whether you can use Babelfish for Aurora PostgreSQL with the target engine version.
         */
        public var supportsBabelfish: kotlin.Boolean? = null
        /**
         * Indicates whether you can use Aurora global databases with the target engine version.
         */
        public var supportsGlobalDatabases: kotlin.Boolean? = null
        /**
         * Indicates whether the DB engine version supports zero-ETL integrations with Amazon Redshift.
         */
        public var supportsIntegrations: kotlin.Boolean? = null
        /**
         * Indicates whether the DB engine version supports Aurora Limitless Database.
         */
        public var supportsLimitlessDatabase: kotlin.Boolean? = null
        /**
         * Indicates whether the target engine version supports forwarding write operations from reader DB instances to the writer DB instance in the DB cluster. By default, write operations aren't allowed on reader DB instances.
         *
         * Valid for: Aurora DB clusters only
         */
        public var supportsLocalWriteForwarding: kotlin.Boolean? = null
        /**
         * Indicates whether you can use Aurora parallel query with the target engine version.
         */
        public var supportsParallelQuery: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.UpgradeTarget) : this() {
            this.autoUpgrade = x.autoUpgrade
            this.description = x.description
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.isMajorVersionUpgrade = x.isMajorVersionUpgrade
            this.supportedEngineModes = x.supportedEngineModes
            this.supportsBabelfish = x.supportsBabelfish
            this.supportsGlobalDatabases = x.supportsGlobalDatabases
            this.supportsIntegrations = x.supportsIntegrations
            this.supportsLimitlessDatabase = x.supportsLimitlessDatabase
            this.supportsLocalWriteForwarding = x.supportsLocalWriteForwarding
            this.supportsParallelQuery = x.supportsParallelQuery
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.UpgradeTarget = UpgradeTarget(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
