// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartDbInstanceAutomatedBackupsReplicationRequest private constructor(builder: Builder) {
    /**
     * The retention period for the replicated automated backups.
     */
    public val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * The Amazon Web Services KMS key identifier for encryption of the replicated automated backups. The KMS key ID is the Amazon Resource Name (ARN) for the KMS encryption key in the destination Amazon Web Services Region, for example, `arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE`.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * In an Amazon Web Services GovCloud (US) Region, an URL that contains a Signature Version 4 signed request for the `StartDBInstanceAutomatedBackupsReplication` operation to call in the Amazon Web Services Region of the source DB instance. The presigned URL must be a valid request for the `StartDBInstanceAutomatedBackupsReplication` API operation that can run in the Amazon Web Services Region that contains the source DB instance.
     *
     * This setting applies only to Amazon Web Services GovCloud (US) Regions. It's ignored in other Amazon Web Services Regions.
     *
     * To learn how to generate a Signature Version 4 signed request, see [ Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)](https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html) and [ Signature Version 4 Signing Process](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
     *
     * If you are using an Amazon Web Services SDK tool or the CLI, you can specify `SourceRegion` (or `--source-region` for the CLI) instead of specifying `PreSignedUrl` manually. Specifying `SourceRegion` autogenerates a presigned URL that is a valid request for the operation that can run in the source Amazon Web Services Region.
     */
    public val preSignedUrl: kotlin.String? = builder.preSignedUrl
    /**
     * The Amazon Resource Name (ARN) of the source DB instance for the replicated automated backups, for example, `arn:aws:rds:us-west-2:123456789012:db:mydatabase`.
     */
    public val sourceDbInstanceArn: kotlin.String? = builder.sourceDbInstanceArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartDbInstanceAutomatedBackupsReplicationRequest(")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("kmsKeyId=$kmsKeyId,")
        append("preSignedUrl=$preSignedUrl,")
        append("sourceDbInstanceArn=$sourceDbInstanceArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupRetentionPeriod ?: 0
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (preSignedUrl?.hashCode() ?: 0)
        result = 31 * result + (sourceDbInstanceArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartDbInstanceAutomatedBackupsReplicationRequest

        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (preSignedUrl != other.preSignedUrl) return false
        if (sourceDbInstanceArn != other.sourceDbInstanceArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The retention period for the replicated automated backups.
         */
        public var backupRetentionPeriod: kotlin.Int? = null
        /**
         * The Amazon Web Services KMS key identifier for encryption of the replicated automated backups. The KMS key ID is the Amazon Resource Name (ARN) for the KMS encryption key in the destination Amazon Web Services Region, for example, `arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE`.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * In an Amazon Web Services GovCloud (US) Region, an URL that contains a Signature Version 4 signed request for the `StartDBInstanceAutomatedBackupsReplication` operation to call in the Amazon Web Services Region of the source DB instance. The presigned URL must be a valid request for the `StartDBInstanceAutomatedBackupsReplication` API operation that can run in the Amazon Web Services Region that contains the source DB instance.
         *
         * This setting applies only to Amazon Web Services GovCloud (US) Regions. It's ignored in other Amazon Web Services Regions.
         *
         * To learn how to generate a Signature Version 4 signed request, see [ Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)](https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html) and [ Signature Version 4 Signing Process](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
         *
         * If you are using an Amazon Web Services SDK tool or the CLI, you can specify `SourceRegion` (or `--source-region` for the CLI) instead of specifying `PreSignedUrl` manually. Specifying `SourceRegion` autogenerates a presigned URL that is a valid request for the operation that can run in the source Amazon Web Services Region.
         */
        public var preSignedUrl: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the source DB instance for the replicated automated backups, for example, `arn:aws:rds:us-west-2:123456789012:db:mydatabase`.
         */
        public var sourceDbInstanceArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest) : this() {
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.kmsKeyId = x.kmsKeyId
            this.preSignedUrl = x.preSignedUrl
            this.sourceDbInstanceArn = x.sourceDbInstanceArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest = StartDbInstanceAutomatedBackupsReplicationRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
