// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 *
 */
public class RestoreDbInstanceFromDbSnapshotRequest private constructor(builder: Builder) {
    /**
     * The amount of storage (in gibibytes) to allocate initially for the DB instance. Follow the allocation rules specified in CreateDBInstance.
     *
     * Be sure to allocate enough storage for your new DB instance so that the restore operation can succeed. You can also allocate additional storage for future growth.
     */
    public val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * Specifies whether to automatically apply minor version upgrades to the DB instance during the maintenance window.
     *
     * If you restore an RDS Custom DB instance, you must disable this parameter.
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * The Availability Zone (AZ) where the DB instance will be created.
     *
     * Default: A random, system-chosen Availability Zone.
     *
     * Constraint: You can't specify the `AvailabilityZone` parameter if the DB instance is a Multi-AZ deployment.
     *
     * Example: `us-east-1a`
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * Specifies where automated backups and manual snapshots are stored for the restored DB instance.
     *
     * Possible values are `outposts` (Amazon Web Services Outposts) and `region` (Amazon Web Services Region). The default is `region`.
     *
     * For more information, see [Working with Amazon RDS on Amazon Web Services Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html) in the *Amazon RDS User Guide*.
     */
    public val backupTarget: kotlin.String? = builder.backupTarget
    /**
     * The CA certificate identifier to use for the DB instance's server certificate.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     *
     * For more information, see [Using SSL/TLS to encrypt a connection to a DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html) in the *Amazon RDS User Guide* and [ Using SSL/TLS to encrypt a connection to a DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html) in the *Amazon Aurora User Guide*.
     */
    public val caCertificateIdentifier: kotlin.String? = builder.caCertificateIdentifier
    /**
     * Specifies whether to copy all tags from the restored DB instance to snapshots of the DB instance.
     *
     * In most cases, tags aren't copied by default. However, when you restore a DB instance from a DB snapshot, RDS checks whether you specify new tags. If yes, the new tags are added to the restored DB instance. If there are no new tags, RDS looks for the tags from the source DB instance for the DB snapshot, and then adds those tags to the restored DB instance.
     *
     * For more information, see [ Copying tags to DB instance snapshots](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.CopyTags) in the *Amazon RDS User Guide*.
     */
    public val copyTagsToSnapshot: kotlin.Boolean? = builder.copyTagsToSnapshot
    /**
     * The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance. The instance profile must meet the following requirements:
     * + The profile must exist in your account.
     * + The profile must have an IAM role that Amazon EC2 has permissions to assume.
     * + The instance profile name and the associated IAM role name must start with the prefix `AWSRDSCustom`.
     *
     * For the list of permissions required for the IAM role, see [ Configure IAM and your VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc) in the *Amazon RDS User Guide*.
     *
     * This setting is required for RDS Custom.
     */
    public val customIamInstanceProfile: kotlin.String? = builder.customIamInstanceProfile
    /**
     * The identifier for the Multi-AZ DB cluster snapshot to restore from.
     *
     * For more information on Multi-AZ DB clusters, see [ Multi-AZ DB cluster deployments](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide*.
     *
     * Constraints:
     * + Must match the identifier of an existing Multi-AZ DB cluster snapshot.
     * + Can't be specified when `DBSnapshotIdentifier` is specified.
     * + Must be specified when `DBSnapshotIdentifier` isn't specified.
     * + If you are restoring from a shared manual Multi-AZ DB cluster snapshot, the `DBClusterSnapshotIdentifier` must be the ARN of the shared snapshot.
     * + Can't be the identifier of an Aurora DB cluster snapshot.
     */
    public val dbClusterSnapshotIdentifier: kotlin.String? = builder.dbClusterSnapshotIdentifier
    /**
     * The compute and memory capacity of the Amazon RDS DB instance, for example db.m4.large. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see [DB Instance Class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the *Amazon RDS User Guide.*
     *
     * Default: The same DBInstanceClass as the original DB instance.
     */
    public val dbInstanceClass: kotlin.String? = builder.dbInstanceClass
    /**
     * The name of the DB instance to create from the DB snapshot. This parameter isn't case-sensitive.
     *
     * Constraints:
     * + Must contain from 1 to 63 numbers, letters, or hyphens.
     * + First character must be a letter.
     * + Can't end with a hyphen or contain two consecutive hyphens.
     *
     * Example: `my-snapshot-id`
     */
    public val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * The name of the database for the restored DB instance.
     *
     * This parameter only applies to RDS for Oracle and RDS for SQL Server DB instances. It doesn't apply to the other engines or to RDS Custom DB instances.
     */
    public val dbName: kotlin.String? = builder.dbName
    /**
     * The name of the DB parameter group to associate with this DB instance.
     *
     * If you don't specify a value for `DBParameterGroupName`, then RDS uses the default `DBParameterGroup` for the specified DB engine.
     *
     * This setting doesn't apply to RDS Custom.
     *
     * Constraints:
     * + If supplied, must match the name of an existing DB parameter group.
     * + Must be 1 to 255 letters, numbers, or hyphens.
     * + First character must be a letter.
     * + Can't end with a hyphen or contain two consecutive hyphens.
     */
    public val dbParameterGroupName: kotlin.String? = builder.dbParameterGroupName
    /**
     * The identifier for the DB snapshot to restore from.
     *
     * Constraints:
     * + Must match the identifier of an existing DB snapshot.
     * + Can't be specified when `DBClusterSnapshotIdentifier` is specified.
     * + Must be specified when `DBClusterSnapshotIdentifier` isn't specified.
     * + If you are restoring from a shared manual DB snapshot, the `DBSnapshotIdentifier` must be the ARN of the shared DB snapshot.
     */
    public val dbSnapshotIdentifier: kotlin.String? = builder.dbSnapshotIdentifier
    /**
     * The name of the DB subnet group to use for the new instance.
     *
     * Constraints:
     * + If supplied, must match the name of an existing DB subnet group.
     *
     * Example: `mydbsubnetgroup`
     */
    public val dbSubnetGroupName: kotlin.String? = builder.dbSubnetGroupName
    /**
     * Specifies whether to enable a dedicated log volume (DLV) for the DB instance.
     */
    public val dedicatedLogVolume: kotlin.Boolean? = builder.dedicatedLogVolume
    /**
     * Specifies whether to enable deletion protection for the DB instance. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see [ Deleting a DB Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The Active Directory directory ID to restore the DB instance in. The domain/ must be created prior to this operation. Currently, you can create only Db2, MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances in an Active Directory Domain.
     *
     * For more information, see [ Kerberos Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html) in the *Amazon RDS User Guide*.
     *
     * This setting doesn't apply to RDS Custom.
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * The ARN for the Secrets Manager secret with the credentials for the user joining the domain.
     *
     * Constraints:
     * + Can't be longer than 64 characters.
     *
     * Example: `arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456`
     */
    public val domainAuthSecretArn: kotlin.String? = builder.domainAuthSecretArn
    /**
     * The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.
     *
     * Constraints:
     * + Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of the primary domain controller for both entries in the list.
     *
     * Example: `123.124.125.126,234.235.236.237`
     */
    public val domainDnsIps: List<String>? = builder.domainDnsIps
    /**
     * The fully qualified domain name (FQDN) of an Active Directory domain.
     *
     * Constraints:
     * + Can't be longer than 64 characters.
     *
     * Example: `mymanagedADtest.mymanagedAD.mydomain`
     */
    public val domainFqdn: kotlin.String? = builder.domainFqdn
    /**
     * The name of the IAM role to use when making API calls to the Directory Service.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val domainIamRoleName: kotlin.String? = builder.domainIamRoleName
    /**
     * The Active Directory organizational unit for your DB instance to join.
     *
     * Constraints:
     * + Must be in the distinguished name format.
     * + Can't be longer than 64 characters.
     *
     * Example: `OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain`
     */
    public val domainOu: kotlin.String? = builder.domainOu
    /**
     * The list of logs for the restored DB instance to export to CloudWatch Logs. The values in the list depend on the DB engine. For more information, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon RDS User Guide*.
     *
     * This setting doesn't apply to RDS Custom.
     */
    public val enableCloudwatchLogsExports: List<String>? = builder.enableCloudwatchLogsExports
    /**
     * Specifies whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance.
     *
     * A *CoIP* provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from outside of its virtual private cloud (VPC) on your local network.
     *
     * This setting doesn't apply to RDS Custom.
     *
     * For more information about RDS on Outposts, see [Working with Amazon RDS on Amazon Web Services Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html) in the *Amazon RDS User Guide*.
     *
     * For more information about CoIPs, see [Customer-owned IP addresses](https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing) in the *Amazon Web Services Outposts User Guide*.
     */
    public val enableCustomerOwnedIp: kotlin.Boolean? = builder.enableCustomerOwnedIp
    /**
     * Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.
     *
     * For more information about IAM database authentication, see [ IAM Database Authentication for MySQL and PostgreSQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html) in the *Amazon RDS User Guide.*
     *
     * This setting doesn't apply to RDS Custom.
     */
    public val enableIamDatabaseAuthentication: kotlin.Boolean? = builder.enableIamDatabaseAuthentication
    /**
     * The database engine to use for the new instance.
     *
     * This setting doesn't apply to RDS Custom.
     *
     * Default: The same as source
     *
     * Constraint: Must be compatible with the engine of the source. For example, you can restore a MariaDB 10.1 DB instance from a MySQL 5.6 snapshot.
     *
     * Valid Values:
     * + `db2-ae`
     * + `db2-se`
     * + `mariadb`
     * + `mysql`
     * + `oracle-ee`
     * + `oracle-ee-cdb`
     * + `oracle-se2`
     * + `oracle-se2-cdb`
     * + `postgres`
     * + `sqlserver-ee`
     * + `sqlserver-se`
     * + `sqlserver-ex`
     * + `sqlserver-web`
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The life cycle type for this DB instance.
     *
     * By default, this value is set to `open-source-rds-extended-support`, which enrolls your DB instance into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to `open-source-rds-extended-support-disabled`. In this case, RDS automatically upgrades your restored DB instance to a higher engine version, if the major engine version is past its end of standard support date.
     *
     * You can use this setting to enroll your DB instance into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your DB instance past the end of standard support for that engine version. For more information, see [Using Amazon RDS Extended Support](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html) in the *Amazon RDS User Guide*.
     *
     * This setting applies only to RDS for MySQL and RDS for PostgreSQL. For Amazon Aurora DB instances, the life cycle type is managed by the DB cluster.
     *
     * Valid Values: `open-source-rds-extended-support | open-source-rds-extended-support-disabled`
     *
     * Default: `open-source-rds-extended-support`
     */
    public val engineLifecycleSupport: kotlin.String? = builder.engineLifecycleSupport
    /**
     * Specifies the amount of provisioned IOPS for the DB instance, expressed in I/O operations per second. If this parameter isn't specified, the IOPS value is taken from the backup. If this parameter is set to 0, the new instance is converted to a non-PIOPS instance. The conversion takes additional time, though your DB instance is available for connections before the conversion starts.
     *
     * The provisioned IOPS value must follow the requirements for your database engine. For more information, see [Amazon RDS Provisioned IOPS storage](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS) in the *Amazon RDS User Guide.*
     *
     * Constraints: Must be an integer greater than 1000.
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * License model information for the restored DB instance.
     *
     * License models for RDS for Db2 require additional configuration. The Bring Your Own License (BYOL) model requires a custom parameter group. The Db2 license through Amazon Web Services Marketplace model requires an Amazon Web Services Marketplace subscription. For more information, see [RDS for Db2 licensing options](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-licensing.html) in the *Amazon RDS User Guide*.
     *
     * This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
     *
     * Valid Values:
     * + RDS for Db2 - `bring-your-own-license | marketplace-license`
     * + RDS for MariaDB - `general-public-license`
     * + RDS for Microsoft SQL Server - `license-included`
     * + RDS for MySQL - `general-public-license`
     * + RDS for Oracle - `bring-your-own-license | license-included`
     * + RDS for PostgreSQL - `postgresql-license`
     *
     * Default: Same as the source.
     */
    public val licenseModel: kotlin.String? = builder.licenseModel
    /**
     * Specifies whether the DB instance is a Multi-AZ deployment.
     *
     * This setting doesn't apply to RDS Custom.
     *
     * Constraint: You can't specify the `AvailabilityZone` parameter if the DB instance is a Multi-AZ deployment.
     */
    public val multiAz: kotlin.Boolean? = builder.multiAz
    /**
     * The network type of the DB instance.
     *
     * Valid Values:
     * + `IPV4`
     * + `DUAL`
     *
     * The network type is determined by the `DBSubnetGroup` specified for the DB instance. A `DBSubnetGroup` can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (`DUAL`).
     *
     * For more information, see [ Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon RDS User Guide.*
     */
    public val networkType: kotlin.String? = builder.networkType
    /**
     * The name of the option group to be used for the restored DB instance.
     *
     * Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group, and that option group can't be removed from a DB instance after it is associated with a DB instance.
     *
     * This setting doesn't apply to RDS Custom.
     */
    public val optionGroupName: kotlin.String? = builder.optionGroupName
    /**
     * The port number on which the database accepts connections.
     *
     * Default: The same port as the original DB instance
     *
     * Constraints: Value must be `1150-65535`
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
     *
     * This setting doesn't apply to RDS Custom.
     */
    public val processorFeatures: List<ProcessorFeature>? = builder.processorFeatures
    /**
     * Specifies whether the DB instance is publicly accessible.
     *
     * When the DB instance is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB instance's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB instance doesn't permit it.
     *
     * When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.
     *
     * For more information, see CreateDBInstance.
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * Specifies the storage throughput value for the DB instance.
     *
     * This setting doesn't apply to RDS Custom or Amazon Aurora.
     */
    public val storageThroughput: kotlin.Int? = builder.storageThroughput
    /**
     * Specifies the storage type to be associated with the DB instance.
     *
     * Valid Values: `gp2 | gp3 | io1 | io2 | standard`
     *
     * If you specify `io1`, `io2`, or `gp3`, you must also include a value for the `Iops` parameter.
     *
     * Default: `io1` if the `Iops` parameter is specified, otherwise `gp2`
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The ARN from the key store with which to associate the instance for TDE encryption.
     *
     * This setting doesn't apply to RDS Custom.
     */
    public val tdeCredentialArn: kotlin.String? = builder.tdeCredentialArn
    /**
     * The password for the given ARN from the key store in order to access the device.
     *
     * This setting doesn't apply to RDS Custom.
     */
    public val tdeCredentialPassword: kotlin.String? = builder.tdeCredentialPassword
    /**
     * Specifies whether the DB instance class of the DB instance uses its default processor features.
     *
     * This setting doesn't apply to RDS Custom.
     */
    public val useDefaultProcessorFeatures: kotlin.Boolean? = builder.useDefaultProcessorFeatures
    /**
     * A list of EC2 VPC security groups to associate with this DB instance.
     *
     * Default: The default EC2 VPC security group for the DB subnet group's VPC.
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.RestoreDbInstanceFromDbSnapshotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreDbInstanceFromDbSnapshotRequest(")
        append("allocatedStorage=$allocatedStorage,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("availabilityZone=$availabilityZone,")
        append("backupTarget=$backupTarget,")
        append("caCertificateIdentifier=$caCertificateIdentifier,")
        append("copyTagsToSnapshot=$copyTagsToSnapshot,")
        append("customIamInstanceProfile=$customIamInstanceProfile,")
        append("dbClusterSnapshotIdentifier=$dbClusterSnapshotIdentifier,")
        append("dbInstanceClass=$dbInstanceClass,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("dbName=$dbName,")
        append("dbParameterGroupName=$dbParameterGroupName,")
        append("dbSnapshotIdentifier=$dbSnapshotIdentifier,")
        append("dbSubnetGroupName=$dbSubnetGroupName,")
        append("dedicatedLogVolume=$dedicatedLogVolume,")
        append("deletionProtection=$deletionProtection,")
        append("domain=$domain,")
        append("domainAuthSecretArn=$domainAuthSecretArn,")
        append("domainDnsIps=$domainDnsIps,")
        append("domainFqdn=$domainFqdn,")
        append("domainIamRoleName=$domainIamRoleName,")
        append("domainOu=$domainOu,")
        append("enableCloudwatchLogsExports=$enableCloudwatchLogsExports,")
        append("enableCustomerOwnedIp=$enableCustomerOwnedIp,")
        append("enableIamDatabaseAuthentication=$enableIamDatabaseAuthentication,")
        append("engine=$engine,")
        append("engineLifecycleSupport=$engineLifecycleSupport,")
        append("iops=$iops,")
        append("licenseModel=$licenseModel,")
        append("multiAz=$multiAz,")
        append("networkType=$networkType,")
        append("optionGroupName=$optionGroupName,")
        append("port=$port,")
        append("processorFeatures=$processorFeatures,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("storageThroughput=$storageThroughput,")
        append("storageType=$storageType,")
        append("tags=$tags,")
        append("tdeCredentialArn=$tdeCredentialArn,")
        append("tdeCredentialPassword=$tdeCredentialPassword,")
        append("useDefaultProcessorFeatures=$useDefaultProcessorFeatures,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (backupTarget?.hashCode() ?: 0)
        result = 31 * result + (caCertificateIdentifier?.hashCode() ?: 0)
        result = 31 * result + (copyTagsToSnapshot?.hashCode() ?: 0)
        result = 31 * result + (customIamInstanceProfile?.hashCode() ?: 0)
        result = 31 * result + (dbClusterSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbName?.hashCode() ?: 0)
        result = 31 * result + (dbParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (dbSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (dedicatedLogVolume?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (domainAuthSecretArn?.hashCode() ?: 0)
        result = 31 * result + (domainDnsIps?.hashCode() ?: 0)
        result = 31 * result + (domainFqdn?.hashCode() ?: 0)
        result = 31 * result + (domainIamRoleName?.hashCode() ?: 0)
        result = 31 * result + (domainOu?.hashCode() ?: 0)
        result = 31 * result + (enableCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (enableCustomerOwnedIp?.hashCode() ?: 0)
        result = 31 * result + (enableIamDatabaseAuthentication?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineLifecycleSupport?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (licenseModel?.hashCode() ?: 0)
        result = 31 * result + (multiAz?.hashCode() ?: 0)
        result = 31 * result + (networkType?.hashCode() ?: 0)
        result = 31 * result + (optionGroupName?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (processorFeatures?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (storageThroughput ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tdeCredentialArn?.hashCode() ?: 0)
        result = 31 * result + (tdeCredentialPassword?.hashCode() ?: 0)
        result = 31 * result + (useDefaultProcessorFeatures?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreDbInstanceFromDbSnapshotRequest

        if (allocatedStorage != other.allocatedStorage) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (availabilityZone != other.availabilityZone) return false
        if (backupTarget != other.backupTarget) return false
        if (caCertificateIdentifier != other.caCertificateIdentifier) return false
        if (copyTagsToSnapshot != other.copyTagsToSnapshot) return false
        if (customIamInstanceProfile != other.customIamInstanceProfile) return false
        if (dbClusterSnapshotIdentifier != other.dbClusterSnapshotIdentifier) return false
        if (dbInstanceClass != other.dbInstanceClass) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (dbName != other.dbName) return false
        if (dbParameterGroupName != other.dbParameterGroupName) return false
        if (dbSnapshotIdentifier != other.dbSnapshotIdentifier) return false
        if (dbSubnetGroupName != other.dbSubnetGroupName) return false
        if (dedicatedLogVolume != other.dedicatedLogVolume) return false
        if (deletionProtection != other.deletionProtection) return false
        if (domain != other.domain) return false
        if (domainAuthSecretArn != other.domainAuthSecretArn) return false
        if (domainDnsIps != other.domainDnsIps) return false
        if (domainFqdn != other.domainFqdn) return false
        if (domainIamRoleName != other.domainIamRoleName) return false
        if (domainOu != other.domainOu) return false
        if (enableCloudwatchLogsExports != other.enableCloudwatchLogsExports) return false
        if (enableCustomerOwnedIp != other.enableCustomerOwnedIp) return false
        if (enableIamDatabaseAuthentication != other.enableIamDatabaseAuthentication) return false
        if (engine != other.engine) return false
        if (engineLifecycleSupport != other.engineLifecycleSupport) return false
        if (iops != other.iops) return false
        if (licenseModel != other.licenseModel) return false
        if (multiAz != other.multiAz) return false
        if (networkType != other.networkType) return false
        if (optionGroupName != other.optionGroupName) return false
        if (port != other.port) return false
        if (processorFeatures != other.processorFeatures) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (storageThroughput != other.storageThroughput) return false
        if (storageType != other.storageType) return false
        if (tags != other.tags) return false
        if (tdeCredentialArn != other.tdeCredentialArn) return false
        if (tdeCredentialPassword != other.tdeCredentialPassword) return false
        if (useDefaultProcessorFeatures != other.useDefaultProcessorFeatures) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.RestoreDbInstanceFromDbSnapshotRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The amount of storage (in gibibytes) to allocate initially for the DB instance. Follow the allocation rules specified in CreateDBInstance.
         *
         * Be sure to allocate enough storage for your new DB instance so that the restore operation can succeed. You can also allocate additional storage for future growth.
         */
        public var allocatedStorage: kotlin.Int? = null
        /**
         * Specifies whether to automatically apply minor version upgrades to the DB instance during the maintenance window.
         *
         * If you restore an RDS Custom DB instance, you must disable this parameter.
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * The Availability Zone (AZ) where the DB instance will be created.
         *
         * Default: A random, system-chosen Availability Zone.
         *
         * Constraint: You can't specify the `AvailabilityZone` parameter if the DB instance is a Multi-AZ deployment.
         *
         * Example: `us-east-1a`
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * Specifies where automated backups and manual snapshots are stored for the restored DB instance.
         *
         * Possible values are `outposts` (Amazon Web Services Outposts) and `region` (Amazon Web Services Region). The default is `region`.
         *
         * For more information, see [Working with Amazon RDS on Amazon Web Services Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html) in the *Amazon RDS User Guide*.
         */
        public var backupTarget: kotlin.String? = null
        /**
         * The CA certificate identifier to use for the DB instance's server certificate.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         *
         * For more information, see [Using SSL/TLS to encrypt a connection to a DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html) in the *Amazon RDS User Guide* and [ Using SSL/TLS to encrypt a connection to a DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html) in the *Amazon Aurora User Guide*.
         */
        public var caCertificateIdentifier: kotlin.String? = null
        /**
         * Specifies whether to copy all tags from the restored DB instance to snapshots of the DB instance.
         *
         * In most cases, tags aren't copied by default. However, when you restore a DB instance from a DB snapshot, RDS checks whether you specify new tags. If yes, the new tags are added to the restored DB instance. If there are no new tags, RDS looks for the tags from the source DB instance for the DB snapshot, and then adds those tags to the restored DB instance.
         *
         * For more information, see [ Copying tags to DB instance snapshots](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.CopyTags) in the *Amazon RDS User Guide*.
         */
        public var copyTagsToSnapshot: kotlin.Boolean? = null
        /**
         * The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance. The instance profile must meet the following requirements:
         * + The profile must exist in your account.
         * + The profile must have an IAM role that Amazon EC2 has permissions to assume.
         * + The instance profile name and the associated IAM role name must start with the prefix `AWSRDSCustom`.
         *
         * For the list of permissions required for the IAM role, see [ Configure IAM and your VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc) in the *Amazon RDS User Guide*.
         *
         * This setting is required for RDS Custom.
         */
        public var customIamInstanceProfile: kotlin.String? = null
        /**
         * The identifier for the Multi-AZ DB cluster snapshot to restore from.
         *
         * For more information on Multi-AZ DB clusters, see [ Multi-AZ DB cluster deployments](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide*.
         *
         * Constraints:
         * + Must match the identifier of an existing Multi-AZ DB cluster snapshot.
         * + Can't be specified when `DBSnapshotIdentifier` is specified.
         * + Must be specified when `DBSnapshotIdentifier` isn't specified.
         * + If you are restoring from a shared manual Multi-AZ DB cluster snapshot, the `DBClusterSnapshotIdentifier` must be the ARN of the shared snapshot.
         * + Can't be the identifier of an Aurora DB cluster snapshot.
         */
        public var dbClusterSnapshotIdentifier: kotlin.String? = null
        /**
         * The compute and memory capacity of the Amazon RDS DB instance, for example db.m4.large. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see [DB Instance Class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the *Amazon RDS User Guide.*
         *
         * Default: The same DBInstanceClass as the original DB instance.
         */
        public var dbInstanceClass: kotlin.String? = null
        /**
         * The name of the DB instance to create from the DB snapshot. This parameter isn't case-sensitive.
         *
         * Constraints:
         * + Must contain from 1 to 63 numbers, letters, or hyphens.
         * + First character must be a letter.
         * + Can't end with a hyphen or contain two consecutive hyphens.
         *
         * Example: `my-snapshot-id`
         */
        public var dbInstanceIdentifier: kotlin.String? = null
        /**
         * The name of the database for the restored DB instance.
         *
         * This parameter only applies to RDS for Oracle and RDS for SQL Server DB instances. It doesn't apply to the other engines or to RDS Custom DB instances.
         */
        public var dbName: kotlin.String? = null
        /**
         * The name of the DB parameter group to associate with this DB instance.
         *
         * If you don't specify a value for `DBParameterGroupName`, then RDS uses the default `DBParameterGroup` for the specified DB engine.
         *
         * This setting doesn't apply to RDS Custom.
         *
         * Constraints:
         * + If supplied, must match the name of an existing DB parameter group.
         * + Must be 1 to 255 letters, numbers, or hyphens.
         * + First character must be a letter.
         * + Can't end with a hyphen or contain two consecutive hyphens.
         */
        public var dbParameterGroupName: kotlin.String? = null
        /**
         * The identifier for the DB snapshot to restore from.
         *
         * Constraints:
         * + Must match the identifier of an existing DB snapshot.
         * + Can't be specified when `DBClusterSnapshotIdentifier` is specified.
         * + Must be specified when `DBClusterSnapshotIdentifier` isn't specified.
         * + If you are restoring from a shared manual DB snapshot, the `DBSnapshotIdentifier` must be the ARN of the shared DB snapshot.
         */
        public var dbSnapshotIdentifier: kotlin.String? = null
        /**
         * The name of the DB subnet group to use for the new instance.
         *
         * Constraints:
         * + If supplied, must match the name of an existing DB subnet group.
         *
         * Example: `mydbsubnetgroup`
         */
        public var dbSubnetGroupName: kotlin.String? = null
        /**
         * Specifies whether to enable a dedicated log volume (DLV) for the DB instance.
         */
        public var dedicatedLogVolume: kotlin.Boolean? = null
        /**
         * Specifies whether to enable deletion protection for the DB instance. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see [ Deleting a DB Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * The Active Directory directory ID to restore the DB instance in. The domain/ must be created prior to this operation. Currently, you can create only Db2, MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances in an Active Directory Domain.
         *
         * For more information, see [ Kerberos Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html) in the *Amazon RDS User Guide*.
         *
         * This setting doesn't apply to RDS Custom.
         */
        public var domain: kotlin.String? = null
        /**
         * The ARN for the Secrets Manager secret with the credentials for the user joining the domain.
         *
         * Constraints:
         * + Can't be longer than 64 characters.
         *
         * Example: `arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456`
         */
        public var domainAuthSecretArn: kotlin.String? = null
        /**
         * The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.
         *
         * Constraints:
         * + Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of the primary domain controller for both entries in the list.
         *
         * Example: `123.124.125.126,234.235.236.237`
         */
        public var domainDnsIps: List<String>? = null
        /**
         * The fully qualified domain name (FQDN) of an Active Directory domain.
         *
         * Constraints:
         * + Can't be longer than 64 characters.
         *
         * Example: `mymanagedADtest.mymanagedAD.mydomain`
         */
        public var domainFqdn: kotlin.String? = null
        /**
         * The name of the IAM role to use when making API calls to the Directory Service.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var domainIamRoleName: kotlin.String? = null
        /**
         * The Active Directory organizational unit for your DB instance to join.
         *
         * Constraints:
         * + Must be in the distinguished name format.
         * + Can't be longer than 64 characters.
         *
         * Example: `OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain`
         */
        public var domainOu: kotlin.String? = null
        /**
         * The list of logs for the restored DB instance to export to CloudWatch Logs. The values in the list depend on the DB engine. For more information, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon RDS User Guide*.
         *
         * This setting doesn't apply to RDS Custom.
         */
        public var enableCloudwatchLogsExports: List<String>? = null
        /**
         * Specifies whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance.
         *
         * A *CoIP* provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from outside of its virtual private cloud (VPC) on your local network.
         *
         * This setting doesn't apply to RDS Custom.
         *
         * For more information about RDS on Outposts, see [Working with Amazon RDS on Amazon Web Services Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html) in the *Amazon RDS User Guide*.
         *
         * For more information about CoIPs, see [Customer-owned IP addresses](https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing) in the *Amazon Web Services Outposts User Guide*.
         */
        public var enableCustomerOwnedIp: kotlin.Boolean? = null
        /**
         * Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.
         *
         * For more information about IAM database authentication, see [ IAM Database Authentication for MySQL and PostgreSQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html) in the *Amazon RDS User Guide.*
         *
         * This setting doesn't apply to RDS Custom.
         */
        public var enableIamDatabaseAuthentication: kotlin.Boolean? = null
        /**
         * The database engine to use for the new instance.
         *
         * This setting doesn't apply to RDS Custom.
         *
         * Default: The same as source
         *
         * Constraint: Must be compatible with the engine of the source. For example, you can restore a MariaDB 10.1 DB instance from a MySQL 5.6 snapshot.
         *
         * Valid Values:
         * + `db2-ae`
         * + `db2-se`
         * + `mariadb`
         * + `mysql`
         * + `oracle-ee`
         * + `oracle-ee-cdb`
         * + `oracle-se2`
         * + `oracle-se2-cdb`
         * + `postgres`
         * + `sqlserver-ee`
         * + `sqlserver-se`
         * + `sqlserver-ex`
         * + `sqlserver-web`
         */
        public var engine: kotlin.String? = null
        /**
         * The life cycle type for this DB instance.
         *
         * By default, this value is set to `open-source-rds-extended-support`, which enrolls your DB instance into Amazon RDS Extended Support. At the end of standard support, you can avoid charges for Extended Support by setting the value to `open-source-rds-extended-support-disabled`. In this case, RDS automatically upgrades your restored DB instance to a higher engine version, if the major engine version is past its end of standard support date.
         *
         * You can use this setting to enroll your DB instance into Amazon RDS Extended Support. With RDS Extended Support, you can run the selected major engine version on your DB instance past the end of standard support for that engine version. For more information, see [Using Amazon RDS Extended Support](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html) in the *Amazon RDS User Guide*.
         *
         * This setting applies only to RDS for MySQL and RDS for PostgreSQL. For Amazon Aurora DB instances, the life cycle type is managed by the DB cluster.
         *
         * Valid Values: `open-source-rds-extended-support | open-source-rds-extended-support-disabled`
         *
         * Default: `open-source-rds-extended-support`
         */
        public var engineLifecycleSupport: kotlin.String? = null
        /**
         * Specifies the amount of provisioned IOPS for the DB instance, expressed in I/O operations per second. If this parameter isn't specified, the IOPS value is taken from the backup. If this parameter is set to 0, the new instance is converted to a non-PIOPS instance. The conversion takes additional time, though your DB instance is available for connections before the conversion starts.
         *
         * The provisioned IOPS value must follow the requirements for your database engine. For more information, see [Amazon RDS Provisioned IOPS storage](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS) in the *Amazon RDS User Guide.*
         *
         * Constraints: Must be an integer greater than 1000.
         */
        public var iops: kotlin.Int? = null
        /**
         * License model information for the restored DB instance.
         *
         * License models for RDS for Db2 require additional configuration. The Bring Your Own License (BYOL) model requires a custom parameter group. The Db2 license through Amazon Web Services Marketplace model requires an Amazon Web Services Marketplace subscription. For more information, see [RDS for Db2 licensing options](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-licensing.html) in the *Amazon RDS User Guide*.
         *
         * This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
         *
         * Valid Values:
         * + RDS for Db2 - `bring-your-own-license | marketplace-license`
         * + RDS for MariaDB - `general-public-license`
         * + RDS for Microsoft SQL Server - `license-included`
         * + RDS for MySQL - `general-public-license`
         * + RDS for Oracle - `bring-your-own-license | license-included`
         * + RDS for PostgreSQL - `postgresql-license`
         *
         * Default: Same as the source.
         */
        public var licenseModel: kotlin.String? = null
        /**
         * Specifies whether the DB instance is a Multi-AZ deployment.
         *
         * This setting doesn't apply to RDS Custom.
         *
         * Constraint: You can't specify the `AvailabilityZone` parameter if the DB instance is a Multi-AZ deployment.
         */
        public var multiAz: kotlin.Boolean? = null
        /**
         * The network type of the DB instance.
         *
         * Valid Values:
         * + `IPV4`
         * + `DUAL`
         *
         * The network type is determined by the `DBSubnetGroup` specified for the DB instance. A `DBSubnetGroup` can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (`DUAL`).
         *
         * For more information, see [ Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon RDS User Guide.*
         */
        public var networkType: kotlin.String? = null
        /**
         * The name of the option group to be used for the restored DB instance.
         *
         * Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group, and that option group can't be removed from a DB instance after it is associated with a DB instance.
         *
         * This setting doesn't apply to RDS Custom.
         */
        public var optionGroupName: kotlin.String? = null
        /**
         * The port number on which the database accepts connections.
         *
         * Default: The same port as the original DB instance
         *
         * Constraints: Value must be `1150-65535`
         */
        public var port: kotlin.Int? = null
        /**
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         *
         * This setting doesn't apply to RDS Custom.
         */
        public var processorFeatures: List<ProcessorFeature>? = null
        /**
         * Specifies whether the DB instance is publicly accessible.
         *
         * When the DB instance is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB instance's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB instance doesn't permit it.
         *
         * When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.
         *
         * For more information, see CreateDBInstance.
         */
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * Specifies the storage throughput value for the DB instance.
         *
         * This setting doesn't apply to RDS Custom or Amazon Aurora.
         */
        public var storageThroughput: kotlin.Int? = null
        /**
         * Specifies the storage type to be associated with the DB instance.
         *
         * Valid Values: `gp2 | gp3 | io1 | io2 | standard`
         *
         * If you specify `io1`, `io2`, or `gp3`, you must also include a value for the `Iops` parameter.
         *
         * Default: `io1` if the `Iops` parameter is specified, otherwise `gp2`
         */
        public var storageType: kotlin.String? = null
        /**
         * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
         */
        public var tags: List<Tag>? = null
        /**
         * The ARN from the key store with which to associate the instance for TDE encryption.
         *
         * This setting doesn't apply to RDS Custom.
         */
        public var tdeCredentialArn: kotlin.String? = null
        /**
         * The password for the given ARN from the key store in order to access the device.
         *
         * This setting doesn't apply to RDS Custom.
         */
        public var tdeCredentialPassword: kotlin.String? = null
        /**
         * Specifies whether the DB instance class of the DB instance uses its default processor features.
         *
         * This setting doesn't apply to RDS Custom.
         */
        public var useDefaultProcessorFeatures: kotlin.Boolean? = null
        /**
         * A list of EC2 VPC security groups to associate with this DB instance.
         *
         * Default: The default EC2 VPC security group for the DB subnet group's VPC.
         */
        public var vpcSecurityGroupIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.RestoreDbInstanceFromDbSnapshotRequest) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.availabilityZone = x.availabilityZone
            this.backupTarget = x.backupTarget
            this.caCertificateIdentifier = x.caCertificateIdentifier
            this.copyTagsToSnapshot = x.copyTagsToSnapshot
            this.customIamInstanceProfile = x.customIamInstanceProfile
            this.dbClusterSnapshotIdentifier = x.dbClusterSnapshotIdentifier
            this.dbInstanceClass = x.dbInstanceClass
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.dbName = x.dbName
            this.dbParameterGroupName = x.dbParameterGroupName
            this.dbSnapshotIdentifier = x.dbSnapshotIdentifier
            this.dbSubnetGroupName = x.dbSubnetGroupName
            this.dedicatedLogVolume = x.dedicatedLogVolume
            this.deletionProtection = x.deletionProtection
            this.domain = x.domain
            this.domainAuthSecretArn = x.domainAuthSecretArn
            this.domainDnsIps = x.domainDnsIps
            this.domainFqdn = x.domainFqdn
            this.domainIamRoleName = x.domainIamRoleName
            this.domainOu = x.domainOu
            this.enableCloudwatchLogsExports = x.enableCloudwatchLogsExports
            this.enableCustomerOwnedIp = x.enableCustomerOwnedIp
            this.enableIamDatabaseAuthentication = x.enableIamDatabaseAuthentication
            this.engine = x.engine
            this.engineLifecycleSupport = x.engineLifecycleSupport
            this.iops = x.iops
            this.licenseModel = x.licenseModel
            this.multiAz = x.multiAz
            this.networkType = x.networkType
            this.optionGroupName = x.optionGroupName
            this.port = x.port
            this.processorFeatures = x.processorFeatures
            this.publiclyAccessible = x.publiclyAccessible
            this.storageThroughput = x.storageThroughput
            this.storageType = x.storageType
            this.tags = x.tags
            this.tdeCredentialArn = x.tdeCredentialArn
            this.tdeCredentialPassword = x.tdeCredentialPassword
            this.useDefaultProcessorFeatures = x.useDefaultProcessorFeatures
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.RestoreDbInstanceFromDbSnapshotRequest = RestoreDbInstanceFromDbSnapshotRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
