// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The recommended actions to apply to resolve the issues associated with your DB instances, DB clusters, and DB parameter groups.
 */
public class RecommendedAction private constructor(builder: Builder) {
    /**
     * The unique identifier of the recommended action.
     */
    public val actionId: kotlin.String? = builder.actionId
    /**
     * The methods to apply the recommended action.
     *
     * Valid values:
     * + `manual` - The action requires you to resolve the recommendation manually.
     * + `immediately` - The action is applied immediately.
     * + `next-maintainance-window` - The action is applied during the next scheduled maintainance.
     */
    public val applyModes: List<String>? = builder.applyModes
    /**
     * The supporting attributes to explain the recommended action.
     */
    public val contextAttributes: List<ContextAttribute>? = builder.contextAttributes
    /**
     * A detailed description of the action. The description might contain markdown.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The details of the issue.
     */
    public val issueDetails: aws.sdk.kotlin.services.rds.model.IssueDetails? = builder.issueDetails
    /**
     * An API operation for the action.
     */
    public val operation: kotlin.String? = builder.operation
    /**
     * The parameters for the API operation.
     */
    public val parameters: List<RecommendedActionParameter>? = builder.parameters
    /**
     * The status of the action.
     * + `ready`
     * + `applied`
     * + `scheduled`
     * + `resolved`
     */
    public val status: kotlin.String? = builder.status
    /**
     * A short description to summarize the action. The description might contain markdown.
     */
    public val title: kotlin.String? = builder.title

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.RecommendedAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecommendedAction(")
        append("actionId=$actionId,")
        append("applyModes=$applyModes,")
        append("contextAttributes=$contextAttributes,")
        append("description=$description,")
        append("issueDetails=$issueDetails,")
        append("operation=$operation,")
        append("parameters=$parameters,")
        append("status=$status,")
        append("title=$title")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionId?.hashCode() ?: 0
        result = 31 * result + (applyModes?.hashCode() ?: 0)
        result = 31 * result + (contextAttributes?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (issueDetails?.hashCode() ?: 0)
        result = 31 * result + (operation?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecommendedAction

        if (actionId != other.actionId) return false
        if (applyModes != other.applyModes) return false
        if (contextAttributes != other.contextAttributes) return false
        if (description != other.description) return false
        if (issueDetails != other.issueDetails) return false
        if (operation != other.operation) return false
        if (parameters != other.parameters) return false
        if (status != other.status) return false
        if (title != other.title) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.RecommendedAction = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier of the recommended action.
         */
        public var actionId: kotlin.String? = null
        /**
         * The methods to apply the recommended action.
         *
         * Valid values:
         * + `manual` - The action requires you to resolve the recommendation manually.
         * + `immediately` - The action is applied immediately.
         * + `next-maintainance-window` - The action is applied during the next scheduled maintainance.
         */
        public var applyModes: List<String>? = null
        /**
         * The supporting attributes to explain the recommended action.
         */
        public var contextAttributes: List<ContextAttribute>? = null
        /**
         * A detailed description of the action. The description might contain markdown.
         */
        public var description: kotlin.String? = null
        /**
         * The details of the issue.
         */
        public var issueDetails: aws.sdk.kotlin.services.rds.model.IssueDetails? = null
        /**
         * An API operation for the action.
         */
        public var operation: kotlin.String? = null
        /**
         * The parameters for the API operation.
         */
        public var parameters: List<RecommendedActionParameter>? = null
        /**
         * The status of the action.
         * + `ready`
         * + `applied`
         * + `scheduled`
         * + `resolved`
         */
        public var status: kotlin.String? = null
        /**
         * A short description to summarize the action. The description might contain markdown.
         */
        public var title: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.RecommendedAction) : this() {
            this.actionId = x.actionId
            this.applyModes = x.applyModes
            this.contextAttributes = x.contextAttributes
            this.description = x.description
            this.issueDetails = x.issueDetails
            this.operation = x.operation
            this.parameters = x.parameters
            this.status = x.status
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.RecommendedAction = RecommendedAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.IssueDetails] inside the given [block]
         */
        public fun issueDetails(block: aws.sdk.kotlin.services.rds.model.IssueDetails.Builder.() -> kotlin.Unit) {
            this.issueDetails = aws.sdk.kotlin.services.rds.model.IssueDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
