// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.SdkDsl

public class RebootDbShardGroupResponse private constructor(builder: Builder) {
    /**
     * Specifies whether to create standby instances for the DB shard group. Valid values are the following:
     * + 0 - Creates a single, primary DB instance for each physical shard. This is the default value, and the only one supported for the preview.
     * + 1 - Creates a primary DB instance and a standby instance in a different Availability Zone (AZ) for each physical shard.
     * + 2 - Creates a primary DB instance and two standby instances in different AZs for each physical shard.
     */
    public val computeRedundancy: kotlin.Int? = builder.computeRedundancy
    /**
     * The name of the primary DB cluster for the DB shard group.
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The name of the DB shard group.
     */
    public val dbShardGroupIdentifier: kotlin.String? = builder.dbShardGroupIdentifier
    /**
     * The Amazon Web Services Region-unique, immutable identifier for the DB shard group.
     */
    public val dbShardGroupResourceId: kotlin.String? = builder.dbShardGroupResourceId
    /**
     * The connection endpoint for the DB shard group.
     */
    public val endpoint: kotlin.String? = builder.endpoint
    /**
     * The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
     */
    public val maxAcu: kotlin.Double? = builder.maxAcu
    /**
     * Indicates whether the DB shard group is publicly accessible.
     *
     * When the DB shard group is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB shard group's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB shard group's VPC. Access to the DB shard group is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB shard group doesn't permit it.
     *
     * When the DB shard group isn't publicly accessible, it is an internal DB shard group with a DNS name that resolves to a private IP address.
     *
     * For more information, see CreateDBShardGroup.
     *
     * This setting is only for Aurora Limitless Database.
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * The status of the DB shard group.
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.RebootDbShardGroupResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RebootDbShardGroupResponse(")
        append("computeRedundancy=$computeRedundancy,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbShardGroupIdentifier=$dbShardGroupIdentifier,")
        append("dbShardGroupResourceId=$dbShardGroupResourceId,")
        append("endpoint=$endpoint,")
        append("maxAcu=$maxAcu,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = computeRedundancy ?: 0
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbShardGroupIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbShardGroupResourceId?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (maxAcu?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RebootDbShardGroupResponse

        if (computeRedundancy != other.computeRedundancy) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbShardGroupIdentifier != other.dbShardGroupIdentifier) return false
        if (dbShardGroupResourceId != other.dbShardGroupResourceId) return false
        if (endpoint != other.endpoint) return false
        if (maxAcu != other.maxAcu) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.RebootDbShardGroupResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether to create standby instances for the DB shard group. Valid values are the following:
         * + 0 - Creates a single, primary DB instance for each physical shard. This is the default value, and the only one supported for the preview.
         * + 1 - Creates a primary DB instance and a standby instance in a different Availability Zone (AZ) for each physical shard.
         * + 2 - Creates a primary DB instance and two standby instances in different AZs for each physical shard.
         */
        public var computeRedundancy: kotlin.Int? = null
        /**
         * The name of the primary DB cluster for the DB shard group.
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The name of the DB shard group.
         */
        public var dbShardGroupIdentifier: kotlin.String? = null
        /**
         * The Amazon Web Services Region-unique, immutable identifier for the DB shard group.
         */
        public var dbShardGroupResourceId: kotlin.String? = null
        /**
         * The connection endpoint for the DB shard group.
         */
        public var endpoint: kotlin.String? = null
        /**
         * The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
         */
        public var maxAcu: kotlin.Double? = null
        /**
         * Indicates whether the DB shard group is publicly accessible.
         *
         * When the DB shard group is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB shard group's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB shard group's VPC. Access to the DB shard group is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB shard group doesn't permit it.
         *
         * When the DB shard group isn't publicly accessible, it is an internal DB shard group with a DNS name that resolves to a private IP address.
         *
         * For more information, see CreateDBShardGroup.
         *
         * This setting is only for Aurora Limitless Database.
         */
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * The status of the DB shard group.
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.RebootDbShardGroupResponse) : this() {
            this.computeRedundancy = x.computeRedundancy
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbShardGroupIdentifier = x.dbShardGroupIdentifier
            this.dbShardGroupResourceId = x.dbShardGroupResourceId
            this.endpoint = x.endpoint
            this.maxAcu = x.maxAcu
            this.publiclyAccessible = x.publiclyAccessible
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.RebootDbShardGroupResponse = RebootDbShardGroupResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
